/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;

public class GetAllChildrenExpression
extends Expression {
    private Expression object;
    private Expression property;
    private int dotdot = -1;

    public GetAllChildrenExpression(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.object != null) {
                this.object.traverse(visitor);
            }
            if (this.property != null) {
                this.property.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getObject() {
        return this.object;
    }

    public void setObject(Expression object) {
        this.object = object;
    }

    public Expression getProperty() {
        return this.property;
    }

    public void setProperty(Expression property) {
        this.property = property;
    }

    public int getDotDotPosition() {
        return this.dotdot;
    }

    public void setDotDotPosition(int dot) {
        this.dotdot = dot;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.dotdot > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.object.toSourceString(indentationString));
        buffer.append("..");
        buffer.append(this.property.toSourceString(indentationString));
        return buffer.toString();
    }
}

