/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.rhino.dbgp;

import java.io.UnsupportedEncodingException;
import org.eclipse.dltk.rhino.dbgp.Base64;

public class Base64Helper {
    private static final String DATA_ENCODING = "UTF-8";
    private static final String BYTE_ENCODING = "ISO-8859-1";
    private static final String EMPTY = "";

    public static String encodeString(String s) {
        if (s != null && s.length() != 0) {
            try {
                byte[] encode = Base64.encode(s.getBytes(DATA_ENCODING));
                return new String(encode, BYTE_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return EMPTY;
    }

    public static String decodeString(String base64) {
        if (base64 != null && base64.length() != 0) {
            try {
                byte[] bytes = base64.getBytes(BYTE_ENCODING);
                int length = Base64Helper.discardWhitespace(bytes);
                if (length > 0) {
                    int decodedLength = Base64.decodeInlplace(bytes, length);
                    return new String(bytes, 0, decodedLength, DATA_ENCODING);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return EMPTY;
    }

    private static int discardWhitespace(byte[] data) {
        int length = data.length;
        int i = 0;
        while (i < length) {
            byte c;
            if ((c = data[i++]) != 32 && c != 10 && c != 13 && c != 9) continue;
            int count = i - 1;
            while (i < length) {
                if ((c = data[i++]) == 32 || c == 10 || c == 13 || c == 9) continue;
                data[count++] = c;
            }
            return count;
        }
        return length;
    }

    public static String encodeBytes(byte[] bytes) {
        return new String(Base64.encode(bytes));
    }

    public static byte[] decodeBytes(String base64) {
        return Base64.decode(base64.getBytes());
    }
}

