/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.javascript.corext.refactoring.ParameterInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.structure.ChangeSignatureProcessor;
import org.eclipse.dltk.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.javascript.internal.ui.refactoring.ChangeParametersControl;
import org.eclipse.dltk.javascript.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ChangeSignatureWizard
extends RefactoringWizard {
    private final ChangeSignatureProcessor fProcessor;

    public ChangeSignatureWizard(ChangeSignatureProcessor processor, Refactoring refactoring) {
        super(refactoring, 4);
        this.fProcessor = processor;
        this.setDefaultPageTitle(RefactoringMessages.ChangeSignatureRefactoring_modify_Parameters);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new ChangeSignatureInputPage(this.fProcessor));
    }

    private static class ChangeSignatureInputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "ChangeSignatureInputPage";
        private ScriptSourceViewer fSignaturePreview;
        private Document fSignaturePreviewDocument;
        private final ChangeSignatureProcessor fProcessor;

        public ChangeSignatureInputPage(ChangeSignatureProcessor processor) {
            super(PAGE_NAME);
            this.fProcessor = processor;
            this.setMessage(RefactoringMessages.ChangeSignatureInputPage_change);
            this.fSignaturePreviewDocument = new Document();
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            this.initializeDialogUnits((Control)composite);
            try {
                this.createHeadControls(composite);
                this.createParameterTableControl(composite);
                Label sep = new Label(composite, 258);
                sep.setLayoutData((Object)new GridData(768));
                this.createSignaturePreview(composite);
                this.update(false);
                this.setControl((Control)composite);
                Dialog.applyDialogFont((Control)composite);
            }
            catch (ModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), (String)RefactoringMessages.ChangeSignatureInputPage_Change_Signature, (String)RefactoringMessages.ChangeSignatureInputPage_Internal_Error);
            }
        }

        private void createHeadControls(Composite parent) throws ModelException {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            this.createNameControl(composite);
        }

        private void createNameControl(Composite parent) {
            Composite name = new Composite(parent, 0);
            name.setLayoutData((Object)new GridData(1808));
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            name.setLayout((Layout)layout);
            Label label = new Label(name, 0);
            label.setText(RefactoringMessages.ChangeSignatureInputPage_method_name);
            final Text text = new Text(name, 2048);
            text.setText(this.fProcessor.getMethodName());
            text.setLayoutData((Object)new GridData(768));
            TextFieldNavigationHandler.install((Text)text);
            if (this.fProcessor.canChangeNameAndReturnType()) {
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        ChangeSignatureInputPage.this.fProcessor.setNewMethodName(text.getText());
                        ChangeSignatureInputPage.this.update(true);
                    }
                });
            } else {
                text.setEnabled(false);
            }
        }

        private Control createParameterTableControl(Composite composite) {
            Composite border = new Composite(composite, 0);
            border.setLayoutData((Object)new GridData(1808));
            border.setLayout((Layout)new GridLayout());
            String labelText = null;
            ChangeParametersControl cp = new ChangeParametersControl(border, 0, labelText, new IParameterListChangeListener(){

                @Override
                public void parameterChanged(ParameterInfo parameter) {
                    ChangeSignatureInputPage.this.update(true);
                }

                @Override
                public void parameterListChanged() {
                    ChangeSignatureInputPage.this.update(true);
                }

                @Override
                public void parameterAdded(ParameterInfo parameter) {
                    ChangeSignatureInputPage.this.update(true);
                }
            }, ChangeParametersControl.Mode.CHANGE_METHOD_SIGNATURE);
            cp.setLayoutData(new GridData(1808));
            cp.setInput(this.fProcessor.getParameterInfos());
            return border;
        }

        private void createSignaturePreview(Composite composite) {
            Label previewLabel = new Label(composite, 0);
            previewLabel.setText(RefactoringMessages.ChangeSignatureInputPage_method_Signature_Preview);
            IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit((String)"org.eclipse.dltk.javascript.core.nature");
            IPreferenceStore store = toolkit.getCombinedPreferenceStore();
            this.fSignaturePreview = new ScriptSourceViewer(composite, null, null, false, 584, store);
            this.fSignaturePreview.configure((SourceViewerConfiguration)new JavascriptSourceViewerConfiguration(toolkit.getTextTools().getColorManager(), store, null, null));
            this.fSignaturePreview.getTextWidget().setBackground(composite.getBackground());
            this.fSignaturePreview.setDocument((IDocument)this.fSignaturePreviewDocument);
            this.fSignaturePreview.setEditable(false);
            Control signaturePreviewControl = this.fSignaturePreview.getControl();
            PixelConverter pixelConverter = new PixelConverter(signaturePreviewControl);
            GridData gdata = new GridData(1808);
            gdata.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
            gdata.heightHint = pixelConverter.convertHeightInCharsToPixels(2);
            signaturePreviewControl.setLayoutData((Object)gdata);
        }

        private void update(boolean displayErrorMessage) {
            this.updateStatus(displayErrorMessage);
            this.updateSignaturePreview();
        }

        private void updateStatus(boolean displayErrorMessage) {
            try {
                if (this.fProcessor.isSignatureSameAsInitial()) {
                    if (displayErrorMessage) {
                        this.setErrorMessage(RefactoringMessages.ChangeSignatureInputPage_unchanged);
                    } else {
                        this.setErrorMessage(null);
                    }
                    this.setPageComplete(false);
                    return;
                }
                RefactoringStatus nameCheck = this.fProcessor.checkSignature();
                if (displayErrorMessage) {
                    this.setPageComplete(nameCheck);
                } else {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                }
            }
            catch (ModelException e) {
                this.setErrorMessage(RefactoringMessages.ChangeSignatureInputPage_Internal_Error);
                this.setPageComplete(false);
                DLTKUIPlugin.log((Throwable)e);
            }
        }

        private void updateSignaturePreview() {
            try {
                int top = this.fSignaturePreview.getTextWidget().getTopPixel();
                this.fSignaturePreviewDocument.set(this.fProcessor.getNewMethodSignature());
                this.fSignaturePreview.getTextWidget().setTopPixel(top);
            }
            catch (ModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), (String)RefactoringMessages.ChangeSignatureRefactoring_modify_Parameters, (String)RefactoringMessages.ChangeSignatureInputPage_exception);
            }
        }
    }
}

