/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.dltk.javascript.internal.ui.refactoring.code.InlineMethodWizard;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class InlineMethodAction
implements IEditorActionDelegate {
    private ScriptEditor editor;
    private ISelection selection;

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        this.checkEnabled(action);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor instanceof ScriptEditor ? (ScriptEditor)targetEditor : null;
        this.checkEnabled(action);
    }

    public void checkEnabled(IAction action) {
        try {
            action.setEnabled(this.isInlineMethodAvailable());
        }
        catch (ModelException e) {
            if (ScriptModelUtil.isExceptionToBeLogged((CoreException)e)) {
                DLTKUIPlugin.log((Throwable)e);
            }
            action.setEnabled(false);
        }
    }

    private boolean isInlineMethodAvailable() throws ModelException {
        if (this.selection instanceof ITextSelection) {
            return true;
        }
        if (!(this.selection instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection structured = (IStructuredSelection)this.selection;
        if (structured.size() != 1) {
            return false;
        }
        Object elem = structured.getFirstElement();
        if (!(elem instanceof IMethod)) {
            return false;
        }
        IMethod method = (IMethod)elem;
        return method.exists() && method.isStructureKnown() && !method.isConstructor() && SourceRange.isAvailable((ISourceRange)method.getNameRange());
    }

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            try {
                Assert.isTrue((boolean)this.isInlineMethodAvailable());
                IMethod method = (IMethod)((IStructuredSelection)this.selection).getFirstElement();
                ISourceRange nameRange = method.getNameRange();
                this.run(nameRange.getOffset(), nameRange.getLength(), method.getSourceModule());
            }
            catch (ModelException e) {
                ExceptionHandler.handle((CoreException)e, (Shell)this.editor.getSite().getShell(), (String)RefactoringMessages.InlineMethodAction_dialog_title, (String)RefactoringMessages.InlineMethodAction_unexpected_exception);
            }
        }
        if (this.selection instanceof ITextSelection) {
            ITextSelection text = (ITextSelection)this.selection;
            ISourceModule typeRoot = (ISourceModule)SelectionConverter.getInput((IEditorPart)this.editor);
            if (typeRoot == null) {
                return;
            }
            this.run(text.getOffset(), text.getLength(), typeRoot);
        }
    }

    private void run(int offset, int length, ISourceModule typeRoot) {
        InlineMethodRefactoring refactoring = new InlineMethodRefactoring(typeRoot, offset, length);
        try {
            new RefactoringStarter().activate((Refactoring)refactoring, (RefactoringWizard)new InlineMethodWizard(refactoring), this.editor.getSite().getShell(), RefactoringMessages.InlineMethodAction_dialog_title, false);
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)e, (String)RefactoringMessages.OpenRefactoringWizardAction_refactoring, (String)RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

