/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.compiler.problem.IValidationStatus;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.PhantomValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IRLocalType;
import org.eclipse.dltk.javascript.typeinfo.IRRecordMember;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.RRecordType;
import org.eclipse.dltk.javascript.typeinfo.RType;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;

class RLocalType
extends RType
implements IRLocalType {
    private final IValueReference functionValue;
    private final String name;

    RLocalType(String name, IValueReference functionValue) {
        this.name = name;
        this.functionValue = functionValue;
    }

    @Override
    public IValueReference getValue() {
        IValueCollection value = (IValueCollection)this.functionValue.getAttribute("FUNCTION_SCOPE", false);
        if (value != null) {
            return value.getThis();
        }
        return PhantomValueReference.REFERENCE;
    }

    @Override
    public IValueReference getDirectChild(String name) {
        return this.getChild(this, name, new HashSet<IRType>());
    }

    private IValueReference getChildFromDeclaredTypes(String name, JSTypeSet declaredTypes, HashSet<IRType> set) {
        for (IRType irType : declaredTypes) {
            IValueReference child;
            if (!(irType instanceof RLocalType) || (child = this.getChild((RLocalType)irType, name, set)) == null) continue;
            return child;
        }
        return null;
    }

    private IValueReference getChild(RLocalType irType, String name, HashSet<IRType> set) {
        if (set.add(irType)) {
            IValueReference prototype;
            IValueReference declaredValue = irType.getValue();
            if (declaredValue.getDirectChildren(2).contains(name)) {
                return declaredValue.getChild(name);
            }
            IValueReference fromChild = this.getChildFromDeclaredTypes(name, declaredValue.getDeclaredTypes(), set);
            if (fromChild == null && !(fromChild = (prototype = irType.functionValue.getChild("prototype")).getChild(name)).exists()) {
                fromChild = null;
            }
            return fromChild;
        }
        return null;
    }

    @Override
    public Set<String> getDirectChildren() {
        HashSet<String> children = new HashSet<String>();
        RLocalType.fillChildren(this, children, new HashSet<IRType>());
        return children;
    }

    private static void fillChildren(RLocalType rLocalType, Set<String> children, HashSet<IRType> set) {
        if (set.add(rLocalType)) {
            IValueReference value = rLocalType.getValue();
            children.addAll(value.getDirectChildren(2));
            IValueReference prototype = rLocalType.functionValue.getChild("prototype");
            children.addAll(prototype.getDirectChildren());
            RLocalType.fillDeclaredLocalTypesChildren(children, prototype.getTypes(), set);
            RLocalType.fillDeclaredLocalTypesChildren(children, value.getDeclaredTypes(), set);
        }
    }

    private static void fillDeclaredLocalTypesChildren(Set<String> children, JSTypeSet declaredTypes, HashSet<IRType> set) {
        for (IRType irType : declaredTypes) {
            if (irType instanceof RLocalType && set.add(irType)) {
                children.addAll(((RLocalType)irType).getValue().getDirectChildren(2));
                RLocalType.fillDeclaredLocalTypesChildren(children, ((RLocalType)irType).getValue().getDeclaredTypes(), set);
                continue;
            }
            if (!(irType instanceof RRecordType) || !set.add(irType)) continue;
            Collection<IRRecordMember> members = ((RRecordType)irType).getMembers();
            for (IRRecordMember member : members) {
                children.add(member.getName());
            }
        }
    }

    @Override
    public ReferenceLocation getReferenceLocation() {
        if (this.functionValue.getAttribute("LOCAL_TYPE_LOCATION") instanceof ReferenceLocation) {
            return (ReferenceLocation)this.functionValue.getAttribute("LOCAL_TYPE_LOCATION");
        }
        return this.functionValue.getLocation();
    }

    @Override
    public TypeCompatibility isAssignableFrom(IRType type) {
        if (type instanceof IRLocalType ? this.getReferenceLocation().equals(((IRLocalType)type).getReferenceLocation()) : type instanceof IRSimpleType && ((IRSimpleType)type).getTarget().getKind() == TypeKind.UNKNOWN && type.getName().equals(this.getName())) {
            return TypeCompatibility.TRUE;
        }
        return super.isAssignableFrom(type);
    }

    @Override
    public IValidationStatus isAssignableFrom(IValueReference argument) {
        if (argument == null) {
            return TypeCompatibility.TRUE;
        }
        Set<IRType> types = JavaScriptValidations.getTypes(argument);
        return this.testLocation(types, new HashSet<IRType>());
    }

    private IValidationStatus testLocation(Iterable<IRType> types, HashSet<IRType> set) {
        for (IRType irType : types) {
            if (!(irType instanceof IRLocalType) || !set.add(irType)) continue;
            if (this.getReferenceLocation().equals(((IRLocalType)irType).getReferenceLocation())) {
                return TypeCompatibility.TRUE;
            }
            IValidationStatus status = this.testLocation(((IRLocalType)irType).getValue().getDeclaredTypes(), set);
            if (status != TypeCompatibility.TRUE) continue;
            return status;
        }
        return TypeCompatibility.FALSE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RLocalType) {
            return this.getReferenceLocation().equals(((RLocalType)obj).getReferenceLocation());
        }
        return false;
    }
}

