/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.rse;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.internal.rse.DLTKRSEPlugin;
import org.eclipse.dltk.core.internal.rse.RSEConnectionQueryManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class RSEConnector
implements RSEConnectionQueryManager.IConnector {
    private static boolean running = true;
    private Thread processingThread = null;
    private final Set<IHost> activeConnects = new HashSet<IHost>();

    private Thread createProcessingThread() {
        return new Thread("RSE connection resolver"){

            public void run() {
                while (running) {
                    if (RSEConnectionQueryManager.getInstance().hasHosts()) {
                        Display display = PlatformUI.getWorkbench().getDisplay();
                        if (PlatformUI.getWorkbench().isClosing()) {
                            IHost host = RSEConnectionQueryManager.getInstance().getNextHost(false);
                            if (host != null) {
                                RSEConnectionQueryManager.getInstance().markHostAsFinished(host);
                            }
                        } else {
                            display.syncExec(new Runnable(){

                                public void run() {
                                    IHost host = RSEConnectionQueryManager.getInstance().getNextHost(false);
                                    if (host != null) {
                                        RSEConnector.this.connect(host);
                                        RSEConnectionQueryManager.getInstance().markHostAsFinished(host);
                                    }
                                }
                            });
                        }
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        DLTKRSEPlugin.log((Throwable)e);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(IHost host) {
        ISubSystem[] subSystems;
        ISubSystem[] iSubSystemArray = subSystems = host.getSubSystems();
        int n = subSystems.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystem subsystem = iSubSystemArray[n2];
            if (subsystem instanceof IRemoteFileSubSystem) {
                try {
                    Set<IHost> set;
                    Set<IHost> set2 = this.activeConnects;
                    synchronized (set2) {
                        if (!this.activeConnects.add(host)) {
                            return;
                        }
                    }
                    try {
                        subsystem.connect((IProgressMonitor)new NullProgressMonitor(), false);
                    }
                    catch (Throwable throwable) {
                        set = this.activeConnects;
                        synchronized (set) {
                            this.activeConnects.remove(host);
                        }
                        throw throwable;
                    }
                    set = this.activeConnects;
                    synchronized (set) {
                        this.activeConnects.remove(host);
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (Exception e) {
                    DLTKRSEPlugin.log((Throwable)e);
                }
            }
            ++n2;
        }
    }

    public boolean isDirectProcessingRequired() {
        Display current = Display.getCurrent();
        return current != null;
    }

    public void register() {
        if (this.processingThread == null) {
            this.processingThread = this.createProcessingThread();
            this.processingThread.start();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void runDisplayRunnables(long timeout) {
        end = System.currentTimeMillis() + timeout;
        current = Display.getCurrent();
        ** GOTO lbl11
        block0: while (!current.isDisposed()) {
            while (!current.readAndDispatch()) {
                if (end < System.currentTimeMillis()) break block0;
                host = RSEConnectionQueryManager.getInstance().getNextHost(false);
                if (host != null) {
                    this.connect(host);
                    RSEConnectionQueryManager.getInstance().markHostAsFinished(host);
                }
lbl11:
                // 4 sources

                if (RSEConnectionQueryManager.getInstance().hasHosts() && !current.isDisposed() && !PlatformUI.getWorkbench().isClosing()) continue;
            }
        }
    }

    public static void stop() {
        running = false;
    }
}

