/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.parser.structure;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.itcl.internal.core.parser.structure.ICommand;
import org.eclipse.dltk.tcl.ast.TclArgument;

class PrefixedCommandImpl
implements ICommand {
    private final ICommand command;

    public PrefixedCommandImpl(ICommand command) {
        this.command = command;
        Assert.isTrue((command.getArgumentCount() >= 1 ? 1 : 0) != 0);
    }

    public TclArgument getArgument(int index) {
        return this.command.getArgument(index + 1);
    }

    public int getArgumentCount() {
        return this.command.getArgumentCount() - 1;
    }

    public TclArgument[] getArguments() {
        TclArgument[] arguments = this.command.getArguments();
        if (arguments.length == 0) {
            throw new IllegalStateException("No more arguments in the original command");
        }
        TclArgument[] result = new TclArgument[arguments.length - 1];
        System.arraycopy(arguments, 1, 0, 0, arguments.length - 1);
        return result;
    }

    public TclArgument getName() {
        return this.command.getArgument(0);
    }

    public int getEnd() {
        return this.command.getEnd();
    }

    public int getStart() {
        return this.command.getArgument(0).getStart();
    }
}

