/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.hierarchy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ITypeHierarchyChangedListener;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.Region;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.TypeVector;
import org.eclipse.dltk.internal.core.hierarchy.ChangeCollector;
import org.eclipse.dltk.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.dltk.internal.core.hierarchy.IndexBasedHierarchyBuilder;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;

public class TypeHierarchy
implements ITypeHierarchy,
IElementChangedListener {
    public static boolean DEBUG = false;
    static final byte VERSION = 0;
    static final byte SEPARATOR1 = 10;
    static final byte SEPARATOR2 = 44;
    static final byte SEPARATOR3 = 62;
    static final byte SEPARATOR4 = 13;
    static final byte COMPUTE_SUBTYPES = 1;
    static final byte CLASS = 0;
    static final byte INTERFACE = 1;
    static final byte COMPUTED_FOR = 2;
    static final byte ROOT = 4;
    static final byte[] NO_FLAGS = new byte[0];
    static final int SIZE = 10;
    protected IScriptProject project;
    protected IType focusType;
    protected ISourceModule[] workingCopies;
    protected Map<IType, TypeVector> classToSuperclass;
    protected Map<IType, TypeVector> typeToSubtypes;
    protected Map<IType, Integer> typeFlags;
    protected Set<IType> exploredClasses;
    protected Set<IType> cyclicClasses;
    protected TypeVector rootClasses = new TypeVector();
    public ArrayList<String> missingTypes = new ArrayList(4);
    protected static final IType[] NO_TYPE = new IType[0];
    protected IProgressMonitor progressMonitor = null;
    protected ArrayList<ITypeHierarchyChangedListener> changeListeners = null;
    public Map<IOpenable, ArrayList<IType>> files = null;
    protected Region packageRegion = null;
    protected Region projectRegion = null;
    protected boolean computeSubtypes;
    IDLTKSearchScope scope;
    public boolean needsRefresh = true;
    protected ChangeCollector changeCollector;

    public TypeHierarchy() {
    }

    public TypeHierarchy(IType type, ISourceModule[] workingCopies, IScriptProject project, boolean computeSubtypes) {
        this(type, workingCopies, SearchEngine.createSearchScope(project), computeSubtypes);
        this.project = project;
    }

    public TypeHierarchy(IType type, ISourceModule[] workingCopies, IDLTKSearchScope scope, boolean computeSubtypes) {
        IType iType = this.focusType = type == null ? null : (IType)((Object)((ModelElement)((Object)type)));
        if (DLTKCore.DEBUG) {
            System.err.println("Bu possible. type should be unresolved...");
        }
        this.workingCopies = workingCopies;
        this.computeSubtypes = computeSubtypes;
        this.scope = scope;
    }

    protected void initializeRegions() {
        IType[] allTypes = this.getAllTypes();
        int i = 0;
        while (i < allTypes.length) {
            IType type = allTypes[i];
            Openable o = (Openable)((ModelElement)((Object)type)).getOpenableParent();
            if (o != null) {
                ArrayList<IType> types = this.files.get(o);
                if (types == null) {
                    types = new ArrayList();
                    this.files.put(o, types);
                }
                types.add(type);
            }
            IScriptFolder pkg = type.getScriptFolder();
            this.packageRegion.add(pkg);
            IScriptProject declaringProject = type.getScriptProject();
            if (declaringProject != null) {
                this.projectRegion.add(declaringProject);
            }
            this.checkCanceled();
            ++i;
        }
    }

    private void addAllCheckingDuplicates(ArrayList<IType> list, IType[] collection) {
        int i = 0;
        while (i < collection.length) {
            IType element = collection[i];
            if (!list.contains(element)) {
                list.add(element);
            }
            ++i;
        }
    }

    protected void addRootClass(IType type) {
        if (this.rootClasses.contains(type)) {
            return;
        }
        this.rootClasses.add(type);
    }

    protected void addSubtype(IType type, IType subtype) {
        this.cacheSuperclass(subtype, type);
    }

    @Override
    public synchronized void addTypeHierarchyChangedListener(ITypeHierarchyChangedListener listener) {
        ArrayList<ITypeHierarchyChangedListener> listeners = this.changeListeners;
        if (listeners == null) {
            listeners = new ArrayList();
            this.changeListeners = listeners;
        }
        if (listeners.size() == 0) {
            DLTKCore.addElementChangedListener(this);
        }
        if (listeners.indexOf(listener) == -1) {
            listeners.add(listener);
        }
    }

    private static Integer bytesToFlags(byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            return Integer.valueOf(new String(bytes));
        }
        return null;
    }

    public void cacheFlags(IType type, int flags) {
        this.typeFlags.put(type, flags);
    }

    protected void cacheSuperclass(IType type, IType superclass) {
        if (superclass != null) {
            TypeVector subtypes;
            TypeVector superTypes = this.classToSuperclass.get(type);
            if (superTypes == null) {
                superTypes = new TypeVector();
                this.classToSuperclass.put(type, superTypes);
            }
            if (!superTypes.contains(superclass)) {
                superTypes.add(superclass);
                this.resetClassPaths();
            }
            if ((subtypes = this.typeToSubtypes.get(superclass)) == null) {
                subtypes = new TypeVector();
                this.typeToSubtypes.put(superclass, subtypes);
            }
            if (!subtypes.contains(type)) {
                subtypes.add(type);
                this.resetClassPaths();
            }
        }
    }

    protected void checkCanceled() {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void compute() throws ModelException, CoreException {
        if (this.focusType != null) {
            IndexBasedHierarchyBuilder builder = new IndexBasedHierarchyBuilder(this, this.scope);
            ((HierarchyBuilder)builder).build(this.computeSubtypes);
        }
    }

    @Override
    public boolean contains(IType type) {
        if (this.classToSuperclass.get(type) != null) {
            return true;
        }
        return this.rootClasses.contains(type);
    }

    @Override
    public void elementChanged(ElementChangedEvent event) {
        if (this.needsRefresh) {
            return;
        }
        if (this.isAffected(event.getDelta())) {
            this.needsRefresh = true;
            this.fireChange();
        }
    }

    @Override
    public boolean exists() {
        if (!this.needsRefresh) {
            return true;
        }
        return (this.focusType == null || this.focusType.exists()) && this.javaProject().exists();
    }

    public void fireChange() {
        ArrayList listeners = this.changeListeners;
        if (listeners == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("FIRING hierarchy change [" + Thread.currentThread() + "]");
            if (this.focusType != null) {
                System.out.println("    for hierarchy focused on " + ((ModelElement)((Object)this.focusType)).toStringWithAncestors());
            }
        }
        listeners = (ArrayList)listeners.clone();
        int i = 0;
        while (i < listeners.size()) {
            final ITypeHierarchyChangedListener listener = (ITypeHierarchyChangedListener)listeners.get(i);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    Util.log(exception, "Exception occurred in listener of Type hierarchy change notification");
                }

                public void run() throws Exception {
                    listener.typeHierarchyChanged(TypeHierarchy.this);
                }
            });
            ++i;
        }
    }

    private static byte[] flagsToBytes(Integer flags) {
        if (flags != null) {
            return flags.toString().getBytes();
        }
        return NO_FLAGS;
    }

    @Override
    public IType[] getAllClasses() {
        TypeVector classes = this.rootClasses.copy();
        Iterator<IType> iter = this.classToSuperclass.keySet().iterator();
        while (iter.hasNext()) {
            classes.add(iter.next());
        }
        return classes.elements();
    }

    @Override
    public IType[] getAllSubtypes(IType type) {
        return this.getAllSubtypesForType(type);
    }

    private IType[] getAllSubtypesForType(IType type) {
        ArrayList<IType> subTypes = new ArrayList<IType>();
        this.getAllSubtypesForType0(type, subTypes, new HashSet<IType>());
        IType[] subClasses = new IType[subTypes.size()];
        subTypes.toArray(subClasses);
        return subClasses;
    }

    private void getAllSubtypesForType0(IType type, ArrayList<IType> subs, Set<IType> alreadyProcessed) {
        IType[] subTypes = this.getSubtypesForType(type);
        if (subTypes.length != 0) {
            int i = 0;
            while (i < subTypes.length) {
                IType subType = subTypes[i];
                if (!alreadyProcessed.contains(subType)) {
                    alreadyProcessed.add(subType);
                    subs.add(subType);
                    this.getAllSubtypesForType0(subType, subs, alreadyProcessed);
                }
                ++i;
            }
        }
    }

    @Override
    public IType[] getAllSuperclasses(IType type) {
        IType[] superclass = this.getSuperclass(type);
        TypeVector supers = new TypeVector();
        if (superclass == null) {
            return supers.elements();
        }
        int i = 0;
        while (i < superclass.length) {
            if (!type.equals(superclass[i])) {
                supers.add(superclass[i]);
                IType[] superclass2 = this.getAllSuperclasses(superclass[i]);
                supers.addAll(superclass2);
            }
            ++i;
        }
        return supers.elements();
    }

    @Override
    public IType[] getAllSupertypes(IType type) {
        ArrayList<IType> supers = new ArrayList<IType>();
        this.getAllSupertypes0(type, supers);
        IType[] supertypes = new IType[supers.size()];
        supers.toArray(supertypes);
        return supertypes;
    }

    private void getAllSupertypes0(IType type, ArrayList<IType> supers) {
        IType[] superclasses;
        TypeVector superTypes = this.classToSuperclass.get(type);
        if (superTypes != null && (superclasses = superTypes.elements()).length != 0) {
            this.addAllCheckingDuplicates(supers, superclasses);
            int i = 0;
            while (i < superclasses.length) {
                this.getAllSupertypes0(superclasses[i], supers);
                ++i;
            }
        }
    }

    @Override
    public IType[] getAllTypes() {
        return this.getAllClasses();
    }

    @Override
    public int getCachedFlags(IType type) {
        Integer flagObject = this.typeFlags.get(type);
        if (flagObject != null) {
            return flagObject;
        }
        return -1;
    }

    @Override
    public IType[] getRootClasses() {
        return this.rootClasses.elements();
    }

    @Override
    public IType[] getSubclasses(IType type) {
        return this.getSubtypesForType(type);
    }

    @Override
    public IType[] getSubtypes(IType type) {
        return this.getSubtypesForType(type);
    }

    private IType[] getSubtypesForType(IType type) {
        return this.filterSuperOrSubclasses(type, true);
    }

    @Override
    public IType[] getSuperclass(IType type) {
        return this.filterSuperOrSubclasses(type, false);
    }

    @Override
    public IType[] getSupertypes(IType type) {
        return this.getSuperclass(type);
    }

    @Override
    public IType getType() {
        return this.focusType;
    }

    protected IType[] growAndAddToArray(IType[] array, IType[] additions) {
        if (array == null || array.length == 0) {
            return additions;
        }
        IType[] old = array;
        array = new IType[old.length + additions.length];
        System.arraycopy(old, 0, array, 0, old.length);
        System.arraycopy(additions, 0, array, old.length, additions.length);
        return array;
    }

    protected IType[] growAndAddToArray(IType[] array, IType addition) {
        if (array == null || array.length == 0) {
            return new IType[]{addition};
        }
        IType[] old = array;
        array = new IType[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    public boolean hasFineGrainChanges() {
        ChangeCollector collector = this.changeCollector;
        return collector != null && collector.needsRefresh();
    }

    private boolean hasSubtypeNamed(String simpleName) {
        if (this.focusType != null && this.focusType.getElementName().equals(simpleName)) {
            return true;
        }
        IType[] types = this.focusType == null ? this.getAllTypes() : this.getAllSubtypes(this.focusType);
        int i = 0;
        while (i < types.length) {
            if (types[i].getElementName().equals(simpleName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasTypeNamed(String simpleName) {
        IType[] types = this.getAllTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i].getElementName().equals(simpleName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean includesTypeOrSupertype(IType type) {
        try {
            if (this.hasTypeNamed(type.getElementName())) {
                return true;
            }
            String[] superclassNames = type.getSuperClasses();
            if (superclassNames == null) return false;
            int i = 0;
            while (true) {
                if (i >= superclassNames.length) {
                    return false;
                }
                String superinterfaceName = superclassNames[i];
                int lastSeparator = superinterfaceName.lastIndexOf(46);
                String simpleName = superinterfaceName.substring(lastSeparator + 1);
                if (this.hasTypeNamed(simpleName)) {
                    return true;
                }
                ++i;
            }
        }
        catch (ModelException modelException) {}
        return false;
    }

    protected void initialize(int size) {
        if (size < 10) {
            size = 10;
        }
        int smallSize = size / 2;
        this.classToSuperclass = new HashMap<IType, TypeVector>(size);
        this.missingTypes = new ArrayList(smallSize);
        this.rootClasses = new TypeVector();
        this.typeToSubtypes = new HashMap<IType, TypeVector>(smallSize);
        this.typeFlags = new HashMap<IType, Integer>(smallSize);
        this.exploredClasses = new HashSet<IType>(smallSize);
        this.cyclicClasses = new HashSet<IType>(smallSize);
        this.projectRegion = new Region();
        this.packageRegion = new Region();
        this.files = new HashMap<IOpenable, ArrayList<IType>>(5);
    }

    public synchronized boolean isAffected(IModelElementDelta delta) {
        IModelElement element = delta.getElement();
        switch (element.getElementType()) {
            case 1: {
                return this.isAffectedByJavaModel(delta, element);
            }
            case 2: {
                return this.isAffectedByJavaProject(delta, element);
            }
            case 3: {
                return this.isAffectedByPackageFragmentRoot(delta, element);
            }
            case 4: {
                return this.isAffectedByPackageFragment(delta, (IScriptFolder)element);
            }
            case 5: {
                return this.isAffectedByOpenable(delta, element);
            }
        }
        return false;
    }

    private boolean isAffectedByChildren(IModelElementDelta delta) {
        if ((delta.getFlags() & 8) > 0) {
            IModelElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                if (this.isAffected(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isAffectedByJavaModel(IModelElementDelta delta, IModelElement element) {
        switch (delta.getKind()) {
            case 1: 
            case 2: {
                return element.equals(this.javaProject().getModel());
            }
            case 4: {
                return this.isAffectedByChildren(delta);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isAffectedByJavaProject(IModelElementDelta delta, IModelElement element) {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if ((flags & 0x200) != 0) {
            kind = 1;
        }
        if ((flags & 0x400) != 0) {
            kind = 2;
        }
        switch (kind) {
            case 1: {
                try {
                    IBuildpathEntry[] classpath = ((ScriptProject)this.javaProject()).getExpandedBuildpath();
                    int j = 0;
                    while (j < classpath.length) {
                        IBuildpathEntry element2 = classpath[j];
                        if (element2.getEntryKind() == 2 && element2.getPath().equals((Object)element.getPath())) {
                            return true;
                        }
                        ++j;
                    }
                    if (this.focusType != null) {
                        classpath = ((ScriptProject)element).getExpandedBuildpath();
                        IPath hierarchyProject = this.javaProject().getPath();
                        int j2 = 0;
                        while (j2 < classpath.length) {
                            IBuildpathEntry element2 = classpath[j2];
                            if (element2.getEntryKind() == 2 && element2.getPath().equals((Object)hierarchyProject)) {
                                return true;
                            }
                            ++j2;
                        }
                    }
                    return false;
                }
                catch (ModelException modelException) {
                    return false;
                }
            }
            case 2: {
                IModelElement[] pkgs = this.packageRegion.getElements();
                int i = 0;
                while (i < pkgs.length) {
                    IModelElement pkg = pkgs[i];
                    IScriptProject javaProject = pkg.getScriptProject();
                    if (javaProject != null && javaProject.equals(element)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case 4: {
                return this.isAffectedByChildren(delta);
            }
        }
        return false;
    }

    private boolean isAffectedByPackageFragment(IModelElementDelta delta, IScriptFolder element) {
        switch (delta.getKind()) {
            case 1: {
                return this.projectRegion.contains(element);
            }
            case 2: {
                return this.packageRegionContainsSamePackageFragment(element);
            }
            case 4: {
                return this.isAffectedByChildren(delta);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAffectedByPackageFragmentRoot(IModelElementDelta delta, IModelElement element) {
        switch (delta.getKind()) {
            case 1: {
                return this.projectRegion.contains(element);
            }
            case 2: 
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x40) > 0 && this.projectRegion != null) {
                    IProjectFragment root = (IProjectFragment)element;
                    IPath rootPath = root.getPath();
                    IModelElement[] elements = this.projectRegion.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        IModelElement element2 = elements[i];
                        ScriptProject javaProject = (ScriptProject)element2;
                        try {
                            IBuildpathEntry[] classpath = javaProject.getResolvedBuildpath();
                            int j = 0;
                            while (j < classpath.length) {
                                IBuildpathEntry entry = classpath[j];
                                if (entry.getPath().equals((Object)rootPath)) {
                                    return true;
                                }
                                ++j;
                            }
                        }
                        catch (ModelException modelException) {}
                        ++i;
                    }
                }
                if ((flags & 0x80) <= 0 && (flags & 1) <= 0) break;
                IModelElement[] pkgs = this.packageRegion.getElements();
                int i = 0;
                while (i < pkgs.length) {
                    if (pkgs[i].getParent().equals(element)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        }
        return this.isAffectedByChildren(delta);
    }

    protected boolean isAffectedByOpenable(IModelElementDelta delta, IModelElement element) {
        if (element instanceof SourceModule) {
            ChangeCollector collector;
            SourceModule cu;
            block5: {
                cu = (SourceModule)element;
                collector = this.changeCollector;
                if (collector == null) {
                    collector = new ChangeCollector(this);
                }
                try {
                    collector.addChange(cu, delta);
                }
                catch (ModelException e) {
                    if (!DEBUG) break block5;
                    e.printStackTrace();
                }
            }
            if (cu.isWorkingCopy()) {
                this.changeCollector = collector;
                return false;
            }
            return collector.needsRefresh();
        }
        return false;
    }

    public IScriptProject javaProject() {
        return this.focusType.getScriptProject();
    }

    protected static byte[] readUntil(InputStream input, byte separator) throws ModelException, IOException {
        return TypeHierarchy.readUntil(input, separator, 0);
    }

    protected static byte[] readUntil(InputStream input, byte separator, int offset) throws IOException, ModelException {
        byte b;
        int length = 0;
        byte[] bytes = new byte[10];
        while ((b = (byte)input.read()) != separator && b != -1) {
            if (bytes.length == length) {
                byte[] byArray = bytes;
                bytes = new byte[length * 2];
                System.arraycopy(byArray, 0, bytes, 0, length);
            }
            bytes[length++] = b;
        }
        if (b == -1) {
            throw new ModelException(new ModelStatus(4));
        }
        byte[] byArray = bytes;
        bytes = new byte[length + offset];
        System.arraycopy(byArray, 0, bytes, offset, length);
        return bytes;
    }

    public static ITypeHierarchy load(IType type, InputStream input, WorkingCopyOwner owner) throws ModelException {
        try {
            byte[] missing;
            byte b;
            byte[] bytes;
            TypeHierarchy typeHierarchy = new TypeHierarchy();
            typeHierarchy.initialize(1);
            IType[] types = new IType[10];
            int typeCount = 0;
            byte version = (byte)input.read();
            if (version != 0) {
                throw new ModelException(new ModelStatus(4));
            }
            byte generalInfo = (byte)input.read();
            if ((generalInfo & 1) != 0) {
                typeHierarchy.computeSubtypes = true;
            }
            if ((bytes = TypeHierarchy.readUntil(input, (byte)10)).length > 0) {
                typeHierarchy.project = (IScriptProject)DLTKCore.create(new String(bytes));
                typeHierarchy.scope = SearchEngine.createSearchScope(typeHierarchy.project);
            } else {
                typeHierarchy.project = null;
                typeHierarchy.scope = SearchEngine.createWorkspaceScope(DLTKLanguageManager.getLanguageToolkit(type));
            }
            bytes = TypeHierarchy.readUntil(input, (byte)10);
            int j = 0;
            int length = bytes.length;
            int i = 0;
            while (i < length) {
                b = bytes[i];
                if (b == 44) {
                    missing = new byte[i - j];
                    System.arraycopy(bytes, j, missing, 0, i - j);
                    typeHierarchy.missingTypes.add(new String(missing));
                    j = i + 1;
                }
                ++i;
            }
            missing = new byte[length - j];
            System.arraycopy(bytes, j, missing, 0, length - j);
            typeHierarchy.missingTypes.add(new String(missing));
            while ((b = (byte)input.read()) != 10 && b != -1) {
                byte info;
                bytes = TypeHierarchy.readUntil(input, (byte)13, 1);
                bytes[0] = b;
                IType element = (IType)DLTKCore.create(new String(bytes), owner);
                if (types.length == typeCount) {
                    IType[] iTypeArray = types;
                    types = new IType[typeCount * 2];
                    System.arraycopy(iTypeArray, 0, types, 0, typeCount);
                }
                types[typeCount++] = element;
                bytes = TypeHierarchy.readUntil(input, (byte)13);
                Integer flags = TypeHierarchy.bytesToFlags(bytes);
                if (flags != null) {
                    typeHierarchy.cacheFlags(element, flags);
                }
                if (((info = (byte)input.read()) & 2) != 0) {
                    if (!element.equals(type)) {
                        throw new ModelException(new ModelStatus(4));
                    }
                    typeHierarchy.focusType = element;
                }
                if ((info & 4) == 0) continue;
                typeHierarchy.addRootClass(element);
            }
            while ((b = (byte)input.read()) != 10 && b != -1) {
                bytes = TypeHierarchy.readUntil(input, (byte)62, 1);
                bytes[0] = b;
                int subClass = Integer.parseInt(new String(bytes));
                bytes = TypeHierarchy.readUntil(input, (byte)10);
                int superClass = Integer.parseInt(new String(bytes));
                typeHierarchy.cacheSuperclass(types[subClass], types[superClass]);
            }
            while ((b = (byte)input.read()) != 10 && b != -1) {
                bytes = TypeHierarchy.readUntil(input, (byte)62, 1);
                bytes[0] = b;
                bytes = TypeHierarchy.readUntil(input, (byte)10);
                IType[] superInterfaces = new IType[bytes.length / 2 + 1];
                int interfaceCount = 0;
                int j2 = 0;
                int i2 = 0;
                while (i2 < bytes.length) {
                    if (bytes[i2] == 44) {
                        byte[] b2 = new byte[i2 - j2];
                        System.arraycopy(bytes, j2, b2, 0, i2 - j2);
                        j2 = i2 + 1;
                        superInterfaces[interfaceCount++] = types[Integer.parseInt(new String(b2))];
                    }
                    ++i2;
                }
                byte[] b2 = new byte[bytes.length - j2];
                System.arraycopy(bytes, j2, b2, 0, bytes.length - j2);
                superInterfaces[interfaceCount++] = types[Integer.parseInt(new String(b2))];
                IType[] iTypeArray = superInterfaces;
                superInterfaces = new IType[interfaceCount];
                System.arraycopy(iTypeArray, 0, superInterfaces, 0, interfaceCount);
            }
            if (b == -1) {
                throw new ModelException(new ModelStatus(4));
            }
            return typeHierarchy;
        }
        catch (IOException e) {
            throw new ModelException(e, 985);
        }
        catch (CoreException e) {
            throw new ModelException(e, 10001);
        }
    }

    protected boolean packageRegionContainsSamePackageFragment(IScriptFolder element) {
        IModelElement[] pkgs = this.packageRegion.getElements();
        int i = 0;
        while (i < pkgs.length) {
            IScriptFolder pkg = (IScriptFolder)pkgs[i];
            if (pkg.getElementName().equals(element.getElementName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public synchronized void refresh(IProgressMonitor monitor) throws ModelException {
        try {
            try {
                this.progressMonitor = monitor;
                if (monitor != null) {
                    if (this.focusType != null) {
                        monitor.beginTask(Messages.bind(Messages.hierarchy_creatingOnType, this.focusType.getFullyQualifiedName()), 100);
                    } else {
                        monitor.beginTask(Messages.hierarchy_creating, 100);
                    }
                }
                long start = -1L;
                if (DEBUG) {
                    start = System.currentTimeMillis();
                    if (this.computeSubtypes) {
                        System.out.println("CREATING TYPE HIERARCHY [" + Thread.currentThread() + "]");
                    } else {
                        System.out.println("CREATING SUPER TYPE HIERARCHY [" + Thread.currentThread() + "]");
                    }
                    if (this.focusType != null) {
                        System.out.println("  on type " + ((ModelElement)((Object)this.focusType)).toStringWithAncestors());
                    }
                }
                this.compute();
                this.initializeRegions();
                this.needsRefresh = false;
                this.changeCollector = null;
                if (DEBUG) {
                    if (this.computeSubtypes) {
                        System.out.println("CREATED TYPE HIERARCHY in " + (System.currentTimeMillis() - start) + "ms");
                    } else {
                        System.out.println("CREATED SUPER TYPE HIERARCHY in " + (System.currentTimeMillis() - start) + "ms");
                    }
                    System.out.println(this.toString());
                }
            }
            catch (ModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new ModelException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
            this.progressMonitor = null;
        }
    }

    @Override
    public synchronized void removeTypeHierarchyChangedListener(ITypeHierarchyChangedListener listener) {
        ArrayList<ITypeHierarchyChangedListener> listeners = this.changeListeners;
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
        if (listeners.isEmpty()) {
            DLTKCore.removeElementChangedListener(this);
        }
    }

    @Override
    public void store(OutputStream output, IProgressMonitor monitor) throws ModelException {
        try {
            Hashtable<IType, Integer> hashtable = new Hashtable<IType, Integer>();
            Hashtable<Integer, IType> hashtable2 = new Hashtable<Integer, IType>();
            int count = 0;
            if (this.focusType != null) {
                Integer index = count++;
                hashtable.put(this.focusType, index);
                hashtable2.put(index, this.focusType);
            }
            Object[] types = this.classToSuperclass.entrySet().toArray();
            int k = 0;
            while (k < types.length) {
                TypeVector superClasses;
                Object type = types[k];
                Map.Entry entry = (Map.Entry)type;
                IType t = (IType)entry.getKey();
                if (hashtable.get(t) == null) {
                    Integer index = count++;
                    hashtable.put(t, index);
                    hashtable2.put(index, t);
                }
                if ((superClasses = (TypeVector)entry.getValue()) != null) {
                    IType[] sp = superClasses.elements();
                    int i = 0;
                    while (i < sp.length) {
                        IType superInterface = sp[i];
                        if (superInterface != null && hashtable.get(superInterface) == null) {
                            Integer index = count++;
                            hashtable.put(superInterface, index);
                            hashtable2.put(index, superInterface);
                        }
                        ++i;
                    }
                }
                ++k;
            }
            output.write(0);
            int generalInfo = 0;
            if (this.computeSubtypes) {
                generalInfo = (byte)(generalInfo | 1);
            }
            output.write(generalInfo);
            if (this.project != null) {
                output.write(this.project.getHandleIdentifier().getBytes());
            }
            output.write(10);
            int i = 0;
            while (i < this.missingTypes.size()) {
                if (i != 0) {
                    output.write(44);
                }
                output.write(this.missingTypes.get(i).getBytes());
                ++i;
            }
            output.write(10);
            i = 0;
            while (i < count) {
                IType t = (IType)hashtable2.get(i);
                output.write(t.getHandleIdentifier().getBytes());
                output.write(13);
                output.write(TypeHierarchy.flagsToBytes(this.typeFlags.get(t)));
                output.write(13);
                int info = 0;
                if (this.focusType != null && this.focusType.equals(t)) {
                    info = (byte)(info | 2);
                }
                if (this.rootClasses.contains(t)) {
                    info = (byte)(info | 4);
                }
                output.write(info);
                ++i;
            }
            output.write(10);
            types = this.classToSuperclass.entrySet().toArray();
            int q = 0;
            while (q < types.length) {
                IType[] values;
                Object type = types[q];
                Map.Entry entry = (Map.Entry)type;
                IModelElement key = (IModelElement)entry.getKey();
                TypeVector superTypes = (TypeVector)entry.getValue();
                if (superTypes != null && (values = superTypes.elements()).length > 0) {
                    output.write(((Integer)hashtable.get(key)).toString().getBytes());
                    output.write(62);
                    int j = 0;
                    while (j < values.length) {
                        IType value = values[j];
                        if (j != 0) {
                            output.write(44);
                        }
                        output.write(((Integer)hashtable.get(value)).toString().getBytes());
                        ++j;
                    }
                    output.write(10);
                }
                ++q;
            }
            output.write(10);
        }
        catch (IOException e) {
            throw new ModelException(e, 985);
        }
    }

    boolean subtypesIncludeSupertypeOf(IType type) {
        String[] superclassNames = null;
        try {
            superclassNames = type.getSuperClasses();
        }
        catch (ModelException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
        if (superclassNames != null) {
            int i = 0;
            while (i < superclassNames.length) {
                String simpleInterface;
                String interfaceName = superclassNames[i];
                int dot = -1;
                dot = interfaceName.lastIndexOf(46);
                String string = simpleInterface = dot > -1 ? interfaceName.substring(dot) : interfaceName;
                if (this.hasSubtypeNamed(simpleInterface)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Focus: ");
        buffer.append(this.focusType == null ? "<NONE>" : ((ModelElement)((Object)this.focusType)).toStringWithAncestors(false));
        buffer.append("\n");
        if (this.exists()) {
            int i;
            IModelElement[] roots;
            if (this.focusType != null) {
                buffer.append("Super types:\n");
                this.toString(buffer, this.focusType, 1, true);
                buffer.append("Sub types:\n");
                this.toString(buffer, this.focusType, 1, false);
            } else {
                buffer.append("Sub types of root classes:\n");
                roots = Util.sortCopy(this.getRootClasses());
                i = 0;
                while (i < roots.length) {
                    this.toString(buffer, (IType)roots[i], 1, false);
                    ++i;
                }
            }
            if (this.rootClasses.size > 1) {
                buffer.append("Root classes:\n");
                roots = Util.sortCopy(this.getRootClasses());
                i = 0;
                while (i < roots.length) {
                    this.toString(buffer, (IType)roots[i], 1, false);
                    ++i;
                }
            } else if (this.rootClasses.size == 0) {
                buffer.append("No root classes");
            }
        } else {
            buffer.append("(Hierarchy became stale)");
        }
        return buffer.toString();
    }

    private void toString(StringBuffer buffer, IType type, int indent, boolean ascendant) {
        IModelElement[] types = ascendant ? this.getSupertypes(type) : this.getSubtypes(type);
        IModelElement[] sortedTypes = Util.sortCopy(types);
        int i = 0;
        while (i < sortedTypes.length) {
            int j = 0;
            while (j < indent) {
                buffer.append("  ");
                ++j;
            }
            ModelElement element = (ModelElement)sortedTypes[i];
            buffer.append(element.toStringWithAncestors(false));
            buffer.append('\n');
            this.toString(buffer, (IType)types[i], indent + 1, ascendant);
            ++i;
        }
    }

    boolean hasSupertype(String simpleName) {
        for (TypeVector typeVector : this.classToSuperclass.values()) {
            if (typeVector == null) continue;
            IType[] elements = typeVector.elements();
            int i = 0;
            while (i < elements.length) {
                IType superType = elements[i];
                if (superType.getElementName().equals(simpleName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void worked(int work) {
        if (this.progressMonitor != null) {
            this.progressMonitor.worked(work);
            this.checkCanceled();
        }
    }

    protected boolean isExplored(IType type) {
        return this.exploredClasses.contains(type);
    }

    protected boolean isCyclic(IType type) {
        return this.cyclicClasses.contains(type);
    }

    protected void resetClassPaths() {
        this.exploredClasses.clear();
        this.cyclicClasses.clear();
    }

    void explore(LinkedList<IType> currentClassPath, IType currentClass) {
        if (currentClass == null) {
            return;
        }
        int idx = currentClassPath.indexOf(currentClass);
        if (idx == -1 && this.isExplored(currentClass) && !this.isCyclic(currentClass)) {
            return;
        }
        this.exploredClasses.add(currentClass);
        if (idx != -1) {
            this.cyclicClasses.addAll(currentClassPath.subList(idx, currentClassPath.size()));
            return;
        }
        TypeVector superclasses = this.classToSuperclass.get(currentClass);
        if (superclasses != null && superclasses.size > 0) {
            currentClassPath.addLast(currentClass);
            IType[] iTypeArray = superclasses.elements();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType superclass = iTypeArray[n2];
                this.explore(currentClassPath, superclass);
                ++n2;
            }
            currentClassPath.removeLast();
        }
    }

    IType[] filterSuperOrSubclasses(IType type, boolean isFilterForSubclasses) {
        TypeVector superOrSubclasses;
        if (type == null) {
            return TypeVector.NoElements;
        }
        if (!this.typeToSubtypes.containsKey(type) && !this.classToSuperclass.containsKey(type)) {
            return TypeVector.NoElements;
        }
        if (!this.isExplored(type)) {
            this.explore(new LinkedList<IType>(), type);
        }
        assert (this.isExplored(type));
        TypeVector typeVector = superOrSubclasses = isFilterForSubclasses ? this.typeToSubtypes.get(type) : this.classToSuperclass.get(type);
        if (superOrSubclasses == null) {
            return TypeVector.NoElements;
        }
        ArrayList<IType> l = new ArrayList<IType>();
        IType[] iTypeArray = superOrSubclasses.elements();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType superOrSubclass = iTypeArray[n2];
            if (isFilterForSubclasses && superOrSubclass != null && !this.isExplored(superOrSubclass)) {
                this.explore(new LinkedList<IType>(), superOrSubclass);
            }
            assert (superOrSubclass == null || this.isExplored(superOrSubclass));
            if (superOrSubclass == null || !this.isCyclic(superOrSubclass)) {
                l.add(superOrSubclass);
            }
            ++n2;
        }
        return l.toArray(new IType[l.size()]);
    }
}

