/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.internal.testing.MemberResolverManager;
import org.eclipse.dltk.internal.testing.model.TestElement;
import org.eclipse.dltk.internal.testing.model.TestRoot;
import org.eclipse.dltk.testing.ITestElementResolver;
import org.eclipse.dltk.testing.ITestingElementResolver;
import org.eclipse.dltk.testing.TestElementResolution;
import org.eclipse.dltk.testing.model.ITestCaseElement;
import org.eclipse.dltk.testing.model.ITestElement;

public class LegacyTestElementResolver
implements ITestElementResolver {
    private final IScriptProject project;
    private final ILaunchConfiguration launchConfiguration;

    public LegacyTestElementResolver(IScriptProject project, ILaunchConfiguration configuration) {
        this.project = project;
        this.launchConfiguration = configuration;
    }

    @Override
    public TestElementResolution resolveElement(ITestElement testElement) {
        String testName;
        int index;
        String engineId;
        try {
            engineId = this.launchConfiguration.getAttribute("org.eclipse.dltk.testing.engineId", null);
        }
        catch (CoreException e) {
            return null;
        }
        if (engineId == null) {
            return null;
        }
        ITestingElementResolver resolver = MemberResolverManager.getResolver(engineId);
        if (resolver == null) {
            return null;
        }
        ISourceModule module = this.resolveSourceModule();
        if (module == null) {
            return null;
        }
        String relativeName = this.getRootRelativeName((TestElement)testElement);
        IModelElement element = resolver.resolveElement(this.project, this.launchConfiguration, module, relativeName);
        if (element == null) {
            return null;
        }
        String method = testElement instanceof ITestCaseElement ? ((index = (testName = ((ITestCaseElement)testElement).getTestName()).indexOf(40)) > 0 ? testName.substring(0, index) : testName) : null;
        ISourceRange range = resolver.resolveRange(this.project, this.launchConfiguration, relativeName, module, element, method);
        return new TestElementResolution(element, range);
    }

    protected ISourceModule resolveSourceModule() {
        String scriptName;
        try {
            scriptName = this.launchConfiguration.getAttribute("mainScript", null);
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        IProject prj = this.project.getProject();
        IResource file = prj.findMember((IPath)new Path(scriptName));
        if (file instanceof IFile) {
            return (ISourceModule)DLTKCore.create((IResource)file);
        }
        return null;
    }

    private String getRootRelativeName(TestElement testCase) {
        String name = "";
        TestElement el = testCase;
        while (el != null) {
            name = name.length() != 0 ? String.valueOf(el.getTestName()) + "." + name : el.getTestName();
            if ((el = el.getParent()) instanceof TestRoot) break;
        }
        if (name.startsWith(".")) {
            return name.substring(1);
        }
        return name;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }
}

