/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.javascript.ast.DecimalLiteral;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.StringLiteral;

public class PropertyExpressionUtils {
    public static String getPath(Expression expression) {
        StringBuilder buffer = new StringBuilder();
        if (PropertyExpressionUtils.buildPath(buffer, expression)) {
            return buffer.toString();
        }
        return null;
    }

    public static Identifier getIdentifier(Expression expression) {
        if (expression instanceof Identifier) {
            return (Identifier)expression;
        }
        if (expression instanceof PropertyExpression) {
            PropertyExpression propertyExpression = (PropertyExpression)expression;
            Identifier identifier = PropertyExpressionUtils.getIdentifier(propertyExpression.getObject());
            if (identifier != null) {
                return identifier;
            }
            return PropertyExpressionUtils.getIdentifier(propertyExpression.getProperty());
        }
        if (expression instanceof FunctionStatement) {
            FunctionStatement functionStatement = (FunctionStatement)expression;
            return PropertyExpressionUtils.getIdentifier(functionStatement.getName());
        }
        return null;
    }

    private static boolean buildPath(StringBuilder buffer, Expression expression) {
        if (expression instanceof Identifier) {
            buffer.append(((Identifier)expression).getName());
            return true;
        }
        if (expression instanceof PropertyExpression) {
            PropertyExpression propertyExpression = (PropertyExpression)expression;
            if (!PropertyExpressionUtils.buildPath(buffer, propertyExpression.getObject())) {
                return false;
            }
            buffer.append('.');
            return PropertyExpressionUtils.buildPath(buffer, propertyExpression.getProperty());
        }
        if (expression instanceof FunctionStatement) {
            FunctionStatement functionStatement = (FunctionStatement)expression;
            return PropertyExpressionUtils.buildPath(buffer, functionStatement.getName());
        }
        return false;
    }

    public static boolean equals(Expression expression, String ... expressionPath) {
        block3: {
            int endIndex = expressionPath.length;
            if (endIndex <= 0) {
                return false;
            }
            while (true) {
                if (--endIndex == 0) {
                    return expression instanceof Identifier && expressionPath[endIndex].equals(((Identifier)expression).getName());
                }
                if (!(expression instanceof PropertyExpression)) break block3;
                PropertyExpression pe = (PropertyExpression)expression;
                if (!(pe.getProperty() instanceof Identifier) || !expressionPath[endIndex].equals(((Identifier)pe.getProperty()).getName())) break;
                expression = pe.getObject();
            }
            return false;
        }
        return false;
    }

    public static List<Identifier> getIdentifiers(PropertyExpression expression) {
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        PropertyExpressionUtils.collectIdentifiers(expression, identifiers);
        return identifiers;
    }

    private static void collectIdentifiers(PropertyExpression expression, List<Identifier> identifiers) {
        if (expression.getObject() instanceof PropertyExpression) {
            PropertyExpressionUtils.collectIdentifiers((PropertyExpression)expression.getObject(), identifiers);
        } else if (expression.getObject() instanceof Identifier) {
            identifiers.add((Identifier)expression.getObject());
        }
        if (expression.getProperty() instanceof Identifier) {
            identifiers.add((Identifier)expression.getProperty());
        }
    }

    public static String nameOf(Expression name) {
        if (name instanceof Identifier) {
            return ((Identifier)name).getName();
        }
        if (name instanceof StringLiteral) {
            return ((StringLiteral)name).getValue();
        }
        if (name instanceof DecimalLiteral) {
            return ((DecimalLiteral)name).getText();
        }
        return null;
    }
}

