/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.discovery;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.io.Resource;
import org.junit.platform.commons.io.ResourceFilter;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoveryFilter;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.support.discovery.ClassContainerSelectorResolver;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;
import org.junit.platform.engine.support.discovery.EngineDiscoveryRequestResolution;
import org.junit.platform.engine.support.discovery.ResourceContainerSelectorResolver;
import org.junit.platform.engine.support.discovery.SelectorResolver;

@API(status=API.Status.STABLE, since="1.10")
public class EngineDiscoveryRequestResolver<T extends TestDescriptor> {
    private final List<Function<InitializationContext<T>, SelectorResolver>> resolverCreators;
    private final List<Function<InitializationContext<T>, TestDescriptor.Visitor>> visitorCreators;

    private EngineDiscoveryRequestResolver(List<Function<InitializationContext<T>, SelectorResolver>> resolverCreators, List<Function<InitializationContext<T>, TestDescriptor.Visitor>> visitorCreators) {
        this.resolverCreators = new ArrayList<Function<InitializationContext<T>, SelectorResolver>>(resolverCreators);
        this.visitorCreators = new ArrayList<Function<InitializationContext<T>, TestDescriptor.Visitor>>(visitorCreators);
    }

    public void resolve(EngineDiscoveryRequest request, T engineDescriptor) {
        Preconditions.notNull((Object)request, (String)"request must not be null");
        Preconditions.notNull(engineDescriptor, (String)"engineDescriptor must not be null");
        DiscoveryIssueReporter issueReporter = DiscoveryIssueReporter.forwarding(request.getDiscoveryListener(), engineDescriptor.getUniqueId());
        this.resolve(request, engineDescriptor, issueReporter);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public void resolve(EngineDiscoveryRequest request, T engineDescriptor, DiscoveryIssueReporter issueReporter) {
        Preconditions.notNull((Object)request, (String)"request must not be null");
        Preconditions.notNull(engineDescriptor, (String)"engineDescriptor must not be null");
        Preconditions.notNull((Object)issueReporter, (String)"issueReporter must not be null");
        DefaultInitializationContext<T> initializationContext = new DefaultInitializationContext<T>(request, engineDescriptor, issueReporter);
        List<SelectorResolver> resolvers = this.instantiate(this.resolverCreators, initializationContext);
        List<TestDescriptor.Visitor> visitors = this.instantiate(this.visitorCreators, initializationContext);
        new EngineDiscoveryRequestResolution(request, (TestDescriptor)engineDescriptor, resolvers, visitors).run();
    }

    private <R> List<R> instantiate(List<Function<InitializationContext<T>, R>> creators, InitializationContext<T> context) {
        return creators.stream().map(creator -> creator.apply(context)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T extends TestDescriptor> Builder<T> builder() {
        return new Builder();
    }

    private static class DefaultInitializationContext<T extends TestDescriptor>
    implements InitializationContext<T> {
        private final EngineDiscoveryRequest request;
        private final T engineDescriptor;
        private final Predicate<String> classNameFilter;
        private final Predicate<String> packageFilter;
        private final DiscoveryIssueReporter issueReporter;

        DefaultInitializationContext(EngineDiscoveryRequest request, T engineDescriptor, DiscoveryIssueReporter issueReporter) {
            this.request = request;
            this.engineDescriptor = engineDescriptor;
            this.classNameFilter = this.buildClassNamePredicate(request);
            this.packageFilter = this.buildPackagePredicate(request);
            this.issueReporter = issueReporter;
        }

        private Predicate<String> buildClassNamePredicate(EngineDiscoveryRequest request) {
            ArrayList<DiscoveryFilter<String>> filters = new ArrayList<DiscoveryFilter<String>>();
            filters.addAll(request.getFiltersByType(ClassNameFilter.class));
            filters.addAll(request.getFiltersByType(PackageNameFilter.class));
            return Filter.composeFilters(filters).toPredicate();
        }

        private Predicate<String> buildPackagePredicate(EngineDiscoveryRequest request) {
            ArrayList<PackageNameFilter> filters = new ArrayList<PackageNameFilter>();
            filters.addAll(request.getFiltersByType(PackageNameFilter.class));
            return Filter.composeFilters(filters).toPredicate();
        }

        @Override
        public EngineDiscoveryRequest getDiscoveryRequest() {
            return this.request;
        }

        @Override
        public T getEngineDescriptor() {
            return this.engineDescriptor;
        }

        @Override
        public Predicate<String> getClassNameFilter() {
            return this.classNameFilter;
        }

        @Override
        public Predicate<String> getPackageFilter() {
            return this.packageFilter;
        }

        @Override
        public DiscoveryIssueReporter getIssueReporter() {
            return this.issueReporter;
        }
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static interface InitializationContext<T extends TestDescriptor> {
        public EngineDiscoveryRequest getDiscoveryRequest();

        public T getEngineDescriptor();

        public Predicate<String> getClassNameFilter();

        @API(status=API.Status.MAINTAINED, since="1.13.3")
        public Predicate<String> getPackageFilter();

        @API(status=API.Status.MAINTAINED, since="1.13.3")
        public DiscoveryIssueReporter getIssueReporter();
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static class Builder<T extends TestDescriptor> {
        private final List<Function<InitializationContext<T>, SelectorResolver>> resolverCreators = new ArrayList<Function<InitializationContext<T>, SelectorResolver>>();
        private final List<Function<InitializationContext<T>, TestDescriptor.Visitor>> visitorCreators = new ArrayList<Function<InitializationContext<T>, TestDescriptor.Visitor>>();

        private Builder() {
        }

        public Builder<T> addClassContainerSelectorResolver(Predicate<Class<?>> classFilter) {
            Preconditions.notNull(classFilter, (String)"classFilter must not be null");
            return this.addClassContainerSelectorResolverWithContext(__ -> classFilter);
        }

        @API(status=API.Status.MAINTAINED, since="1.13.3")
        public Builder<T> addClassContainerSelectorResolverWithContext(Function<InitializationContext<T>, Predicate<Class<?>>> classFilterCreator) {
            Preconditions.notNull(classFilterCreator, (String)"classFilterCreator must not be null");
            return this.addSelectorResolver((InitializationContext<T> context) -> new ClassContainerSelectorResolver((Predicate)classFilterCreator.apply((InitializationContext)context), context.getClassNameFilter()));
        }

        @API(status=API.Status.DEPRECATED, since="1.14")
        @Deprecated
        public Builder<T> addResourceContainerSelectorResolver(Predicate<org.junit.platform.commons.support.Resource> resourceFilter) {
            Preconditions.notNull(resourceFilter, (String)"resourceFilter must not be null");
            return this.addResourceContainerSelectorResolver(ResourceFilter.of(r -> resourceFilter.test(org.junit.platform.commons.support.Resource.of((Resource)r))));
        }

        @API(status=API.Status.MAINTAINED, since="1.14")
        public Builder<T> addResourceContainerSelectorResolver(ResourceFilter resourceFilter) {
            Preconditions.notNull((Object)resourceFilter, (String)"resourceFilter must not be null");
            return this.addSelectorResolver((InitializationContext<T> context) -> new ResourceContainerSelectorResolver(resourceFilter, context.getPackageFilter()));
        }

        public Builder<T> addSelectorResolver(SelectorResolver resolver) {
            Preconditions.notNull((Object)resolver, (String)"resolver must not be null");
            return this.addSelectorResolver((InitializationContext<T> context) -> resolver);
        }

        public Builder<T> addSelectorResolver(Function<InitializationContext<T>, SelectorResolver> resolverCreator) {
            this.resolverCreators.add(resolverCreator);
            return this;
        }

        public Builder<T> addTestDescriptorVisitor(Function<InitializationContext<T>, TestDescriptor.Visitor> visitorCreator) {
            this.visitorCreators.add(visitorCreator);
            return this;
        }

        public EngineDiscoveryRequestResolver<T> build() {
            return new EngineDiscoveryRequestResolver(this.resolverCreators, this.visitorCreators);
        }
    }
}

