/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.client;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtbot.generator.client.RecorderClient;
import org.eclipse.swtbot.generator.client.RecorderClientCodeListener;
import org.eclipse.swtbot.generator.client.RecorderClientStatusListener;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public enum Recorder implements RecorderClientCodeListener,
RecorderClientStatusListener
{
    INSTANCE;

    private RecorderClient recorderClient;
    private List<RecorderClientCodeListener> codeListeners;
    private List<RecorderClientStatusListener> statusListeners;
    private boolean isInitialized = false;
    private boolean isRecording;
    private boolean isInsertingDirectlyInEditor;
    private ConnectionState connectionState;
    private IDocument document;
    private IMethod selectedMethod;
    private IDocument selectedMethodDocument;

    public void initialize() {
        this.isInitialized = true;
        this.codeListeners = new ArrayList<RecorderClientCodeListener>();
        this.statusListeners = new ArrayList<RecorderClientStatusListener>();
        this.codeListeners.add(this);
        this.statusListeners.add(this);
        this.document = new Document();
        this.reset();
    }

    public void reset() {
        this.isRecording = false;
        this.isInsertingDirectlyInEditor = false;
        this.selectedMethod = null;
        this.selectedMethodDocument = null;
        this.connectionState = ConnectionState.DISCONNECTED;
    }

    public void startRecorderClient(int port) {
        this.interruptRecorderClient();
        this.connectionState = ConnectionState.CONNECTING;
        this.recorderClient = new RecorderClient(this.codeListeners, this.statusListeners, port);
        this.recorderClient.start();
    }

    public void interruptRecorderClient() {
        if (this.recorderClient != null) {
            this.recorderClient.interrupt();
            this.recorderClient.closeSocket();
            this.recorderClient = null;
        }
        this.reset();
    }

    @Override
    public void codeGenerated(String code) {
        if (!this.isRecording) {
            return;
        }
        if (this.isInsertingDirectlyInEditor && this.selectedMethod != null && this.selectedMethodDocument != null) {
            this.insertInEditor(code);
        } else {
            this.insertInView(code);
        }
    }

    @Override
    public void connectionStarted() {
        this.connectionState = ConnectionState.CONNECTED;
    }

    @Override
    public void connectionEnded() {
        this.connectionState = ConnectionState.DISCONNECTED;
        this.reset();
    }

    private void insertInView(final String code) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (Recorder.this.document.get().length() == 0) {
                    Recorder.this.document.set(String.valueOf(code) + ";");
                } else {
                    Recorder.this.document.set(String.valueOf(Recorder.this.document.get()) + "\n" + code + ";");
                }
            }
        });
    }

    private void insertInEditor(String code) {
        ICompilationUnit methodCompilationUnit = this.selectedMethod.getCompilationUnit();
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setSource(methodCompilationUnit);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        ASTNode rootNode = parser.createAST(null);
        CompilationUnit compilationUnit = (CompilationUnit)rootNode;
        MethodDeclarationVisitor methodDeclarationVisitor = new MethodDeclarationVisitor();
        compilationUnit.accept((ASTVisitor)methodDeclarationVisitor);
        MethodDeclaration method = methodDeclarationVisitor.findMethodDeclaration(this.selectedMethod);
        final ASTRewrite rewrite = ASTRewrite.create((AST)rootNode.getAST());
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)method.getBody(), Block.STATEMENTS_PROPERTY);
        Statement statement = (Statement)rewrite.createStringPlaceholder(String.valueOf(code) + ";", 20);
        listRewrite.insertLast((ASTNode)statement, null);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    TextEdit edits = rewrite.rewriteAST();
                    try {
                        edits.apply(Recorder.this.selectedMethodDocument);
                    }
                    catch (BadLocationException | MalformedTreeException e) {
                        e.printStackTrace();
                    }
                }
                catch (IllegalArgumentException | JavaModelException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    public boolean shouldUpdateMethodSelectionViewer(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        List<IJavaElementDelta> children = this.getAffectedLeafDeltas(delta);
        for (IJavaElementDelta child : children) {
            if (child.getElement() instanceof IMethod) {
                return true;
            }
            if (!(child.getElement() instanceof ICompilationUnit) || child.getKind() != 4) continue;
            return true;
        }
        return false;
    }

    private List<IJavaElementDelta> getAffectedLeafDeltas(IJavaElementDelta delta) {
        ArrayList<IJavaElementDelta> leaves = new ArrayList<IJavaElementDelta>();
        return this.getAffectedLeafDeltasRecursively(delta, leaves);
    }

    private List<IJavaElementDelta> getAffectedLeafDeltasRecursively(IJavaElementDelta delta, List<IJavaElementDelta> leaves) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
            if (childDelta.getAffectedChildren().length == 0) {
                leaves.add(childDelta);
            } else {
                this.getAffectedLeafDeltasRecursively(childDelta, leaves);
            }
            ++n2;
        }
        return leaves;
    }

    public boolean isInsertingDirectlyInEditor() {
        return this.isInsertingDirectlyInEditor;
    }

    public void setInsertingDirectlyInEditor(boolean isInsertingDirectlyInEditor) {
        this.isInsertingDirectlyInEditor = isInsertingDirectlyInEditor;
    }

    public IMethod getSelectedMethod() {
        return this.selectedMethod;
    }

    public void setSelectedMethod(IMethod selectedMethod) {
        this.selectedMethod = selectedMethod;
    }

    public IDocument getSelectedMethodDocument() {
        return this.selectedMethodDocument;
    }

    public void setSelectedMethodDocument(IDocument selectedMethodDocument) {
        this.selectedMethodDocument = selectedMethodDocument;
    }

    public String getDocumentText() {
        return this.document.get();
    }

    public void clearDocument() {
        this.document.set("");
    }

    public IDocument getDocument() {
        return this.document;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public void setRecording(boolean isRecording) {
        this.isRecording = isRecording;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    public int getPort() {
        return this.recorderClient.getPort();
    }

    public boolean addCodeListener(RecorderClientCodeListener listener) {
        return this.codeListeners.add(listener);
    }

    public boolean removeCodeListener(RecorderClientCodeListener listener) {
        return this.codeListeners.remove(listener);
    }

    public boolean addStatusListener(RecorderClientStatusListener listener) {
        return this.statusListeners.add(listener);
    }

    public boolean removeStatusListener(RecorderClientStatusListener listener) {
        return this.statusListeners.remove(listener);
    }

    public static enum ConnectionState {
        CONNECTED,
        CONNECTING,
        DISCONNECTED;

    }

    private class MethodDeclarationVisitor
    extends ASTVisitor {
        private List<MethodDeclaration> methodDeclarations = new ArrayList<MethodDeclaration>();

        private MethodDeclarationVisitor() {
        }

        public boolean visit(MethodDeclaration node) {
            this.methodDeclarations.add(node);
            return super.visit(node);
        }

        public MethodDeclaration findMethodDeclaration(IMethod method) {
            for (MethodDeclaration methodDeclaration : this.methodDeclarations) {
                if (!methodDeclaration.resolveBinding().getJavaElement().equals(method)) continue;
                return methodDeclaration;
            }
            return null;
        }
    }
}

