/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.PreviewNode;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

class ChangeElementLabelProvider
extends LabelProvider
implements IFontProvider {
    private final Map<ImageDescriptor, Image> fDescriptorImageMap = new HashMap<ImageDescriptor, Image>();

    public Image getImage(Object object) {
        return this.manageImageDescriptor(((PreviewNode)object).getImageDescriptor());
    }

    public String getText(Object object) {
        String text = ((PreviewNode)object).getText();
        if (this.isDerived(object)) {
            return Messages.format(RefactoringUIMessages.ChangeElementLabelProvider_derived, text);
        }
        return text;
    }

    public Font getFont(Object element) {
        if (this.isDerived(element)) {
            return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
        }
        return null;
    }

    private boolean isDerived(Object element) {
        PreviewNode node = (PreviewNode)element;
        return node.hasDerived();
    }

    public void dispose() {
        for (Image image : this.fDescriptorImageMap.values()) {
            image.dispose();
        }
        super.dispose();
    }

    private Image manageImageDescriptor(ImageDescriptor descriptor) {
        Image image = this.fDescriptorImageMap.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.fDescriptorImageMap.put(descriptor, image);
        }
        return image;
    }
}

