/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core.util;

import org.eclipse.mylyn.builds.core.ITestCase;
import org.eclipse.mylyn.builds.core.ITestResult;
import org.eclipse.mylyn.builds.core.ITestSuite;
import org.eclipse.mylyn.builds.core.TestCaseResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JUnitResultGenerator {
    private static final String CLASS_NAME = "classname";
    private static final String ERROR = "error";
    private static final String ERRORS = "errors";
    private static final String FAILURE = "failure";
    private static final String FAILURES = "failures";
    private static final String IGNORED = "ignored";
    private static final String MESSAGE = "message";
    private static final String NAME = "name";
    private static final String PROJECT = "project";
    private static final String SKIPPED = "skipped";
    private static final String STARTED = "started";
    private static final String TESTCASE = "testcase";
    private static final String TESTRUN = "testrun";
    private static final String TESTS = "tests";
    private static final String TESTSUITE = "testsuite";
    private static final String TIME = "time";
    private final ITestResult result;
    private boolean includeIgnored;

    public JUnitResultGenerator(ITestResult result) {
        this.result = result;
    }

    public boolean includeIgnored() {
        return this.includeIgnored;
    }

    public void setIncludeIgnored(boolean includeIgnored) {
        this.includeIgnored = includeIgnored;
    }

    public void write(ContentHandler handler) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        handler.startDocument();
        attributes.clear();
        attributes.addAttribute(null, null, NAME, null, this.result.getBuild().getLabel());
        attributes.addAttribute(null, null, PROJECT, null, this.result.getBuild().getLabel());
        attributes.addAttribute(null, null, TESTS, null, Integer.toString(this.result.getFailCount() + this.result.getPassCount()));
        attributes.addAttribute(null, null, STARTED, null, Integer.toString(this.result.getFailCount() + this.result.getPassCount()));
        attributes.addAttribute(null, null, FAILURES, null, Integer.toString(this.result.getFailCount()));
        attributes.addAttribute(null, null, ERRORS, null, Integer.toString(this.result.getErrorCount()));
        attributes.addAttribute(null, null, IGNORED, null, Integer.toString(this.result.getIgnoredCount()));
        handler.startElement(null, null, TESTRUN, attributes);
        for (ITestSuite testsuite : this.result.getSuites()) {
            attributes.clear();
            attributes.addAttribute(null, null, NAME, null, testsuite.getLabel());
            attributes.addAttribute(null, null, TIME, null, Double.toString((double)testsuite.getDuration() / 1000.0));
            handler.startElement(null, null, TESTSUITE, attributes);
            String childSuite = null;
            for (ITestCase test : testsuite.getCases()) {
                if (test.getClassName() != null && !test.getClassName().equals(testsuite.getLabel())) {
                    if (childSuite == null) {
                        attributes.clear();
                        attributes.addAttribute(null, null, NAME, null, test.getClassName());
                        handler.startElement(null, null, TESTSUITE, attributes);
                    } else if (!childSuite.equals(test.getClassName())) {
                        handler.endElement(null, null, TESTSUITE);
                        attributes.clear();
                        attributes.addAttribute(null, null, NAME, null, test.getClassName());
                        handler.startElement(null, null, TESTSUITE, attributes);
                    }
                    childSuite = test.getClassName();
                }
                if (test.isSkipped() && !this.includeIgnored()) continue;
                attributes.clear();
                attributes.addAttribute(null, null, NAME, null, test.getLabel());
                attributes.addAttribute(null, null, CLASS_NAME, null, test.getClassName());
                attributes.addAttribute(null, null, TIME, null, Double.toString((double)test.getDuration() / 1000.0));
                handler.startElement(null, null, TESTCASE, attributes);
                if (test.getStatus() == TestCaseResult.FAILED || test.getStatus() == TestCaseResult.REGRESSION) {
                    attributes.clear();
                    attributes.addAttribute(null, null, MESSAGE, null, test.getMessage());
                    String element = test.getMessage() != null ? FAILURE : ERROR;
                    handler.startElement(null, null, element, attributes);
                    if (test.getStackTrace() != null) {
                        char[] charArray = test.getStackTrace().toCharArray();
                        handler.characters(charArray, 0, charArray.length);
                    }
                    handler.endElement(null, null, element);
                }
                if (test.isSkipped()) {
                    attributes.clear();
                    handler.startElement(null, null, SKIPPED, attributes);
                    handler.endElement(null, null, SKIPPED);
                }
                handler.endElement(null, null, TESTCASE);
            }
            if (childSuite != null) {
                handler.endElement(null, null, TESTSUITE);
            }
            handler.endElement(null, null, TESTSUITE);
        }
        handler.endElement(null, null, TESTRUN);
        handler.endDocument();
    }
}

