/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.model.spi.MethodParameterSpi;
import org.eclipse.scout.sdk.core.java.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.Strings;

public final class JavaTypes {
    public static final String _boolean = "boolean";
    public static final String _byte = "byte";
    public static final String _char = "char";
    public static final String _double = "double";
    public static final String _float = "float";
    public static final String _int = "int";
    public static final String _long = "long";
    public static final String _short = "short";
    public static final String _void = "void";
    public static final String Boolean = "java.lang.Boolean";
    public static final String Byte = "java.lang.Byte";
    public static final String Character = "java.lang.Character";
    public static final String Double = "java.lang.Double";
    public static final String Float = "java.lang.Float";
    public static final String Integer = "java.lang.Integer";
    public static final String Long = "java.lang.Long";
    public static final String Short = "java.lang.Short";
    public static final String Void = "java.lang.Void";
    public static final char C_DOT = '.';
    public static final char C_GENERIC_START = '<';
    public static final char C_GENERIC_END = '>';
    public static final char C_DOLLAR = '$';
    public static final char C_COMMA = ',';
    public static final char C_QUESTION_MARK = '?';
    public static final char C_SPACE = ' ';
    public static final String LAMBDA_ARROW = "->";
    public static final String EXTENDS = "extends";
    public static final String IMPLEMENTS = "implements";
    public static final String SUPER = "super";
    public static final String JAVA_FILE_EXTENSION = "java";
    public static final String JAVA_FILE_SUFFIX = ".java";
    public static final String CLASS_FILE_EXTENSION = "class";
    public static final String CLASS_FILE_SUFFIX = ".class";
    public static final String PackageInfo = "package-info";
    public static final String PackageInfoJava = "package-info.java";
    public static final String ModuleInfo = "module-info";
    public static final String ModuleInfoJava = "module-info.java";
    private static final String ARRAY_MARKER = "[]";
    private static final char C_ARRAY = '[';
    private static final FinalValue<Set<String>> JAVA_KEYWORDS = new FinalValue();
    private static final char[][] WILDCARD_MARKERS = new char[][]{" extends ".toCharArray(), " super ".toCharArray(), "extends ".toCharArray(), "super ".toCharArray()};

    private JavaTypes() {
    }

    public static boolean isReservedJavaKeyword(CharSequence word) {
        return word != null && JavaTypes.getJavaKeyWords().contains(word.toString());
    }

    public static Set<String> getJavaKeyWords() {
        return (Set)JAVA_KEYWORDS.computeIfAbsentAndGet(() -> Stream.of("abstract", "assert", _boolean, "break", _byte, "case", "catch", _char, CLASS_FILE_EXTENSION, "const", "continue", "default", "do", _double, "else", "enum", EXTENDS, "final", "finally", _float, "for", "goto", "if", IMPLEMENTS, "import", "instanceof", _int, "interface", _long, "native", "new", "package", "private", "protected", "public", "return", _short, "static", "strictfp", SUPER, "switch", "synchronized", "this", "throw", "throws", "transient", "try", _void, "volatile", "while", "false", "null", "true", "yield", "var", "_", "record", "sealed", "permits", "non-sealed").collect(Collectors.toUnmodifiableSet()));
    }

    public static String boxPrimitive(CharSequence fqn) {
        String fqnStr;
        if (fqn == null) {
            return null;
        }
        return switch (fqnStr = fqn.toString()) {
            case _boolean -> Boolean;
            case _char -> Character;
            case _byte -> Byte;
            case _short -> Short;
            case _int -> Integer;
            case _long -> Long;
            case _float -> Float;
            case _double -> Double;
            case _void -> Void;
            default -> fqnStr;
        };
    }

    public static String unboxToPrimitive(CharSequence fqn) {
        String fqnStr;
        if (fqn == null) {
            return null;
        }
        return switch (fqnStr = fqn.toString()) {
            case Boolean -> _boolean;
            case Character -> _char;
            case Byte -> _byte;
            case Short -> _short;
            case Integer -> _int;
            case Long -> _long;
            case Float -> _float;
            case Double -> _double;
            case Void -> _void;
            default -> fqnStr;
        };
    }

    public static boolean isPrimitive(CharSequence fqn) {
        if (fqn == null) {
            return false;
        }
        return switch (fqn.toString()) {
            case _boolean, _char, _byte, _short, _int, _long, _float, _double, _void -> true;
            default -> false;
        };
    }

    public static boolean isArray(CharSequence fqn) {
        return fqn != null && !fqn.isEmpty() && fqn.charAt(fqn.length() - 1) == ']';
    }

    public static boolean isWildcard(CharSequence fqn) {
        return fqn != null && fqn.length() == 1 && fqn.charAt(0) == '?';
    }

    public static String defaultValueOf(CharSequence dataType) {
        if (dataType == null) {
            return null;
        }
        return switch (dataType.toString()) {
            case _boolean, Boolean -> "false";
            case _byte, Byte, _char, Character, _int, Integer, _short, Short -> "0";
            case _double, Double -> "0.0";
            case _float, Float -> "0.0f";
            case _long, Long -> "0L";
            case _void -> null;
            default -> "null";
        };
    }

    public static String qualifier(CharSequence name) {
        int firstGenericStart = Strings.indexOf((char)'<', (CharSequence)name);
        int lastDot = Strings.lastIndexOf((char)'.', (CharSequence)name, (int)0, (int)(firstGenericStart == -1 ? name.length() - 1 : firstGenericStart));
        if (lastDot == -1) {
            return "";
        }
        return name.subSequence(0, lastDot).toString();
    }

    public static String simpleName(CharSequence fqn) {
        int lastSegmentStart = 0;
        String erasure = JavaTypes.erasure(fqn);
        for (int i = erasure.length() - 1; i >= 0; --i) {
            if (erasure.charAt(i) != '.' && erasure.charAt(i) != '$') continue;
            lastSegmentStart = i + 1;
            break;
        }
        if (lastSegmentStart == 0) {
            return erasure.toString();
        }
        return erasure.subSequence(lastSegmentStart, erasure.length()).toString();
    }

    public static String createMethodIdentifier(MethodSpi method) {
        List paramTypeNames = method.getParameters().stream().map(MethodParameterSpi::getDataType).map(TypeSpi::getName).collect(Collectors.toList());
        return JavaTypes.createMethodIdentifier(method.getElementName(), paramTypeNames);
    }

    public static String createMethodIdentifier(CharSequence methodName, Collection<? extends CharSequence> paramDataTypes) {
        StringBuilder methodIdBuilder = new StringBuilder(256);
        methodIdBuilder.append(methodName);
        methodIdBuilder.append('(');
        if (paramDataTypes != null && !paramDataTypes.isEmpty()) {
            Iterator<? extends CharSequence> iterator = paramDataTypes.iterator();
            methodIdBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                methodIdBuilder.append(',');
                methodIdBuilder.append(iterator.next());
            }
        }
        methodIdBuilder.append(')');
        return methodIdBuilder.toString();
    }

    public static String createMethodIdentifier(Method method) {
        return JavaTypes.createMethodIdentifier(method, false);
    }

    public static String createMethodIdentifier(Executable method, boolean includeTypeArguments) {
        Type[] paramTypes = includeTypeArguments ? method.getGenericParameterTypes() : method.getParameterTypes();
        List args = Arrays.stream(paramTypes).map(Type::getTypeName).map(name -> name.replace(" ", "")).collect(Collectors.toList());
        return JavaTypes.createMethodIdentifier(method.getName(), args);
    }

    public static String arrayMarker() {
        return JavaTypes.arrayMarker(1);
    }

    public static String arrayMarker(int dimension) {
        if (dimension < 1) {
            return "";
        }
        return ARRAY_MARKER.repeat(dimension);
    }

    public static String erasure(CharSequence parameterizedType) {
        int firstParamIndex = Strings.indexOf((char)'<', (CharSequence)parameterizedType);
        if (firstParamIndex < 0) {
            return parameterizedType.toString();
        }
        return JavaTypes.erasure(parameterizedType, firstParamIndex);
    }

    private static String erasure(CharSequence parameterizedType, int firstParamIndex) {
        StringBuilder result = new StringBuilder(parameterizedType.length());
        result.append(parameterizedType.subSequence(0, firstParamIndex));
        int depth = 1;
        for (int i = firstParamIndex + 1; i < parameterizedType.length(); ++i) {
            char c = parameterizedType.charAt(i);
            if (c == '<') {
                ++depth;
                continue;
            }
            if (c == '>') {
                --depth;
                continue;
            }
            if (depth >= 1) continue;
            result.append(c);
        }
        return result.toString();
    }

    public static List<String> typeArguments(CharSequence parameterizedType) {
        int length = parameterizedType.length();
        if (length < 4) {
            return Collections.emptyList();
        }
        if (parameterizedType.charAt(length - 1) != '>') {
            return Collections.emptyList();
        }
        ArrayDeque<String> args = new ArrayDeque<String>();
        int depth = 1;
        int end = length - 1;
        for (int pos = end - 1; pos >= 0 && depth > 0; --pos) {
            String arg;
            char curChar = parameterizedType.charAt(pos);
            if (curChar == '<') {
                if (--depth != 0) continue;
                arg = JavaTypes.subElement(parameterizedType, pos + 1, end);
                args.addFirst(arg);
                end = pos;
                continue;
            }
            if (curChar == '>') {
                ++depth;
                continue;
            }
            if (depth != 1 || curChar != ',') continue;
            arg = JavaTypes.subElement(parameterizedType, pos + 1, end);
            args.addFirst(arg);
            end = pos;
        }
        return new ArrayList<String>(args);
    }

    static String subElement(CharSequence src, int start, int end) {
        int i;
        for (i = start; i < end; ++i) {
            start = i;
            if (src.charAt(i) != ' ') break;
        }
        for (i = end; i >= start; --i) {
            end = i;
            if (src.charAt(i - 1) != ' ') break;
        }
        return src.subSequence(start, end).toString();
    }

    public static class ReferenceParser {
        private final BiFunction<CharSequence, Integer, CharSequence> m_handler;

        public ReferenceParser(BiFunction<CharSequence, Integer, CharSequence> handler) {
            this.m_handler = (BiFunction)Ensure.notNull(handler);
        }

        public String useReference(CharSequence fullyQualifiedName) {
            StringBuilder result = new StringBuilder(fullyQualifiedName.length());
            this.useReferenceInternal(fullyQualifiedName, result);
            return result.toString();
        }

        protected void useReferenceInternal(CharSequence ref, StringBuilder result) {
            boolean isFirst = true;
            boolean inWildcard = false;
            int depth = 0;
            int lastTypeArgStart = -1;
            block7: for (int i = 0; i < ref.length(); ++i) {
                char c = ref.charAt(i);
                switch (c) {
                    case '<': {
                        if (isFirst) {
                            lastTypeArgStart = this.consumeType(i, 0, ref, depth, result);
                            isFirst = false;
                        } else {
                            lastTypeArgStart = depth > 0 ? this.consumeType(i, lastTypeArgStart, ref, depth, result) : i + 1;
                        }
                        ++depth;
                        inWildcard = false;
                        result.append('<');
                        continue block7;
                    }
                    case '?': {
                        inWildcard = true;
                        continue block7;
                    }
                    case ' ': {
                        if (inWildcard) continue block7;
                        lastTypeArgStart = this.consumeType(i, lastTypeArgStart, ref, depth, result);
                        continue block7;
                    }
                    case '>': {
                        lastTypeArgStart = this.consumeType(i, lastTypeArgStart, ref, depth, result);
                        --depth;
                        inWildcard = false;
                        result.append('>');
                        continue block7;
                    }
                    case ',': {
                        lastTypeArgStart = this.consumeType(i, lastTypeArgStart, ref, depth, result);
                        inWildcard = false;
                        result.append(',');
                        continue block7;
                    }
                    default: {
                        if (isFirst || depth != 0) continue block7;
                        result.append(c);
                    }
                }
            }
            if (isFirst) {
                this.consumeType(ref.length(), 0, ref, depth, result);
            }
        }

        protected int consumeType(int end, int start, CharSequence src, int depth, StringBuilder result) {
            if (end == start) {
                return end + 1;
            }
            int fqnStart = ReferenceParser.consumeWildcard(start, src, result);
            if (fqnStart == end) {
                return end + 1;
            }
            int arrayStart = Strings.indexOf((char)'[', (CharSequence)src, (int)fqnStart, (int)end);
            boolean isArray = arrayStart > fqnStart;
            CharSequence fqn = src.subSequence(fqnStart, isArray ? arrayStart : end);
            result.append(this.handler().apply(fqn, depth));
            if (isArray) {
                result.append(src, arrayStart, end);
            }
            return end + 1;
        }

        protected static int consumeWildcard(int start, CharSequence src, StringBuilder result) {
            if (src.charAt(start) != '?') {
                return start;
            }
            for (char[] wildcardMarker : WILDCARD_MARKERS) {
                if (!ReferenceParser.fragmentEquals(wildcardMarker, src, start + 1)) continue;
                result.append('?');
                if (wildcardMarker[0] != ' ') {
                    result.append(' ');
                }
                result.append(wildcardMarker);
                return start + wildcardMarker.length + 1;
            }
            result.append('?');
            return start + 1;
        }

        protected static boolean fragmentEquals(char[] fragment, CharSequence name, int startIndex) {
            int max = fragment.length;
            if (name.length() < max + startIndex) {
                return false;
            }
            int i = max;
            while (--i >= 0) {
                if (fragment[i] == name.charAt(i + startIndex)) continue;
                return false;
            }
            return true;
        }

        public BiFunction<CharSequence, Integer, CharSequence> handler() {
            return this.m_handler;
        }
    }
}

