/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.OverriddenAssignmentFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class OverriddenAssignmentCleanUpCore
extends AbstractCleanUp {
    public OverriddenAssignmentCleanUpCore() {
    }

    public OverriddenAssignmentCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.overridden_assignment");
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.overridden_assignment")) {
            return new String[]{MultiFixMessages.OverriddenAssignmentCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        if (this.isEnabled("cleanup.overridden_assignment")) {
            if (this.isEnabled("cleanup.overridden_assignment_move_decl")) {
                bld.append("String separator = System.lineSeparator();\n");
                bld.append("long time = System.currentTimeMillis();\n");
            } else {
                bld.append("long time;\n");
                bld.append("String separator = System.lineSeparator();\n");
                bld.append("time = System.currentTimeMillis();\n");
            }
        } else {
            bld.append("long time = 0;\n");
            bld.append("String separator = \"\";\n");
            bld.append("separator = System.lineSeparator();\n");
            bld.append("time = System.currentTimeMillis();\n");
        }
        return bld.toString();
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.overridden_assignment")) {
            return null;
        }
        return OverriddenAssignmentFixCore.createCleanUp(compilationUnit, this.isEnabled("cleanup.overridden_assignment_move_decl"));
    }
}

