/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.ui.wizards.NewClassWizardPage;

public class NewClassCreationWizard
extends NewElementWizard {
    private NewClassWizardPage fPage;
    private boolean fOpenEditorOnFinish;

    public NewClassCreationWizard(NewClassWizardPage page, boolean openEditorOnFinish) {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
        this.setDialogSettings(JavaScriptPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.NewClassCreationWizard_title);
        this.fPage = page;
        this.fOpenEditorOnFinish = openEditorOnFinish;
    }

    public NewClassCreationWizard() {
        this(null, true);
    }

    public void addPages() {
        super.addPages();
        if (this.fPage == null) {
            this.fPage = new NewClassWizardPage();
            this.fPage.init(this.getSelection());
        }
        this.addPage((IWizardPage)this.fPage);
    }

    @Override
    protected boolean canRunForked() {
        return !this.fPage.isEnclosingTypeSelected();
    }

    @Override
    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fPage.createType(monitor);
    }

    @Override
    public boolean performFinish() {
        IResource resource;
        this.warnAboutTypeCommentDeprecation();
        boolean res = super.performFinish();
        if (res && (resource = this.fPage.getModifiedResource()) != null) {
            this.selectAndReveal(resource);
            if (this.fOpenEditorOnFinish) {
                this.openResource((IFile)resource);
            }
        }
        return res;
    }

    @Override
    public IJavaScriptElement getCreatedElement() {
        return this.fPage.getCreatedType();
    }
}

