/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.scout.sdk.core.java.ecj.AbstractJavaElementWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.java.ecj.metavalue.MetaValueFactory;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotationElement;
import org.eclipse.scout.sdk.core.java.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.java.model.api.internal.AnnotationElementImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotationElementSpi;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotationSpi;
import org.eclipse.scout.sdk.core.java.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class DeclarationAnnotationElementWithEcj
extends AbstractJavaElementWithEcj<IAnnotationElement>
implements AnnotationElementSpi {
    private final AnnotationSpi m_declaringAnnotation;
    private final MemberValuePair m_astNode;
    private final String m_name;
    private final boolean m_syntheticDefaultValue;
    private final FinalValue<IMetaValue> m_value;
    private final FinalValue<SourceRange> m_source;
    private final FinalValue<SourceRange> m_expressionSource;

    protected DeclarationAnnotationElementWithEcj(AbstractJavaEnvironment env, AnnotationSpi declaringAnnotation, MemberValuePair astNode, boolean syntheticDefaultValue) {
        super(env);
        this.m_declaringAnnotation = declaringAnnotation;
        this.m_astNode = astNode;
        this.m_syntheticDefaultValue = syntheticDefaultValue;
        this.m_name = new String(astNode.name);
        this.m_value = new FinalValue();
        this.m_source = new FinalValue();
        this.m_expressionSource = new FinalValue();
    }

    public AnnotationElementSpi internalFindNewElement() {
        return SpiWithEcjUtils.findNewAnnotationElementIn(this.getDeclaringAnnotation(), this.getElementName());
    }

    protected IAnnotationElement internalCreateApi() {
        return new AnnotationElementImplementor((AnnotationElementSpi)this);
    }

    public String getElementName() {
        return this.m_name;
    }

    public IMetaValue getMetaValue() {
        return (IMetaValue)this.m_value.computeIfAbsentAndGet(() -> {
            Object compiledValue = DeclarationAnnotationElementWithEcj.resolveExpressionOf(this);
            IMetaValue value = SpiWithEcjUtils.resolveCompiledValue(this.javaEnvWithEcj(), this.m_declaringAnnotation.getOwner(), compiledValue, () -> this.withNewElement(DeclarationAnnotationElementWithEcj::resolveExpressionOf));
            if (value != null) {
                return value;
            }
            return MetaValueFactory.createUnknown(compiledValue);
        });
    }

    protected static Object resolveExpressionOf(DeclarationAnnotationElementWithEcj element) {
        ClassScope scope = SpiWithEcjUtils.classScopeOf((JavaElementSpi)element.getDeclaringAnnotation().getOwner());
        return SpiWithEcjUtils.compileExpression(element.m_astNode.value, scope, element.javaEnvWithEcj());
    }

    public AnnotationSpi getDeclaringAnnotation() {
        return this.m_declaringAnnotation;
    }

    public boolean isDefaultValue() {
        return this.m_syntheticDefaultValue;
    }

    public SourceRange getSource() {
        return (SourceRange)this.m_source.computeIfAbsentAndGet(() -> new SourceRange((CharSequence)this.m_astNode.toString(), this.m_astNode.sourceStart));
    }

    public SourceRange getSourceOfExpression() {
        return (SourceRange)this.m_expressionSource.computeIfAbsentAndGet(() -> {
            Expression expr = this.m_astNode.value;
            if (expr == null) {
                return null;
            }
            return new SourceRange((CharSequence)expr.toString(), expr.sourceStart);
        });
    }
}

