/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.embedded;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.internal.texteditor.CompoundEditExitStrategy;
import org.eclipse.ui.internal.texteditor.ICompoundEditListener;
import org.eclipse.xtext.ui.editor.embedded.TextViewerAction;

public class TextViewerMoveLinesAction
extends TextViewerAction {
    private final boolean fUpwards;
    private final boolean fCopy;
    private final CompoundEditExitStrategy fStrategy;
    private boolean fAddDelimiter;
    private boolean fEditInProgress = false;

    public TextViewerMoveLinesAction(ResourceBundle bundle, String prefix, ITextViewer viewer, boolean upwards, boolean copy) {
        super(bundle, prefix, viewer);
        String[] stringArray;
        this.fUpwards = upwards;
        this.fCopy = copy;
        if (copy) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "org.eclipse.ui.edit.text.copyLineUp";
            stringArray = stringArray2;
            stringArray2[1] = "org.eclipse.ui.edit.text.copyLineDown";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "org.eclipse.ui.edit.text.moveLineUp";
            stringArray = stringArray3;
            stringArray3[1] = "org.eclipse.ui.edit.text.moveLineDown";
        }
        String[] commandIds = stringArray;
        this.fStrategy = new CompoundEditExitStrategy(commandIds);
        this.fStrategy.addCompoundListener(new ICompoundEditListener(){

            public void endCompoundEdit() {
                TextViewerMoveLinesAction.this.endCompoundEdit();
            }
        });
        this.update();
    }

    private void beginCompoundEdit() {
        ITextViewer viewer = this.getTextViewer();
        if (this.fEditInProgress || viewer == null || !(viewer instanceof ITextViewerExtension)) {
            return;
        }
        this.fEditInProgress = true;
        this.fStrategy.arm(viewer);
        IRewriteTarget target = ((ITextViewerExtension)viewer).getRewriteTarget();
        if (target != null) {
            target.beginCompoundChange();
        }
    }

    private boolean containedByVisibleRegion(ITextSelection selection, ITextViewer viewer) {
        block7: {
            int visEnd;
            IDocument document;
            int max;
            block8: {
                int visOffset;
                IRegion visible;
                block5: {
                    int min;
                    block6: {
                        min = selection.getOffset();
                        max = min + selection.getLength();
                        document = viewer.getDocument();
                        visible = viewer instanceof ITextViewerExtension5 ? ((ITextViewerExtension5)viewer).getModelCoverage() : viewer.getVisibleRegion();
                        visOffset = visible.getOffset();
                        try {
                            if (visOffset <= min) break block5;
                            if (document.getLineOfOffset(visOffset) == selection.getStartLine()) break block6;
                            return false;
                        }
                        catch (BadLocationException badLocationException) {
                            return false;
                        }
                    }
                    if (this.isWhitespace(document.get(min, visOffset - min))) break block5;
                    return false;
                }
                visEnd = visOffset + visible.getLength();
                if (visEnd >= max) break block7;
                if (document.getLineOfOffset(visEnd) == selection.getEndLine()) break block8;
                return false;
            }
            if (this.isWhitespace(document.get(visEnd, max - visEnd))) break block7;
            return false;
        }
        return true;
    }

    private void endCompoundEdit() {
        ITextViewer viewer = this.getTextViewer();
        if (!this.fEditInProgress || viewer == null || !(viewer instanceof ITextViewerExtension)) {
            return;
        }
        IRewriteTarget target = ((ITextViewerExtension)viewer).getRewriteTarget();
        if (target != null) {
            target.endCompoundChange();
        }
        this.fEditInProgress = false;
    }

    private ITextSelection getMovingSelection(IDocument document, ITextSelection selection, ITextViewer viewer) throws BadLocationException {
        int low = document.getLineOffset(selection.getStartLine());
        int endLine = selection.getEndLine();
        int high = document.getLineOffset(endLine) + document.getLineLength(endLine);
        String delim = document.getLineDelimiter(endLine);
        if (delim != null) {
            high -= delim.length();
        }
        this.fAddDelimiter = delim != null && document.getLineLength(endLine) == delim.length();
        return new TextSelection(document, low, high - low);
    }

    private ITextSelection getSkippedLine(IDocument document, ITextSelection selection) {
        int skippedLineN;
        int n = skippedLineN = this.fUpwards ? selection.getStartLine() - 1 : selection.getEndLine() + 1;
        if (skippedLineN > document.getNumberOfLines() || !this.fCopy && (skippedLineN < 0 || skippedLineN == document.getNumberOfLines())) {
            return null;
        }
        try {
            if (this.fCopy && skippedLineN == -1) {
                skippedLineN = 0;
            }
            IRegion line = document.getLineInformation(skippedLineN);
            return new TextSelection(document, line.getOffset(), line.getLength());
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private boolean isWhitespace(String string) {
        return string == null ? true : string.trim().length() == 0;
    }

    public void runWithEvent(Event event) {
        ITextViewer viewer = this.getTextViewer();
        if (viewer == null) {
            return;
        }
        if (!this.canModifyViewer()) {
            return;
        }
        IDocument document = viewer.getDocument();
        if (document == null) {
            return;
        }
        StyledText widget = viewer.getTextWidget();
        if (widget == null) {
            return;
        }
        ITextSelection sel = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (sel.isEmpty()) {
            return;
        }
        ITextSelection skippedLine = this.getSkippedLine(document, sel);
        if (skippedLine == null) {
            return;
        }
        try {
            int deviation;
            int offset;
            String insertion;
            String delim;
            ITextSelection movingArea = this.getMovingSelection(document, sel, viewer);
            if (!this.containedByVisibleRegion(movingArea, viewer) || !this.containedByVisibleRegion(skippedLine, viewer)) {
                return;
            }
            String moving = movingArea.getText();
            String skipped = skippedLine.getText();
            if (moving == null || skipped == null || document.getLength() == 0) {
                return;
            }
            if (this.fUpwards) {
                delim = document.getLineDelimiter(skippedLine.getEndLine());
                if (this.fCopy) {
                    delim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                    insertion = moving + delim;
                    offset = movingArea.getOffset();
                    deviation = 0;
                } else {
                    Assert.isNotNull((Object)delim);
                    insertion = moving + delim + skipped;
                    offset = skippedLine.getOffset();
                    deviation = -skippedLine.getLength() - delim.length();
                }
            } else {
                delim = document.getLineDelimiter(movingArea.getEndLine());
                if (this.fCopy) {
                    if (delim == null) {
                        delim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                        insertion = delim + moving;
                    } else {
                        insertion = moving + delim;
                    }
                    offset = skippedLine.getOffset();
                    deviation = movingArea.getLength() + delim.length();
                } else {
                    Assert.isNotNull((Object)delim);
                    insertion = skipped + delim + moving;
                    offset = movingArea.getOffset();
                    deviation = skipped.length() + delim.length();
                }
            }
            this.beginCompoundEdit();
            if (this.fCopy) {
                document.replace(offset, 0, insertion);
            } else {
                document.replace(offset, insertion.length(), insertion);
            }
            int selOffset = movingArea.getOffset() + deviation;
            int selLength = movingArea.getLength() + (this.fAddDelimiter ? delim.length() : 0);
            if (!(viewer instanceof ITextViewerExtension5)) {
                selLength = Math.min(selLength, viewer.getVisibleRegion().getOffset() + viewer.getVisibleRegion().getLength() - selOffset);
            }
            this.selectAndReveal(viewer, selOffset, selLength);
        }
        catch (BadLocationException x) {
            return;
        }
    }

    private void selectAndReveal(ITextViewer viewer, int offset, int length) {
        viewer.setSelectedRange(offset + length, -length);
        StyledText st = viewer.getTextWidget();
        if (st != null) {
            st.showSelection();
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.isEnabled()) {
            this.setEnabled(this.canModifyViewer());
        }
    }
}

