/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.pde.internal.junit.runtime.Caller;
import org.eclipse.pde.internal.junit.runtime.SPIMapping;
import org.osgi.framework.Bundle;

public class SPIBundleClassLoader
extends ClassLoader {
    private static final String META_INF_SERVICES = "META-INF/services/";
    private final List<Bundle> bundles;
    private final int junitVersion;
    private final Map<String, List<SPIMapping>> mappings = new ConcurrentHashMap<String, List<SPIMapping>>();

    public SPIBundleClassLoader(List<Bundle> bundles, int junitVersion) {
        super(null);
        this.bundles = bundles;
        this.junitVersion = junitVersion;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Iterator spi = this.mappings.values().stream().flatMap(Collection::stream).filter(mapping -> mapping.hasService(name)).iterator();
        if (spi.hasNext()) {
            Bundle caller = Caller.getBundle(this.junitVersion);
            while (spi.hasNext()) {
                SPIMapping mapping2 = (SPIMapping)spi.next();
                if (!mapping2.isCompatible(caller)) continue;
                return mapping2.loadImplementation(name);
            }
            throw new ClassNotFoundException(name);
        }
        for (Bundle bundle : this.bundles) {
            try {
                Class c = bundle.loadClass(name);
                if (c == null) continue;
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        try {
            Enumeration<URL> resources = this.findResources(name);
            if (resources.hasMoreElements()) {
                return resources.nextElement();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        if (name.startsWith(META_INF_SERVICES)) {
            String serviceName = name.substring(META_INF_SERVICES.length());
            List spis = this.mappings.computeIfAbsent(name, spi -> {
                ArrayList<SPIMapping> list = new ArrayList<SPIMapping>();
                for (Bundle other : this.bundles) {
                    URL entry = other.getEntry(name);
                    if (entry == null) continue;
                    try {
                        list.add(new SPIMapping(other.loadClass(serviceName), other, entry));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                return list;
            });
            Bundle caller = Caller.getBundle(this.junitVersion);
            for (SPIMapping mapping : spis) {
                if (!mapping.isCompatible(caller)) continue;
                result.add(mapping.getUrl());
            }
            return Collections.enumeration(result);
        }
        for (Bundle bundle : this.bundles) {
            Enumeration resources = bundle.getResources(name);
            while (resources != null && resources.hasMoreElements()) {
                result.add(FileLocator.resolve((URL)((URL)resources.nextElement())));
            }
        }
        return Collections.enumeration(result);
    }

    public String toString() {
        return "SPIBundleClassLoader for bundles " + this.bundles;
    }
}

