/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public final class WidgetHistory {
    private static final int HISTORY_LIMIT = 10;

    public static void restoreText(IDialogSettings settings, String key, Text text, String preset) {
        String value = settings.get(key);
        text.setText(value == null || value.length() == 0 ? preset : value);
    }

    public static void saveText(IDialogSettings settings, String key, Text text) {
        settings.put(key, text.getText());
    }

    public static void restoreRadio(IDialogSettings settings, String key, Button ... radios) {
        int idx;
        try {
            idx = settings.getInt(key);
        }
        catch (NumberFormatException e) {
            idx = 0;
        }
        if (idx < 0 || idx >= radios.length) {
            idx = 0;
        }
        radios[idx].setSelection(true);
    }

    public static void saveRadio(IDialogSettings settings, String key, Button ... radios) {
        int idx = 0;
        while (idx < radios.length) {
            if (radios[idx].getSelection()) {
                settings.put(key, idx);
                break;
            }
            ++idx;
        }
    }

    public static void restoreCheck(IDialogSettings settings, String key, Button check) {
        check.setSelection(settings.getBoolean(key));
    }

    public static void saveCheck(IDialogSettings settings, String key, Button check) {
        settings.put(key, check.getSelection());
    }

    public static void restoreCombo(IDialogSettings settings, String key, Combo combo) {
        String[] destinations = settings.getArray(key);
        if (destinations != null) {
            combo.setItems(destinations);
            if (destinations.length > 0) {
                combo.setText(destinations[0]);
            }
        }
    }

    public static void saveCombo(IDialogSettings settings, String key, Combo combo) {
        List<String> history = new ArrayList<String>(Arrays.asList(combo.getItems()));
        history.remove(combo.getText());
        history.add(0, combo.getText());
        if (history.size() > 10) {
            history = history.subList(0, 10);
        }
        settings.put(key, history.toArray(new String[history.size()]));
    }

    private WidgetHistory() {
    }
}

