/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.ddl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.core.rte.IEngineeringCallBack;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.fe.GenericDeltaDdlGenerator;
import org.eclipse.datatools.enablement.ibm.ddl.CoreDdlGenerator;
import org.eclipse.datatools.enablement.ibm.ddl.DdlGenerationMessages;
import org.eclipse.datatools.enablement.ibm.ddl.DdlGenerationUtility;
import org.eclipse.datatools.enablement.ibm.ddl.ModelValidationProvider;
import org.eclipse.datatools.enablement.ibm.util.DependencyImpactAnalyst;
import org.eclipse.datatools.enablement.ibm.util.DependencyImpactDescription;
import org.eclipse.datatools.enablement.ibm.util.EngineeringOptionID;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Role;
import org.eclipse.datatools.modelbase.sql.accesscontrol.RoleAuthorization;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsPackage;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.impl.ChangeDescriptionImpl;

public abstract class CoreDeltaDdlGenerator
extends GenericDeltaDdlGenerator {
    protected boolean dataPreservationRequired = false;
    protected Set<SQLObject> suppressCreateElementSet = null;
    protected EngineeringOption[] selectedOptions = null;
    private boolean isDefaultSelectedOptionsSet = false;
    protected DDLGenerator ddlGenerator = null;
    Pattern[] ALTER_PATTERNS;
    private final String[] ALTER_STRINGS = new String[]{"^alter table .* (drop|add) constraint", "^alter table .*\\s*compress (yes|no)", "^alter table .*\\s*(activate|deactivate)", "^alter tablespace "};

    public DDLGenerator getDdlGeneratorWithDeltaDDLOptions() {
        if (this.ddlGenerator == null) {
            this.ddlGenerator = this.getDDLGenerator();
        }
        return this.ddlGenerator;
    }

    public void setDdlGeneratorWithDeltaDDLOptions(DDLGenerator ddlGenerator) {
        this.ddlGenerator = ddlGenerator;
    }

    protected abstract void setEngineeringCallback(IEngineeringCallBack var1);

    protected boolean checkModel(SQLObject[] sqlObjects, EngineeringOption[] options) {
        boolean ret = true;
        if (!EngineeringOptionID.checkModel(options)) {
            return ret;
        }
        ModelValidationProvider provider = DdlGenerationUtility.getModelValidationProvider();
        if (provider != null) {
            ret = provider.checkModel(sqlObjects);
        }
        return ret;
    }

    public String[] generateDeltaDDL(EObject rootObject, ChangeDescription changeDescription, SQLObject[] impacts, IProgressMonitor monitor, IEngineeringCallBack callback) {
        this.dataPreservationRequired = false;
        this.setDestructive(false);
        this.setEngineeringOption(null);
        this.setEngineeringCallback(callback);
        if (this.selectedOptions == null || this.selectedOptions != null && this.isDefaultSelectedOptionsSet) {
            this.rootObject = rootObject;
            this.populateDefaultSelectedOptions(rootObject);
            this.isDefaultSelectedOptionsSet = true;
        }
        if (!this.checkModel(new SQLObject[]{(SQLObject)rootObject}, this.selectedOptions)) {
            callback.writeMessage(DdlGenerationMessages.FE_INVALID_MODEL);
            return new String[0];
        }
        String[] statements = super.generateDeltaDDL(rootObject, changeDescription, monitor);
        this.changeDescription = changeDescription;
        impacts = this.analyzeImpacts(impacts, statements);
        String[] dropImpactedStatements = this.getDependentsDropStatements(changeDescription, impacts, monitor, callback);
        dropImpactedStatements = this.removeDuplicates(statements, dropImpactedStatements);
        String[] createImpactedStatements = this.getDependentsCreateStatements(changeDescription, impacts, monitor, callback);
        createImpactedStatements = this.removeDuplicates(statements, createImpactedStatements);
        String[] m1 = this.merge(dropImpactedStatements, statements);
        String[] m2 = this.merge(m1, createImpactedStatements);
        this.changeDescription = null;
        m2 = this.postProcess(m2);
        return m2;
    }

    private void populateDefaultSelectedOptions(EObject rootObject) {
        this.selectedOptions = this.getDdlGeneratorOptionsForDeltaDdl(this.getDdlGeneratorWithDeltaDDLOptions(), new SQLObject[]{(SQLObject)rootObject});
        int i = 0;
        while (i < this.selectedOptions.length) {
            EngineeringOption option = this.selectedOptions[i];
            if (!option.getBoolean() && !option.getId().equals("CREATE_OR_REPLACE")) {
                option.setBoolean(true);
            }
            ++i;
        }
    }

    protected String[] postProcess(String[] m2) {
        return m2;
    }

    protected boolean hasDescription(SQLObject object) {
        String description;
        return object != null && (description = object.getDescription()) != null && description.length() > 0;
    }

    private String[] removeDuplicates(String[] existingStatements, String[] statements) {
        TreeSet<String> set = new TreeSet<String>(Arrays.asList(existingStatements));
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < statements.length) {
            if (!set.contains(statements[i])) {
                list.add(statements[i]);
            }
            ++i;
        }
        String[] newStatements = new String[list.size()];
        list.toArray(newStatements);
        return newStatements;
    }

    protected boolean isChangeAnnotationRelated(EObject element, EObject changed, EStructuralFeature feature) {
        if (EcorePackage.eINSTANCE.getEAnnotation().isSuperTypeOf(element.eClass())) {
            return true;
        }
        EObject container = element.eContainer();
        if (container != null && EcorePackage.eINSTANCE.getEAnnotation().isSuperTypeOf(container.eClass())) {
            return true;
        }
        if (EcorePackage.eINSTANCE.getEAnnotation().isSuperTypeOf(changed.eClass())) {
            return true;
        }
        container = changed.eContainer();
        if (container != null && EcorePackage.eINSTANCE.getEAnnotation().isSuperTypeOf(container.eClass())) {
            return true;
        }
        return feature == EcorePackage.eINSTANCE.getEModelElement_EAnnotations();
    }

    protected String[] getDropStatements(DDLGenerator gen, Map changeMap, IProgressMonitor monitor, IEngineeringCallBack callback) {
        Vector<EObject> elements = new Vector<EObject>();
        for (EObject key : changeMap.keySet()) {
            int flag = (Integer)changeMap.get(key);
            if ((flag & 2) == 0) continue;
            if ((flag & 1) == 0 || (flag & 1) != 0 && !this.isSuppressedDrop(key)) {
                elements.add(key);
            }
            if ((flag & 1) == 0 || !SQLTablesPackage.eINSTANCE.getPersistentTable().isSuperTypeOf(key.eClass()) && (!SQLSchemaPackage.eINSTANCE.getSchema().isSuperTypeOf(key.eClass()) || ((Schema)key).getTables() == null || ((Schema)key).getTables().isEmpty())) continue;
            this.setDestructive(true);
        }
        if (elements.size() > 0) {
            Object[] d = new SQLObject[elements.size()];
            elements.copyInto(d);
            return gen.dropSQLObjects((SQLObject[])d, this.generateQuotedIdentifiers(this.getSelectedOptions()), this.generateFullyQualifiedNames(this.getSelectedOptions()), monitor, callback);
        }
        return new String[0];
    }

    protected void addSuppressedDrop(EObject key) {
    }

    protected boolean isSuppressedDrop(EObject key) {
        return false;
    }

    protected void resetSuppressedDrops() {
    }

    protected boolean isDropSuppressedForCreateOrReplace(EObject key) {
        return false;
    }

    protected boolean shouldExcludeElement(EObject element) {
        return element instanceof PersistentTable ? !EngineeringOptionID.generateTables(this.selectedOptions) : (element instanceof ViewTable ? !EngineeringOptionID.generateViews(this.selectedOptions) : (element instanceof Procedure ? !EngineeringOptionID.generateStoredProcedures(this.selectedOptions) : (element instanceof UserDefinedFunction ? !EngineeringOptionID.generateFunctions(this.selectedOptions) : (element instanceof Trigger ? !EngineeringOptionID.generateTriggers(this.selectedOptions) : (element instanceof CheckConstraint ? !EngineeringOptionID.generateCKConstraints(this.selectedOptions) : (element instanceof ForeignKey ? !EngineeringOptionID.generateFKConstraints(this.selectedOptions) : (element instanceof Index ? !EngineeringOptionID.generateIndexes(this.selectedOptions) || ((Index)element).isSystemGenerated() : (element instanceof UserDefinedType ? !EngineeringOptionID.generateUserDefinedTypes(this.selectedOptions) : (element instanceof Sequence ? !EngineeringOptionID.generateSequences(this.selectedOptions) : (element instanceof Role ? !EngineeringOptionID.generateRoles(this.selectedOptions) : (element instanceof Privilege ? !EngineeringOptionID.generateRevokeStatement(this.selectedOptions) : (element instanceof RoleAuthorization ? !EngineeringOptionID.generateRevokeStatement(this.selectedOptions) : (element instanceof UniqueConstraint ? !EngineeringOptionID.generatePKConstraints(this.selectedOptions) || !((UniqueConstraint)element).isEnforced() : (element instanceof Schema ? !EngineeringOptionID.generateSchemas(this.selectedOptions) : (element instanceof Privilege ? !EngineeringOptionID.generateRevokeStatement(this.selectedOptions) : (element instanceof AuthorizationIdentifier ? EngineeringOptionID.generateRevokeStatement(this.selectedOptions) : (element instanceof Role ? !EngineeringOptionID.generateRoles(this.selectedOptions) : element instanceof RoleAuthorization && !EngineeringOptionID.generateRevokeStatement(this.selectedOptions))))))))))))))))));
    }

    protected String[] getCreateStatements(DDLGenerator gen, Map changeMap, IProgressMonitor monitor, IEngineeringCallBack callback) {
        Vector<EObject> elements = new Vector<EObject>();
        for (EObject key : changeMap.keySet()) {
            int flag = (Integer)changeMap.get(key);
            if ((flag & 1) == 0) continue;
            elements.add(key);
        }
        if (elements.size() > 0) {
            Object[] d = new SQLObject[elements.size()];
            elements.copyInto(d);
            return gen.createSQLObjects((SQLObject[])d, this.generateQuotedIdentifiers(this.getSelectedOptions()), this.generateFullyQualifiedNames(this.getSelectedOptions()), monitor, callback);
        }
        return new String[0];
    }

    protected void analyze(Map changeMap) {
        LinkedList elements = new LinkedList();
        elements.addAll(changeMap.keySet());
        for (EObject e : elements) {
            int flag;
            if (!this.needRecreate(e, flag = ((Integer)changeMap.get(e)).intValue())) continue;
            flag = this.setFlagsForRecreate(flag);
            if (e instanceof Column) {
                Column column = (Column)e;
                Table table = column.getTable();
                changeMap.put(table, flag);
                if (!(table instanceof PersistentTable)) continue;
                this.processModifiedTable((PersistentTable)table, changeMap);
                continue;
            }
            if (e instanceof PersistentTable) {
                changeMap.put(e, flag);
                this.processModifiedTable((PersistentTable)e, changeMap);
                continue;
            }
            if (e instanceof UniqueConstraint) {
                changeMap.put(e, flag);
                this.processModifiedUniqueConstraint((UniqueConstraint)e, changeMap);
                continue;
            }
            if (e instanceof Index) {
                changeMap.put(e, flag);
                this.processModifiedIndex((Index)e, changeMap);
                continue;
            }
            changeMap.put(e, flag);
        }
    }

    protected int setFlagsForRecreate(int flag) {
        flag &= 0x30;
        flag = flag | 1 | 2;
        return flag;
    }

    protected synchronized Pattern[] getAlterPatterns() {
        if (this.ALTER_PATTERNS == null) {
            this.ALTER_PATTERNS = new Pattern[this.ALTER_STRINGS.length];
            int i = 0;
            while (i < this.ALTER_STRINGS.length) {
                this.ALTER_PATTERNS[i] = Pattern.compile(this.ALTER_STRINGS[i], 2);
                ++i;
            }
        }
        return this.ALTER_PATTERNS;
    }

    protected SQLObject[] analyzeImpacts(SQLObject[] dependents, String[] statements) {
        boolean hasImpact = false;
        int i = 0;
        while (i < statements.length) {
            block5: {
                if (!(statements[i].startsWith("COMMENT ON") || statements[i].startsWith("REVOKE") || statements[i].startsWith("GRANT"))) {
                    Pattern[] patternArray = this.getAlterPatterns();
                    int n = patternArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Pattern pattern = patternArray[n2];
                        Matcher matcher = pattern.matcher(statements[i]);
                        if (!matcher.find()) {
                            ++n2;
                            continue;
                        }
                        break block5;
                    }
                    hasImpact = true;
                    break;
                }
            }
            ++i;
        }
        if (hasImpact) {
            return dependents;
        }
        return new SQLObject[0];
    }

    protected boolean isAncestorModified(Map changeMap, EObject e) {
        if (this.isRenameTableSupported()) {
            for (Object c : ContainmentServiceImpl.INSTANCE.getAllContainers(e)) {
                if (!changeMap.containsKey(c)) continue;
                int flag = (Integer)changeMap.get(c);
                if ((flag & 7) != 0) {
                    return true;
                }
                if (c instanceof PersistentTable || (flag & 8) == 0) continue;
                return true;
            }
            return false;
        }
        return super.ancestorModified(changeMap, e);
    }

    protected boolean isRenameTableSupported() {
        return false;
    }

    protected boolean isRenamedTable(EObject e, int flag) {
        return (flag & 8) != 0 && SQLTablesPackage.eINSTANCE.getPersistentTable().isSuperTypeOf(e.eClass());
    }

    protected void processModifiedUniqueConstraint(UniqueConstraint uk, Map changeMap) {
        for (ForeignKey fk : uk.getForeignKey()) {
            if (this.isCreated((EObject)fk)) continue;
            int flag = 0;
            if (changeMap.containsKey(fk)) {
                flag = (Integer)changeMap.get(fk);
            }
            flag &= 0xFFFFFFF3;
            changeMap.put(fk, flag |= 3);
        }
    }

    private void processModifiedIndex(Index index, Map changeMap) {
        for (ForeignKey fk : index.getForeignKey()) {
            if (this.isCreated((EObject)fk)) continue;
            int flag = 0;
            if (changeMap.containsKey(fk)) {
                flag = (Integer)changeMap.get(fk);
            }
            flag &= 0xFFFFFFF3;
            changeMap.put(fk, flag |= 3);
        }
    }

    private void processModifiedTable(PersistentTable table, Map changeMap) {
        int flag;
        for (UniqueConstraint uk : table.getUniqueConstraints()) {
            if (this.isCreated((EObject)uk)) continue;
            flag = 0;
            if (changeMap.containsKey(uk)) {
                flag = (Integer)changeMap.get(uk);
            }
            flag &= 0xFFFFFFF3;
            changeMap.put(uk, flag |= 3);
            this.processModifiedUniqueConstraint(uk, changeMap);
        }
        for (Index index : table.getIndex()) {
            if (this.isCreated((EObject)index)) continue;
            flag = 0;
            if (changeMap.containsKey(index)) {
                flag = (Integer)changeMap.get(index);
            }
            flag = this.modifyIndexChangeFlag(index, changeMap, flag);
            changeMap.put(index, flag);
            this.processModifiedIndex(index, changeMap);
        }
        for (ForeignKey fk : table.getForeignKeys()) {
            if (this.isCreated((EObject)fk)) continue;
            flag = 0;
            if (changeMap.containsKey(fk)) {
                flag = (Integer)changeMap.get(fk);
            }
            flag &= 0xFFFFFFF3;
            changeMap.put(fk, flag |= 3);
        }
        for (ForeignKey fk : table.getReferencingForeignKeys()) {
            if (this.isCreated((EObject)fk)) continue;
            flag = 0;
            if (changeMap.containsKey(fk)) {
                flag = (Integer)changeMap.get(fk);
            }
            flag &= 0xFFFFFFF3;
            changeMap.put(fk, flag |= 3);
        }
        for (Constraint ck : table.getConstraints()) {
            if (!SQLConstraintsPackage.eINSTANCE.getCheckConstraint().isSuperTypeOf(ck.eClass()) || this.isCreated((EObject)ck)) continue;
            flag = 0;
            if (changeMap.containsKey(ck)) {
                flag = (Integer)changeMap.get(ck);
            }
            flag &= 0xFFFFFFF3;
            changeMap.put(ck, flag |= 3);
        }
        for (Trigger trigger : table.getTriggers()) {
            if (this.isCreated((EObject)trigger)) continue;
            flag = 0;
            if (changeMap.containsKey(trigger)) {
                flag = (Integer)changeMap.get(trigger);
            }
            flag &= 0xFFFFFFF3;
            changeMap.put(trigger, flag |= 3);
        }
        for (Column column : table.getColumns()) {
            if (!this.hasDescription((SQLObject)column)) continue;
            Integer flag2 = 0;
            if (changeMap.containsKey(column)) {
                flag2 = (Integer)changeMap.get(column);
            }
            flag2 = flag2 | 0x10;
            changeMap.put(column, flag2);
        }
        List<ViewTable> impactedViews = this.getDependentViews((Table)table);
        for (ViewTable view : impactedViews) {
            int flag3 = 0;
            if (changeMap.containsKey(view)) {
                flag3 = (Integer)changeMap.get(view);
            }
            flag3 &= 0xFFFFFFF3;
            changeMap.put(view, flag3 |= 3);
        }
    }

    protected List<ViewTable> getDependentViews(Table table) {
        ArrayList<ViewTable> impactedViews = new ArrayList<ViewTable>();
        DependencyImpactDescription[] impacts = DependencyImpactAnalyst.getInstance().getDirectImpacted((EObject)table);
        int i = 0;
        while (i < impacts.length) {
            EObject target = impacts[i].getTarget();
            if (target != null && target instanceof ViewTable) {
                impactedViews.add((ViewTable)target);
            }
            ++i;
        }
        return impactedViews;
    }

    protected int modifyIndexChangeFlag(Index index, Map changeMap, int flag) {
        flag &= 0xFFFFFFF3;
        return flag |= 3;
    }

    protected void suppressCreate(SQLObject element) {
        if (this.suppressCreateElementSet == null) {
            this.suppressCreateElementSet = new HashSet<SQLObject>();
        }
        this.suppressCreateElementSet.add(element);
    }

    protected void propagateColumnRename(Column column, Map changeMap) {
        EList columns;
        PrimaryKey current2;
        Table table = column.getTable();
        HashSet<PrimaryKey> uCs = new HashSet<PrimaryKey>();
        HashSet<PrimaryKey> uIs = new HashSet<PrimaryKey>();
        if (table == null || !SQLTablesPackage.eINSTANCE.getPersistentTable().isSuperTypeOf(table.eClass())) {
            return;
        }
        for (PrimaryKey current2 : ((PersistentTable)table).getUniqueConstraints()) {
            if (current2 == null || (columns = current2.getMembers()) == null || !columns.contains((Object)column)) continue;
            this.updateMapFlags((EObject)current2, changeMap, 0, 3);
            uCs.add(current2);
        }
        current2 = ((PersistentTable)table).getPrimaryKey();
        if (current2 != null && (columns = current2.getMembers()) != null && columns.contains((Object)column)) {
            this.updateMapFlags((EObject)current2, changeMap, 0, 3);
            uCs.add(current2);
        }
        for (PrimaryKey current2 : ((PersistentTable)table).getIndex()) {
            if (current2 == null) continue;
            columns = current2.getMembers();
            if (this.indexMemberListContains(columns, column)) {
                this.updateMapFlags((EObject)current2, changeMap, 0, 3);
                if (!current2.isUnique()) continue;
                uIs.add(current2);
                continue;
            }
            columns = current2.getIncludedMembers();
            if (!this.indexMemberListContains(columns, column)) continue;
            this.updateMapFlags((EObject)current2, changeMap, 0, 3);
        }
        for (PrimaryKey current2 : ((PersistentTable)table).getForeignKeys()) {
            if (current2 == null || (columns = current2.getMembers()) == null || !columns.contains((Object)column)) continue;
            this.updateMapFlags((EObject)current2, changeMap, 0, 3);
        }
        block3: for (PrimaryKey current2 : ((PersistentTable)table).getReferencingForeignKeys()) {
            if (current2 == null) continue;
            Iterator it1 = uCs.iterator();
            while (it1.hasNext()) {
                if (current2.getUniqueConstraint() != it1.next()) continue;
                this.updateMapFlags((EObject)current2, changeMap, 0, 3);
                continue block3;
            }
            Iterator it2 = uIs.iterator();
            while (it2.hasNext()) {
                if (current2.getUniqueIndex() != it2.next()) continue;
                this.updateMapFlags((EObject)current2, changeMap, 0, 3);
                continue block3;
            }
            EList columns2 = current2.getReferencedMembers();
            if (columns2 == null || !columns2.contains((Object)column)) continue;
            this.updateMapFlags((EObject)current2, changeMap, 0, 3);
        }
        for (PrimaryKey current2 : ((PersistentTable)table).getTriggers()) {
            if (current2 == null || (columns = current2.getTriggerColumn()) == null || !columns.contains((Object)column)) continue;
            this.updateMapFlags((EObject)current2, changeMap, 0, 3);
        }
    }

    protected boolean indexMemberListContains(EList columns, Column column) {
        if (columns != null && column != null) {
            for (Object indexMember : columns) {
                if (indexMember == null || !(indexMember instanceof IndexMember) || ((IndexMember)indexMember).getColumn() != column) continue;
                return true;
            }
        }
        return false;
    }

    protected void removeRedundantColumnChange(Map changeMap, Map colMap) {
        Iterator it = colMap.keySet().iterator();
        Table table = null;
        while (it.hasNext()) {
            Column column = (Column)it.next();
            int flag = (Integer)colMap.get(column);
            if (flag == 2) {
                EObject obj = ((ChangeDescriptionImpl)this.changeDescription).getOldContainer((EObject)column);
                if (SQLTablesPackage.eINSTANCE.getTable().isSuperTypeOf(obj.eClass())) {
                    table = (Table)((ChangeDescriptionImpl)this.changeDescription).getOldContainer((EObject)column);
                }
            }
            if (table == null) {
                table = column.getTable();
            }
            if (!SQLTablesPackage.eINSTANCE.getPersistentTable().isSuperTypeOf(table.eClass()) || !changeMap.containsKey(table) || ((flag = ((Integer)changeMap.get(table)).intValue()) & 2) == 0) continue;
            it.remove();
        }
    }

    protected String[] processChangeMap(Map changeMap, IProgressMonitor monitor, IEngineeringCallBack callback) {
        DDLGenerator ddlGenerator = this.getDdlGeneratorWithDeltaDDLOptions();
        this.undo();
        String[] drops = new String[]{};
        String[] creates = new String[]{};
        if (EngineeringOptionID.generateDropStatement(this.selectedOptions)) {
            drops = this.getDropStatements(ddlGenerator, changeMap, monitor, callback);
        }
        this.redo();
        if (EngineeringOptionID.generateCreateStatement(this.selectedOptions)) {
            creates = this.getCreateStatements(ddlGenerator, changeMap, monitor, callback);
        }
        this.changeDescription = null;
        return this.merge(drops, creates);
    }

    protected boolean generateQuotedIdentifiers(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_QUOTED_IDENTIFIER", options);
    }

    protected boolean generateFullyQualifiedNames(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_FULLY_QUALIFIED_NAME", options);
    }

    private boolean getOptionValueByID(String optionID, EngineeringOption[] options) {
        return EngineeringOptionID.getOptionValueByID((String)optionID, (EngineeringOption[])options);
    }

    public String[] generateDeltaDDL(EObject rootObject, ChangeDescription changeDescription, SQLObject[] impacts, IProgressMonitor monitor) {
        return this.generateDeltaDDL(rootObject, changeDescription, impacts, monitor, null);
    }

    protected String[] getDependentsDropStatements(ChangeDescription changeDescription, SQLObject[] impacts, IProgressMonitor monitor, IEngineeringCallBack callback) {
        CoreDdlGenerator generator = (CoreDdlGenerator)this.getDdlGeneratorWithDeltaDDLOptions();
        if (impacts.length > 0) {
            generator.getSelectedOptions(impacts);
            int count = 0;
            while (count < impacts.length) {
                if (SQLTablesPackage.eINSTANCE.getPersistentTable().isSuperTypeOf(impacts[count].eClass())) {
                    this.setDestructive(true);
                }
                ++count;
            }
            return generator.dropSQLObjects(impacts, EngineeringOptionID.generateQuotedIdentifiers(this.getSelectedOptions()), EngineeringOptionID.generateFullyQualifiedNames(this.getSelectedOptions()), monitor, callback);
        }
        return new String[0];
    }

    protected final String[] getDependentsCreateStatements(ChangeDescription changeDescription, SQLObject[] impacts, IProgressMonitor monitor) {
        CoreDdlGenerator generator = (CoreDdlGenerator)this.getDdlGeneratorWithDeltaDDLOptions();
        if (impacts.length > 0) {
            generator.getSelectedOptions(impacts);
            return generator.createSQLObjects(impacts, EngineeringOptionID.generateQuotedIdentifiers(this.getSelectedOptions()), EngineeringOptionID.generateFullyQualifiedNames(this.getSelectedOptions()), monitor, null);
        }
        return new String[0];
    }

    protected String[] getDependentsCreateStatements(ChangeDescription changeDescription, SQLObject[] impacts, IProgressMonitor monitor, IEngineeringCallBack callback) {
        CoreDdlGenerator generator = (CoreDdlGenerator)this.getDdlGeneratorWithDeltaDDLOptions();
        if (impacts.length > 0) {
            generator.getSelectedOptions(impacts);
            return generator.createSQLObjects(impacts, EngineeringOptionID.generateQuotedIdentifiers(this.getSelectedOptions()), EngineeringOptionID.generateFullyQualifiedNames(this.getSelectedOptions()), monitor, callback);
        }
        return new String[0];
    }

    public Table getOldContainer(Column column) {
        return (Table)((ChangeDescriptionImpl)this.changeDescription).getOldContainer((EObject)column);
    }

    protected boolean isColumnInPrimaryKey(Column column) {
        PrimaryKey key;
        Table table = column.getTable();
        return table instanceof BaseTable && (key = ((BaseTable)table).getPrimaryKey()) != null && key.getMembers().contains((Object)column);
    }

    public boolean isDataPreservationRequired() {
        return this.dataPreservationRequired;
    }

    public EngineeringOption[] getDdlGeneratorOptionsForDeltaDdl(DDLGenerator ddlGenerator, SQLObject[] sqlObjects) {
        EngineeringOption[] ddlGenOptions = ddlGenerator.getOptions(sqlObjects);
        int i = 0;
        while (i < ddlGenOptions.length) {
            EngineeringOption option = ddlGenOptions[i];
            if (option != null) {
                if (option.getId().equals("GENERATE_FULLY_QUALIFIED_NAME")) {
                    option.setBoolean(DdlGenerationUtility.getQualifyNamesDefault());
                } else if (option.getId().equals("GENERATE_QUOTED_IDENTIFIER")) {
                    option.setBoolean(DdlGenerationUtility.getQuoteIdentifiersDefault());
                }
            }
            ++i;
        }
        return ddlGenOptions;
    }

    protected int getColumnsChangeFlag(EObject element, EStructuralFeature feature) {
        List previousValue;
        List currentValue;
        if (feature == SQLTablesPackage.eINSTANCE.getTable_Columns() && this.isOrderChanged(currentValue = (List)element.eGet(feature), previousValue = (List)this.getOldValue(feature, element))) {
            return 4;
        }
        return 0;
    }

    protected int updateMapFlags(EObject element, Map map, int flagsToReset, int flagsToSet) {
        int flags = 0;
        if (map.containsKey(element)) {
            flags = (Integer)map.get(element);
            if (flagsToReset != 0) {
                flags &= ~flagsToReset;
            }
        }
        if (flagsToSet != 0) {
            flags |= flagsToSet;
        }
        map.put(element, flags);
        return flags;
    }

    protected boolean isRenameColumnSupported() {
        return false;
    }

    private boolean isOrderChanged(List current, List previous) {
        ArrayList<SQLObject> currentList = new ArrayList<SQLObject>(current.size());
        for (SQLObject object : current) {
            currentList.add(object);
        }
        ArrayList<SQLObject> previousList = new ArrayList<SQLObject>(previous.size());
        for (SQLObject object : previous) {
            previousList.add(object);
        }
        int index = 0;
        while (index < previousList.size()) {
            if (!currentList.contains(previousList.get(index))) {
                previousList.remove(index--);
            }
            ++index;
        }
        index = 0;
        while (index < previousList.size()) {
            if (currentList.get(index) != previousList.get(index)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public EngineeringOption[] getSelectedOptions() {
        return this.selectedOptions;
    }

    public void setSelectedOptions(EngineeringOption[] selectedOptions) {
        this.selectedOptions = selectedOptions;
    }
}

