/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer;

import java.util.TreeSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer.AbstractSerializerAdapter;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer.WsSerializerAdapter;
import org.eclipse.jst.ws.jaxws.utils.ContractChecker;
import org.eclipse.jst.ws.jaxws.utils.JaxWsUtils;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;

public class SeiSerializerAdapter
extends AbstractSerializerAdapter {
    public SeiSerializerAdapter(JaxWsWorkspaceResource resource) {
        super(resource);
    }

    @Override
    protected boolean isAnnotationRequired() {
        return true;
    }

    @Override
    protected IAnnotation<? extends IJavaElement> getAnnotation() throws JavaModelException {
        assert (this.getTarget() instanceof IServiceEndpointInterface);
        return this.createIAnnotation((IServiceEndpointInterface)this.getTarget(), this.resource().javaModel());
    }

    protected IAnnotation<? extends IJavaElement> createIAnnotation(IServiceEndpointInterface sei, IJavaModel javaModel) throws JavaModelException {
        ContractChecker.nullCheckParam((Object)sei, (String)"sei");
        ContractChecker.nullCheckParam((Object)javaModel, (String)"javaModel");
        if (sei.isImplicit()) {
            if (sei.getImplementingWebServices().size() == 0) {
                return null;
            }
            return new WsSerializerAdapter(this.resource()).createIAnnotation((IWebService)sei.getImplementingWebServices().get(0), javaModel);
        }
        IType type = this.findType(sei, sei.getImplementation());
        if (type == null) {
            return null;
        }
        TreeSet<IParamValuePair> paramValuePairs = this.createParamValueSortedTreeSet();
        if (sei.getName() != null && !sei.getName().equals(JaxWsUtils.getDefaultPorttypeName((String)sei.getImplementation()))) {
            paramValuePairs.add(this.createParamValue("name", sei.getName()));
        }
        if (sei.getTargetNamespace() != null && !sei.getTargetNamespace().equals(JaxWsUtils.composeJaxWsTargetNamespaceByPackage((String)type.getPackageFragment().getElementName()))) {
            paramValuePairs.add(this.createParamValue("targetNamespace", sei.getTargetNamespace()));
        }
        return AnnotationFactory.createAnnotation((String)"javax.jws.WebService", (IJavaElement)type, paramValuePairs);
    }
}

