/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction.java;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IIdentifiable;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.util.ManifestUtils;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.java.SearchRepositoriesForIUProposal;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.TextEdit;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class JavaResolutionFactory {
    public static final int TYPE_JAVA_COMPLETION = 1;
    public static final int TYPE_CLASSPATH_FIX = 2;

    private static Version getRequirementVersion(Version bundleVersion) {
        return new Version(bundleVersion.getMajor(), bundleVersion.getMinor(), 0);
    }

    public static AbstractManifestChange<BundleDescription> createRequireBundleChange(IProject project, BundleDescription desc, CompilationUnit cu, String qualifiedTypeToImport) {
        return new RequireBundleManifestChange(project, desc, cu, qualifiedTypeToImport);
    }

    public static AbstractManifestChange<ExportPackageDescription> createImportPackageChange(IProject project, ExportPackageDescription desc, CompilationUnit cu, String qualifiedTypeToImport) {
        return new ImportPackageManifestChange(project, desc, cu, qualifiedTypeToImport);
    }

    public static final IJavaCompletionProposal createSearchRepositoriesProposal(String packageName) {
        return new SearchRepositoriesForIUProposal(packageName);
    }

    public static AbstractManifestChange<IPackageFragment> createExportPackageChange(IProject project, IPackageFragment pkg) {
        return new ExportPackageChange(project, pkg);
    }

    public static final ClasspathFixProcessor.ClasspathFixProposal createClasspathFixProposal(final AbstractManifestChange<?> change, final int relevance) {
        return new ClasspathFixProcessor.ClasspathFixProposal(){

            public Change createChange(IProgressMonitor monitor) throws CoreException {
                return change;
            }

            public String getAdditionalProposalInfo() {
                return change.getDescription();
            }

            public String getDisplayString() {
                return change.getName();
            }

            public Image getImage() {
                return change.getImage();
            }

            public int getRelevance() {
                return relevance;
            }
        };
    }

    public static final IJavaCompletionProposal createJavaCompletionProposal(final AbstractManifestChange<?> change, final int relevance) {
        return new IJavaCompletionProposal(){

            public int getRelevance() {
                return relevance;
            }

            public void apply(IDocument document) {
                try {
                    change.perform((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }

            public String getAdditionalProposalInfo() {
                return change.getDescription();
            }

            public IContextInformation getContextInformation() {
                return null;
            }

            public String getDisplayString() {
                return change.getName();
            }

            public Image getImage() {
                return change.getImage();
            }

            public Point getSelection(IDocument document) {
                return null;
            }
        };
    }

    static abstract class AbstractManifestChange<T>
    extends Change {
        private final T fChangeObject;
        private final IProject fProject;
        private final CompilationUnit fCompilationUnit;
        private final String fQualifiedTypeToImport;

        public AbstractManifestChange(IProject project, T changeObj, CompilationUnit cu, String qualifiedTypeToImport) {
            this.fProject = project;
            this.fChangeObject = changeObj;
            this.fCompilationUnit = cu;
            this.fQualifiedTypeToImport = qualifiedTypeToImport;
        }

        protected T getChangeObject() {
            return this.fChangeObject;
        }

        protected IProject getProject() {
            return this.fProject;
        }

        protected CompilationUnit getCompilationUnit() {
            return this.fCompilationUnit;
        }

        protected String getQualifiedTypeToImport() {
            return this.fQualifiedTypeToImport;
        }

        public abstract Image getImage();

        public abstract String getDescription();

        protected boolean isUndo() {
            return false;
        }

        protected void insertImport(CompilationUnit compilationUnit, String qualifiedTypeToImport, IProgressMonitor pm) throws CoreException {
            if (compilationUnit == null || qualifiedTypeToImport == null) {
                return;
            }
            ImportRewrite rewrite = ImportRewrite.create((CompilationUnit)compilationUnit, (boolean)true);
            if (rewrite == null) {
                return;
            }
            if (!this.isUndo()) {
                rewrite.addImport(qualifiedTypeToImport);
            } else {
                rewrite.removeImport(qualifiedTypeToImport);
            }
            TextEdit rewriteImports = rewrite.rewriteImports(pm);
            ICompilationUnit iCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement().getAdapter(IOpenable.class);
            this.performTextEdit(rewriteImports, (IFile)iCompilationUnit.getResource(), pm);
        }

        private void performTextEdit(TextEdit textEdit, IFile file, IProgressMonitor pm) throws CoreException {
            TextFileChange textFileChange = new TextFileChange("Add import for " + this.fQualifiedTypeToImport, file);
            textFileChange.setSaveMode(1);
            textFileChange.setEdit(textEdit);
            textFileChange.perform(pm);
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return RefactoringStatus.create((IStatus)Status.OK_STATUS);
        }

        public Object getModifiedElement() {
            return this.getProject();
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }
    }

    private static class ExportPackageChange
    extends AbstractManifestChange<IPackageFragment> {
        ExportPackageChange(IProject project, IPackageFragment fragment) {
            super(project, fragment, null, null);
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            ModelModification mod = new ModelModification(this.getProject()){

                @Override
                protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                    if (model instanceof IBundlePluginModelBase) {
                        IBundlePluginModelBase base = (IBundlePluginModelBase)model;
                        IBundle bundle = base.getBundleModel().getBundle();
                        ExportPackageHeader header = (ExportPackageHeader)bundle.getManifestHeader("Export-Package");
                        if (header == null) {
                            bundle.setHeader("Export-Package", "");
                            header = (ExportPackageHeader)bundle.getManifestHeader("Export-Package");
                        }
                        header.addPackage((PackageObject)new ExportPackageObject((ManifestHeader)header, (IPackageFragment)this.getChangeObject(), "version"));
                    }
                }
            };
            PDEModelUtility.modifyModel(mod, (IProgressMonitor)new NullProgressMonitor());
            return null;
        }

        public String getName() {
            return NLS.bind((String)PDEUIMessages.ForbiddenAccessProposal_quickfixMessage, (Object[])new String[]{((IPackageFragment)this.getChangeObject()).getElementName(), this.getProject().getName()});
        }

        @Override
        public Image getImage() {
            return PDEPluginImages.get(PDEPluginImages.OBJ_DESC_BUNDLE);
        }

        @Override
        public Object getModifiedElement() {
            IFile file = PDEProject.getManifest((IProject)this.getProject());
            if (file.exists()) {
                return file;
            }
            return super.getModifiedElement();
        }

        @Override
        public String getDescription() {
            return null;
        }
    }

    private static class ImportPackageManifestChange
    extends AbstractManifestChange<ExportPackageDescription> {
        ImportPackageManifestChange(IProject project, ExportPackageDescription desc, CompilationUnit cu, String qualifiedTypeToImport) {
            super(project, desc, cu, qualifiedTypeToImport);
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            PDEModelUtility.modifyModel(new ModelModification(this.getProject()){

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                    void base;
                    if (!(model instanceof IBundlePluginModelBase)) {
                        return;
                    }
                    IBundlePluginModelBase iBundlePluginModelBase = (IBundlePluginModelBase)model;
                    IBundle bundle = base.getBundleModel().getBundle();
                    ExportPackageDescription desc = (ExportPackageDescription)this.getChangeObject();
                    String pkgId = desc.getName();
                    IManifestHeader header = bundle.getManifestHeader("Import-Package");
                    if (header == null) {
                        header = bundle.getModel().getFactory().createHeader("Import-Package", pkgId);
                    }
                    if (header instanceof ImportPackageHeader) {
                        ImportPackageHeader ipHeader = (ImportPackageHeader)header;
                        String versionAttr = BundlePluginBase.getBundleManifestVersion((IBundle)bundle) < 2 ? "specification-version" : "version";
                        ImportPackageObject impObject = new ImportPackageObject((ManifestHeader)ipHeader, desc, versionAttr);
                        if (!this.isUndo()) {
                            ipHeader.addPackage((PackageObject)impObject);
                        } else {
                            ipHeader.removePackage((PackageObject)impObject);
                        }
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
            this.insertImport(this.getCompilationUnit(), this.getQualifiedTypeToImport(), pm);
            if (!this.isUndo()) {
                return new ImportPackageManifestChange(this.getProject(), (ExportPackageDescription)this.getChangeObject(), this.getCompilationUnit(), this.getQualifiedTypeToImport()){

                    @Override
                    public boolean isUndo() {
                        return true;
                    }
                };
            }
            return null;
        }

        @Override
        public String getDescription() {
            return PDEUIMessages.UnresolvedImportFixProcessor_5;
        }

        @Override
        public Image getImage() {
            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_BUNDLE_OBJ);
        }

        public String getName() {
            ExportPackageDescription importedPackage = (ExportPackageDescription)this.getChangeObject();
            return MessageFormat.format(!this.isUndo() ? PDEUIMessages.UnresolvedImportFixProcessor_3 : PDEUIMessages.UnresolvedImportFixProcessor_4, importedPackage.getName(), JavaResolutionFactory.getRequirementVersion(importedPackage.getVersion()));
        }

        @Override
        public Object getModifiedElement() {
            IFile file = PDEProject.getManifest((IProject)this.getProject());
            if (file.exists()) {
                return file;
            }
            return super.getModifiedElement();
        }
    }

    private static class RequireBundleManifestChange
    extends AbstractManifestChange<BundleDescription> {
        RequireBundleManifestChange(IProject project, BundleDescription desc, CompilationUnit cu, String qualifiedTypeToImport) {
            super(project, desc, cu, qualifiedTypeToImport);
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            PDEModelUtility.modifyModel(new ModelModification(this.getProject()){

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                    void base;
                    if (!(model instanceof IPluginModelBase)) {
                        return;
                    }
                    IPluginModelBase iPluginModelBase = (IPluginModelBase)model;
                    BundleDescription requiredBundle = (BundleDescription)this.getChangeObject();
                    String pluginId = requiredBundle.getSymbolicName();
                    IPluginImport[] imports = base.getPluginBase().getImports();
                    if (!this.isUndo()) {
                        if (Arrays.stream(imports).map(IIdentifiable::getId).anyMatch(pluginId::equals)) {
                            return;
                        }
                        IPluginImport impt = base.getPluginFactory().createImport();
                        impt.setId(pluginId);
                        Optional<String> versionRange = ManifestUtils.createConsumerRequirementRange((Version)requiredBundle.getVersion()).map(VersionRange::toString);
                        if (versionRange.isPresent()) {
                            impt.setVersion(versionRange.get());
                        }
                        base.getPluginBase().add(impt);
                    } else {
                        IPluginImport[] iPluginImportArray = imports;
                        int n = imports.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IPluginImport pluginImport = iPluginImportArray[n2];
                            if (pluginImport.getId().equals(pluginId)) {
                                base.getPluginBase().remove(pluginImport);
                            }
                            ++n2;
                        }
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
            this.insertImport(this.getCompilationUnit(), this.getQualifiedTypeToImport(), pm);
            if (!this.isUndo()) {
                return new RequireBundleManifestChange(this.getProject(), (BundleDescription)this.getChangeObject(), this.getCompilationUnit(), this.getQualifiedTypeToImport()){

                    @Override
                    public boolean isUndo() {
                        return true;
                    }
                };
            }
            return null;
        }

        @Override
        public Image getImage() {
            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REQ_PLUGIN_OBJ);
        }

        @Override
        public String getDescription() {
            return PDEUIMessages.UnresolvedImportFixProcessor_2;
        }

        public String getName() {
            BundleDescription requiredBundle = (BundleDescription)this.getChangeObject();
            return MessageFormat.format(!this.isUndo() ? PDEUIMessages.UnresolvedImportFixProcessor_0 : PDEUIMessages.UnresolvedImportFixProcessor_1, requiredBundle.getName(), JavaResolutionFactory.getRequirementVersion(requiredBundle.getVersion()));
        }

        @Override
        public Object getModifiedElement() {
            IFile[] files;
            IFile[] iFileArray = files = new IFile[]{PDEProject.getManifest((IProject)this.getProject()), PDEProject.getPluginXml((IProject)this.getProject())};
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file.exists()) {
                    return file;
                }
                ++n2;
            }
            return super.getModifiedElement();
        }
    }
}

