/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.notify.impl.NotifyingListImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.mapping.MappedObjectState;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingFactory;
import org.eclipse.emf.mapping.MappingPackage;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.domain.MappingDomain;
import org.eclipse.emf.mapping.impl.MappingImpl;

public class MappingRootImpl
extends MappingImpl
implements MappingRoot {
    protected static final boolean OUTPUT_READ_ONLY_EDEFAULT = false;
    protected boolean outputReadOnly = false;
    protected static final boolean TOP_TO_BOTTOM_EDEFAULT = false;
    protected boolean topToBottom = false;
    protected static final String COMMAND_STACK_EDEFAULT = null;
    protected String commandStack = COMMAND_STACK_EDEFAULT;
    protected MappingDomain domain;
    protected boolean outputDirty = false;
    protected AdapterImpl mappedObjectListener;
    protected AdapterFactory mappedObjectStateAdapterFactory = this.createMappedObjectStateAdapterFactory();

    protected MappingRootImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return MappingPackage.Literals.MAPPING_ROOT;
    }

    @Override
    public boolean isOutputReadOnly() {
        return this.outputReadOnly;
    }

    @Override
    public void setOutputReadOnly(boolean newOutputReadOnly) {
        boolean oldOutputReadOnly = this.outputReadOnly;
        this.outputReadOnly = newOutputReadOnly;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldOutputReadOnly, this.outputReadOnly));
        }
    }

    @Override
    public boolean isTopToBottom() {
        return this.topToBottom;
    }

    @Override
    public void setTopToBottom(boolean newTopToBottom) {
        boolean oldTopToBottom = this.topToBottom;
        this.topToBottom = newTopToBottom;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldTopToBottom, this.topToBottom));
        }
    }

    @Override
    public String getCommandStack() {
        return this.commandStack;
    }

    @Override
    public void setCommandStack(String newCommandStack) {
        String oldCommandStack = this.commandStack;
        this.commandStack = newCommandStack;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldCommandStack, (Object)this.commandStack));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.isOutputReadOnly();
            }
            case 7: {
                return this.isTopToBottom();
            }
            case 8: {
                return this.getCommandStack();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setOutputReadOnly((Boolean)newValue);
                return;
            }
            case 7: {
                this.setTopToBottom((Boolean)newValue);
                return;
            }
            case 8: {
                this.setCommandStack((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setOutputReadOnly(false);
                return;
            }
            case 7: {
                this.setTopToBottom(false);
                return;
            }
            case 8: {
                this.setCommandStack(COMMAND_STACK_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return this.outputReadOnly;
            }
            case 7: {
                return this.topToBottom;
            }
            case 8: {
                return COMMAND_STACK_EDEFAULT == null ? this.commandStack != null : !COMMAND_STACK_EDEFAULT.equals(this.commandStack);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (outputReadOnly: ");
        result.append(this.outputReadOnly);
        result.append(", topToBottom: ");
        result.append(this.topToBottom);
        result.append(", commandStack: ");
        result.append(this.commandStack);
        result.append(')');
        return result.toString();
    }

    @Override
    public MappingDomain getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(MappingDomain domain) {
        if (this.domain != domain) {
            if (this.domain != null) {
                this.eAdapters.remove((Object)this.mappedObjectListener);
            }
            this.domain = domain;
            domain.setMappingRoot(this);
            this.mappedObjectListener = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    Object feature = notification.getFeature();
                    if (feature == MappingPackage.eINSTANCE.getMapping_Inputs() || feature == MappingPackage.eINSTANCE.getMapping_Outputs()) {
                        MappingRootImpl.this.initializeMappedObjectStates();
                    }
                }
            };
            this.eAdapters().add((Object)this.mappedObjectListener);
            this.initializeMappedObjectStates();
        }
    }

    @Override
    public void refreshMappedObjectStates(Mapping subtree) {
        MappedObjectState mappedObjectState;
        TreeIterator objects;
        for (Object input : subtree.getInputs()) {
            objects = this.domain.treeIterator(input);
            while (objects.hasNext()) {
                Object object = objects.next();
                mappedObjectState = this.getMappedObjectState(object);
                if (mappedObjectState == null) continue;
                mappedObjectState.setInput();
            }
        }
        for (Object output : subtree.getOutputs()) {
            objects = this.domain.treeIterator(output);
            while (objects.hasNext()) {
                MappedObjectState mappedObjectState2 = this.getMappedObjectState(objects.next());
                if (mappedObjectState2 == null) continue;
                mappedObjectState2.setOutput();
            }
        }
        TreeIterator<Mapping> mappings = subtree.treeIterator();
        while (mappings.hasNext()) {
            Mapping mapping = (Mapping)mappings.next();
            for (Object input : mapping.getInputs()) {
                mappedObjectState = this.getMappedObjectState(input);
                if (mappedObjectState == null) continue;
                mappedObjectState.getMappings().add(mapping);
            }
            for (Object output : mapping.getOutputs()) {
                mappedObjectState = this.getMappedObjectState(output);
                if (mappedObjectState == null) continue;
                mappedObjectState.getMappings().add(mapping);
            }
        }
    }

    protected void initializeMappedObjectStates() {
        this.refreshMappedObjectStates(this);
        if (this.getTypeMapping() instanceof MappingRootImpl) {
            ((MappingRootImpl)this.getTypeMapping()).initializeMappedObjectStates();
        }
    }

    @Override
    public Mapping getParentMapping(Collection<?> collection) {
        Mapping result = this;
        ArrayList<List> allTreePaths = new ArrayList<List>();
        for (EObject eObject : collection) {
            allTreePaths.add(this.domain.getTreePath(eObject));
        }
        TreeIterator<Mapping> treeIterator = this.treeIterator();
        block1: while (treeIterator.hasNext()) {
            Mapping mapping = (Mapping)treeIterator.next();
            for (List treePath : allTreePaths) {
                Collection<? extends EObject> mappedObjects = mapping.getMappedObjects();
                mappedObjects.retainAll(treePath);
                if (!mappedObjects.isEmpty()) continue;
                treeIterator.prune();
                continue block1;
            }
            Collection<? extends EObject> mappedObjects = mapping.getMappedObjects();
            if (collection.containsAll(mappedObjects) && mappedObjects.containsAll(collection)) continue;
            result = mapping;
        }
        return result;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean isOutputDirty() {
        return this.outputDirty;
    }

    @Override
    public void register(Mapping mapping) {
        MappedObjectState mappedObjectState;
        for (Object input : mapping.getInputs()) {
            mappedObjectState = this.getMappedObjectState(input);
            if (mappedObjectState == null) continue;
            mappedObjectState.getMappings().add(mapping);
        }
        for (Object output : mapping.getOutputs()) {
            mappedObjectState = this.getMappedObjectState(output);
            if (mappedObjectState == null) continue;
            mappedObjectState.getMappings().add(mapping);
        }
    }

    @Override
    public void deregister(Mapping mapping) {
        MappedObjectState mappedObjectState;
        for (Object input : mapping.getInputs()) {
            mappedObjectState = this.getMappedObjectState(input);
            if (mappedObjectState == null) continue;
            mappedObjectState.getMappings().remove(mapping);
        }
        for (Object output : mapping.getOutputs()) {
            mappedObjectState = this.getMappedObjectState(output);
            if (mappedObjectState == null) continue;
            mappedObjectState.getMappings().remove(mapping);
        }
    }

    @Override
    public boolean canCreateMapping(Collection<?> inputs, Collection<?> outputs, Mapping mapping) {
        if (this.domain == null) {
            return false;
        }
        int enablementFlags = this.domain.getMappingEnablementFlags();
        if ((enablementFlags & 0x40) == 0 && inputs.size() == 0 || (enablementFlags & 0x80) == 0 && outputs.size() == 0 || inputs.size() == 0 && outputs.size() == 0 || (enablementFlags & 1) == 0 && inputs.size() > 1 || (enablementFlags & 2) == 0 && outputs.size() > 1 || (enablementFlags & 4) == 0 && this.isMapped(inputs, mapping) || (enablementFlags & 8) == 0 && this.isMapped(outputs, mapping) || (enablementFlags & 0x100) == 0 && !this.hasMappedParents(inputs, outputs) || (enablementFlags & 0x10) == 0 && !this.hasCompatibleMetaObjects(inputs, outputs) || (enablementFlags & 0x20) == 0 && !this.hasCompatibleTypes(inputs, outputs)) {
            return false;
        }
        for (Object input : inputs) {
            if (this.isAttachedObject(input)) continue;
            return false;
        }
        for (Object output : outputs) {
            if (this.isAttachedObject(output)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canRemoveMapping(Mapping mapping) {
        int enablementFlags = this.domain.getMappingEnablementFlags();
        return mapping.getNestedIn() != null && ((enablementFlags & 0x100) != 0 || !this.hasMappedChildren(mapping));
    }

    protected boolean hasMappedChildren(Mapping mapping) {
        return !mapping.getNested().isEmpty();
    }

    protected boolean hasMappedParents(Collection<?> inputs, Collection<?> outputs) {
        HashSet<Object> parents = new HashSet<Object>();
        for (Object input : inputs) {
            parents.add(this.domain.getParent(input));
        }
        for (Object output : outputs) {
            parents.add(this.domain.getParent(output));
        }
        return !this.getAllMappings(parents).isEmpty();
    }

    protected boolean isMapped(Collection<?> collection, Mapping mapping) {
        for (Object object : collection) {
            Collection<? extends Mapping> mappings = this.getMappings(object);
            if (mappings.isEmpty() || mapping != null && mappings.size() <= 1 && mappings.contains(mapping)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasCompatibleMetaObjects(Collection<?> inputs, Collection<?> outputs) {
        for (Object input : inputs) {
            EClass inputType = ((EObject)input).eClass();
            EObject convertedInputType = this.domain.getOutputMetaObject((EObject)inputType);
            for (Object output : outputs) {
                EClass outputType = ((EObject)output).eClass();
                if (convertedInputType == outputType) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean hasCompatibleTypes(Collection<?> inputs, Collection<?> outputs) {
        MappingRoot typeMappingRoot = this.getTypeMappingRoot();
        if (typeMappingRoot != null) {
            Collection<Object> outputTypes;
            Collection<Object> inputTypes = this.getTypeClassifiers(inputs);
            if (inputTypes.equals(outputTypes = this.getTypeClassifiers(outputs))) {
                return true;
            }
            if (inputTypes.size() != inputs.size() || outputTypes.size() != outputs.size()) {
                return false;
            }
            if (this.getTypeMappings(inputTypes, outputTypes).isEmpty() && this.hasTypeMappings(inputTypes) && this.hasTypeMappings(outputTypes)) {
                return false;
            }
        }
        return true;
    }

    protected Collection<?> getTypeMappings(Collection<?> inputTypes, Collection<?> outputTypes) {
        Collection<? extends Mapping> typeMappings;
        if (outputTypes.isEmpty()) {
            typeMappings = this.getTypeMappingRoot().getAllMappings(inputTypes);
        } else {
            ArrayList allTypes = new ArrayList(inputTypes);
            allTypes.addAll(outputTypes);
            typeMappings = this.getTypeMappingRoot().getExactMappings(allTypes);
        }
        return typeMappings;
    }

    protected boolean hasTypeMappings(Collection<?> types) {
        return !this.getTypeMappingRoot().getAllMappings(types).isEmpty();
    }

    protected Collection<Object> getTypeClassifiers(Collection<?> collection) {
        ArrayList<Object> types = new ArrayList<Object>();
        for (Object object : collection) {
            Object type = this.domain.getTypeClassifier(object);
            if (type == null) continue;
            types.add(type);
        }
        return types;
    }

    @Override
    public Mapping createMapping(Collection<?> inputs, Collection<?> outputs) {
        Mapping newMapping = this.createMapping();
        this.initializeNewMapping(newMapping, inputs, outputs);
        return newMapping;
    }

    protected Mapping createMapping() {
        return MappingFactory.eINSTANCE.createMapping();
    }

    protected void initializeNewMapping(Mapping newMapping, Collection<?> inputs, Collection<?> outputs) {
        Collection<Object> outputTypes;
        Collection<?> typeMappings;
        Collection<Object> inputTypes;
        Collection<?> eObjectInputs = inputs;
        Collection<?> eObjectOutputs = outputs;
        newMapping.getInputs().addAll(eObjectInputs);
        newMapping.getOutputs().addAll(eObjectOutputs);
        if (this.getTypeMappingRoot() != null && !(inputTypes = this.getTypeClassifiers(inputs)).isEmpty() && !(typeMappings = this.getTypeMappings(inputTypes, outputTypes = this.getTypeClassifiers(outputs))).isEmpty()) {
            newMapping.setTypeMapping((Mapping)typeMappings.iterator().next());
        }
    }

    @Override
    public void resetDirty() {
        this.setOutputDirty(false);
    }

    @Override
    public void setOutputDirty(boolean dirty) {
        this.outputDirty = dirty;
    }

    @Override
    public boolean isInputObject(Object object) {
        MappedObjectState mappedObjectState = (MappedObjectState)this.mappedObjectStateAdapterFactory.adapt(object, MappedObjectState.class);
        return mappedObjectState != null && mappedObjectState.isInput();
    }

    @Override
    public boolean isOutputObject(Object object) {
        MappedObjectState mappedObjectState = (MappedObjectState)this.mappedObjectStateAdapterFactory.adapt(object, MappedObjectState.class);
        return mappedObjectState != null && mappedObjectState.isOutput();
    }

    @Override
    public boolean isTopObject(Object object) {
        MappedObjectState mappedObjectState = (MappedObjectState)this.mappedObjectStateAdapterFactory.adapt(object, MappedObjectState.class);
        if (mappedObjectState != null) {
            return this.isTopToBottom() ? mappedObjectState.isInput() : mappedObjectState.isOutput();
        }
        return false;
    }

    @Override
    public boolean isBottomObject(Object object) {
        MappedObjectState mappedObjectState = (MappedObjectState)this.mappedObjectStateAdapterFactory.adapt(object, MappedObjectState.class);
        if (mappedObjectState != null) {
            return !this.isTopToBottom() ? mappedObjectState.isInput() : mappedObjectState.isOutput();
        }
        return false;
    }

    @Override
    public boolean isAttachedObject(Object object) {
        Object root = object;
        Object parent = this.domain.getParent(object);
        while (parent instanceof EObject) {
            root = parent;
            parent = this.domain.getParent(parent);
        }
        return this.getInputs().contains(root) || this.getOutputs().contains(root);
    }

    @Override
    public Collection<? extends Mapping> getMappings(Object object) {
        MappedObjectState mappedObjectState = this.getMappedObjectState(object);
        if (mappedObjectState == null) {
            return Collections.emptySet();
        }
        return mappedObjectState.getMappings();
    }

    @Override
    public Collection<? extends Mapping> getAllMappings(Collection<?> collection) {
        Iterator<?> objects = collection.iterator();
        if (objects.hasNext()) {
            ArrayList<? extends Mapping> result = new ArrayList<Mapping>(this.getMappings(objects.next()));
            while (objects.hasNext() && !result.isEmpty()) {
                result.retainAll(this.getMappings(objects.next()));
            }
            return result;
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<? extends Mapping> getExactMappings(Collection<?> collection) {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        for (Mapping mapping : this.getAllMappings(collection)) {
            if (!collection.containsAll(mapping.getMappedObjects())) continue;
            result.add(mapping);
        }
        return result;
    }

    @Override
    public MappedObjectState getMappedObjectState(Object object) {
        return (MappedObjectState)this.mappedObjectStateAdapterFactory.adapt(object, MappedObjectState.class);
    }

    @Override
    public MappingRoot getTypeMappingRoot() {
        return (MappingRoot)this.getTypeMapping();
    }

    protected AdapterFactory createMappedObjectStateAdapterFactory() {
        return new MappedObjectStateAdapterFactory();
    }

    protected Adapter createMappedObjectStateAdapter(Notifier target) {
        return new MappedObjectStateAdapter();
    }

    @Override
    public void dispose() {
        MappingRoot typeMappingRoot;
        if (this.mappedObjectStateAdapterFactory instanceof IDisposable) {
            ((IDisposable)this.mappedObjectStateAdapterFactory).dispose();
        }
        if ((typeMappingRoot = this.getTypeMappingRoot()) != null) {
            typeMappingRoot.dispose();
        }
    }

    protected void printAdapters() {
        this.walk(this);
        TreeIterator<Mapping> mappings = this.treeIterator();
        while (mappings.hasNext()) {
            for (EObject eObject : ((Mapping)mappings.next()).getMappedObjects()) {
                this.walk(eObject);
            }
        }
    }

    protected void walk(EObject object) {
        for (EObject child : object.eContents()) {
            EList adapters = child.eAdapters();
            if (adapters != null) {
                boolean once = false;
                for (Object adapter : adapters) {
                    if (adapter == null) continue;
                    if (!once) {
                        System.out.println("*** " + child);
                        once = true;
                    }
                    System.out.println("  * " + adapter);
                }
            }
            this.walk(child);
        }
    }

    protected class MappedObjectStateAdapter
    extends AdapterImpl
    implements MappedObjectState,
    IDisposable {
        protected boolean isInput;
        protected boolean isOutput;
        protected Object originatingInput;
        protected Collection<Mapping> mappings = new NotifyingListImpl<Mapping>(){
            private static final long serialVersionUID = 1L;

            public Object getNotifier() {
                return MappedObjectStateAdapter.this.getTarget();
            }

            protected boolean isNotificationRequired() {
                return true;
            }

            protected NotificationImpl createNotification(int eventType, Object oldObject, Object newObject, int index, boolean wasSet) {
                Object object = oldObject == null ? newObject : oldObject;
                ENotificationImpl notification = new ENotificationImpl((InternalEObject)MappedObjectStateAdapter.this.getTarget(), 1, -2, object, object, -1, wasSet);
                MappedObjectStateAdapter.this.fireNotifyChanged((Notification)notification);
                return notification;
            }

            protected boolean isUnique() {
                return true;
            }
        };
        protected ChangeNotifier changeNotifier = new ChangeNotifier();

        protected MappedObjectStateAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == MappingRootImpl.this.mappedObjectStateAdapterFactory;
        }

        @Override
        public boolean isInput() {
            return this.isInput;
        }

        @Override
        public void setInput() {
            this.isInput = true;
        }

        @Override
        public boolean isOutput() {
            return this.isOutput;
        }

        @Override
        public void setOutput() {
            this.isOutput = true;
            ENotificationImpl note = new ENotificationImpl((InternalEObject)this.getTarget(), 1, -3, (Object)Boolean.TRUE, (Object)Boolean.TRUE, -1);
            this.changeNotifier.fireNotifyChanged((Notification)note);
        }

        @Override
        public Object getOriginatingInput() {
            return this.originatingInput;
        }

        @Override
        public void setOriginatingInput(Object originatingInput) {
            this.setOutput();
            this.originatingInput = originatingInput;
        }

        @Override
        public Collection<Mapping> getMappings() {
            return this.mappings;
        }

        public void addListener(INotifyChangedListener notifyChangedListener) {
            this.changeNotifier.addListener(notifyChangedListener);
        }

        public void removeListener(INotifyChangedListener notifyChangedListener) {
            this.changeNotifier.removeListener(notifyChangedListener);
        }

        public void fireNotifyChanged(Notification notification) {
            this.changeNotifier.fireNotifyChanged(notification);
        }

        public void dispose() {
            if (this.target != null) {
                this.target.eAdapters().remove((Object)this);
            }
        }
    }

    protected class MappedObjectStateAdapterFactory
    extends AdapterFactoryImpl
    implements IDisposable {
        protected Disposable disposable = new Disposable();

        public Adapter createAdapter(Notifier target) {
            return MappingRootImpl.this.createMappedObjectStateAdapter(target);
        }

        public boolean isFactoryForType(Object type) {
            return super.isFactoryForType(type) || type == MappedObjectState.class;
        }

        public Adapter adapt(Notifier notifier, Object type) {
            return super.adapt(notifier, (Object)this);
        }

        public Object adapt(Object object, Object type) {
            Object result = super.adapt(object, type);
            return result instanceof MappedObjectState ? result : null;
        }

        public Adapter adaptNew(Notifier object, Object type) {
            Adapter result = super.adaptNew(object, type);
            this.disposable.add((Object)result);
            return result;
        }

        public void dispose() {
            this.disposable.dispose();
        }
    }
}

