/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.db.evolution.phased;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.evolution.phased.BasicPhaseHandler;
import org.eclipse.emf.cdo.server.db.evolution.phased.Context;
import org.eclipse.emf.cdo.server.db.evolution.phased.ISchemaMigration;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.DBStoreTables;
import org.eclipse.emf.cdo.server.internal.db.MetaDataManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.factory.AnnotationFactory;

public class DefaultSchemaMigrator
extends BasicPhaseHandler {
    public static final String FACTORY_TYPE = "default-schema-migrator";
    private boolean deleteObsoleteMetaIDs;

    public boolean isDeleteObsoleteMetaIDs() {
        return this.deleteObsoleteMetaIDs;
    }

    @AnnotationFactory.InjectAttribute(name="deleteObsoleteMetaIDs")
    public void setDeleteObsoleteMetaIDs(boolean deleteObsoleteMetaIDs) {
        this.checkInactive();
        this.deleteObsoleteMetaIDs = deleteObsoleteMetaIDs;
    }

    @Override
    public void execute(Context context) throws Exception {
        IDBStore store = context.getSupport().getStore();
        ISchemaMigration schemaMigration = (ISchemaMigration)ObjectUtil.tryCast((Object)store.getMappingStrategy(), ISchemaMigration.class, () -> new ISchemaMigration.SchemaMigrationNotSupportedException());
        IDBStoreAccessor accessor = store.getWriter(null);
        StoreThreadLocal.setAccessor((IStoreAccessor)accessor);
        try {
            this.migrateSchema(context, accessor, schemaMigration);
            this.updateSystemTables(context, accessor);
            context.log("Schema migration completed with " + context.getTotalUpdateCount() + " row updates");
            this.commitChanges(context, accessor);
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    protected void migrateSchema(Context context, IDBStoreAccessor accessor, ISchemaMigration schemaMigration) throws SQLException {
        context.log("Migrating schema with mapping strategy " + ReflectUtil.getSimpleClassName((Object)schemaMigration));
        schemaMigration.migrateSchema(context, accessor);
    }

    protected void updateSystemTables(Context context, IDBStoreAccessor accessor) throws SQLException {
        context.log("Updating system tables with changed models");
        IDBConnection connection = accessor.getDBConnection();
        DBStore store = (DBStore)accessor.getStore();
        MetaDataManager metaDataManager = (MetaDataManager)store.getMetaDataManager();
        DBStoreTables.PackageUnitsTable packageUnits = store.tables().packageUnits();
        DBStoreTables.PackageInfosTable packageInfos = store.tables().packageInfos();
        InternalCDOPackageRegistry packageRegistry = context.getSupport().getNewPackageRegistry();
        Throwable throwable = null;
        Object var10_11 = null;
        try (Statement statement = connection.createStatement();){
            for (Context.Model model : context.getChangeInfos().keySet()) {
                String unitID = model.getID();
                context.log("Deleting old package unit " + unitID);
                int count1 = statement.executeUpdate("DELETE from " + (Object)((Object)packageUnits) + " WHERE " + packageUnits.id() + "='" + unitID + "'");
                context.incrementTotalUpdateCount(count1);
                context.log("Deleting old package infos for " + unitID);
                int count2 = statement.executeUpdate("DELETE from " + (Object)((Object)packageInfos) + " WHERE " + packageInfos.unit() + "='" + unitID + "'");
                context.incrementTotalUpdateCount(count2);
                EPackage newPackage = model.getNewPackage();
                byte[] packageBytes = EMFUtil.getEPackageBytes((EPackage)newPackage, (boolean)metaDataManager.isZipPackageBytes(), (EPackage.Registry)packageRegistry);
                context.log("Writing new package unit " + unitID);
                metaDataManager.writePackageUnit(connection, unitID, model.getOriginalType().ordinal(), context.getTimeStamp(), packageBytes, null);
                context.incrementTotalUpdateCount();
                EPackage[] ePackageArray = EMFUtil.getAllPackages((EPackage)newPackage);
                int n = ePackageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EPackage ePackage = ePackageArray[n2];
                    context.log("Writing new package info for " + ePackage.getNsURI());
                    metaDataManager.writePackageInfo(connection, ePackage.getNsURI(), EMFUtil.getParentURI((EPackage)ePackage), unitID, null);
                    context.incrementTotalUpdateCount();
                    ++n2;
                }
            }
            if (this.deleteObsoleteMetaIDs) {
                EMFUtil.TreeMapping<EObject> elementMappings = context.getElementMappings();
                Set newURIs = elementMappings.getToObjectsByURI().keySet();
                elementMappings.getFromObjectsByURI().forEach((oldURI, oldModelElement) -> {
                    if (oldModelElement instanceof EModelElement && !newURIs.contains(oldURI)) {
                        context.log("Deleting obsolete meta ID mapping for " + oldURI);
                        metaDataManager.deleteMetaIDMapping(statement, (EModelElement)oldModelElement);
                        context.incrementTotalUpdateCount();
                    }
                });
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected boolean commitChanges(Context context, IDBStoreAccessor accessor) throws SQLException {
        context.log("Committing model evolution changes to the database");
        accessor.getConnection().commit();
        return false;
    }
}

