/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import org.eclipse.net4j.buffer.BufferInputStream;
import org.eclipse.net4j.buffer.BufferOutputStream;
import org.eclipse.net4j.signal.RemoteExceptionRequest;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public abstract class IndicationWithResponse
extends SignalReactor {
    public IndicationWithResponse(SignalProtocol<?> protocol, short id, String name) {
        super(protocol, id, name);
    }

    public IndicationWithResponse(SignalProtocol<?> protocol, short signalID) {
        super(protocol, signalID);
    }

    public IndicationWithResponse(SignalProtocol<?> protocol, Enum<?> literal) {
        super(protocol, literal);
    }

    protected boolean closeChannelAfterException() {
        return false;
    }

    protected String getExceptionMessage(Throwable t) {
        return t.getLocalizedMessage();
    }

    @Override
    protected void execute(BufferInputStream in, BufferOutputStream out) throws Exception {
        boolean responding = false;
        try {
            this.doInput(in);
            responding = true;
            this.doOutput(out);
        }
        catch (Error | Exception ex) {
            this.sendExceptionSignal(ex, responding);
            throw ex;
        }
    }

    protected abstract void indicating(ExtendedDataInputStream var1) throws Exception;

    protected abstract void responding(ExtendedDataOutputStream var1) throws Exception;

    @Override
    void doExtendedInput(ExtendedDataInputStream in) throws Exception {
        this.indicating(in);
    }

    @Override
    void doExtendedOutput(ExtendedDataOutputStream out) throws Exception {
        this.responding(out);
    }

    void sendExceptionSignal(Throwable t, boolean responding) throws Exception {
        SignalProtocol<?> protocol = this.getProtocol();
        int correlationID = -this.getCorrelationID();
        String message = this.getExceptionMessage(t);
        final boolean closeChannel = this.closeChannelAfterException();
        RemoteExceptionRequest request = new RemoteExceptionRequest(protocol, correlationID, responding, message, t){

            @Override
            protected boolean closeChannelAfterMe() {
                return closeChannel;
            }
        };
        request.sendAsync();
    }
}

