/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.requests.DuplicateRequest;
import org.eclipse.gmf.runtime.emf.commands.core.commands.DuplicateEObjectsCommand;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

public class DuplicateViewsCommand
extends DuplicateEObjectsCommand {
    Map duplicatedElements;
    List duplicatedViewsToBeReturned = new ArrayList();
    private Point offset = new Point(0, 0);

    public DuplicateViewsCommand(TransactionalEditingDomain editingDomain, String label, DuplicateRequest request, List viewsToDuplicate, Map duplicatedElements, Point offset) {
        super(editingDomain, label, viewsToDuplicate);
        this.duplicatedElements = duplicatedElements;
        this.duplicatedViewsToBeReturned = request.getDuplicatedViews();
        this.offset = offset;
    }

    public DuplicateViewsCommand(TransactionalEditingDomain editingDomain, String label, DuplicateRequest request, List viewsToDuplicate, Point offset) {
        this(editingDomain, label, request, viewsToDuplicate, null, offset);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result = super.doExecuteWithResult(progressMonitor, info);
        if (!result.getStatus().isOK()) {
            return result;
        }
        for (View originalView : this.getObjectsToBeDuplicated()) {
            View duplicateView = (View)this.getAllDuplicatedObjectsMap().get(originalView);
            this.assignSementicElementsDownViewTree(duplicateView);
            if (duplicateView instanceof Node) {
                LayoutConstraint layoutConstraint = ((Node)duplicateView).getLayoutConstraint();
                if (layoutConstraint instanceof Bounds) {
                    Bounds bounds = (Bounds)layoutConstraint;
                    int x = bounds.getX();
                    bounds.setX(x + this.offset.x);
                    int y = bounds.getY();
                    bounds.setY(y + this.offset.y);
                }
            } else if (duplicateView instanceof Edge) {
                boolean targetDuplicated;
                assert (originalView instanceof Edge);
                Edge duplicateEdge = (Edge)duplicateView;
                Edge originalEdge = (Edge)originalView;
                boolean sourceDuplicated = duplicateEdge.getSource() != null;
                boolean bl = targetDuplicated = duplicateEdge.getTarget() != null;
                if (!sourceDuplicated) {
                    duplicateEdge.setSource(originalEdge.getSource());
                }
                if (!targetDuplicated) {
                    duplicateEdge.setTarget(originalEdge.getTarget());
                }
            }
            if (duplicateView == null) continue;
            this.duplicatedViewsToBeReturned.add(duplicateView);
        }
        return CommandResult.newOKCommandResult((Object)this.duplicatedViewsToBeReturned);
    }

    private void assignSementicElementsDownViewTree(View view) {
        Object duplicateElement;
        EObject originalElement = view.getElement();
        if (originalElement != null && (duplicateElement = this.duplicatedElements.get(originalElement)) != null) {
            view.setElement((EObject)duplicateElement);
        }
        Iterator itr = view.getChildren().iterator();
        while (itr.hasNext()) {
            this.assignSementicElementsDownViewTree((View)itr.next());
        }
    }
}

