/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DoubleValuesSourceRescorer;
import org.apache.lucene.search.LateInteractionFloatValuesSource;

public class LateInteractionRescorer
extends DoubleValuesSourceRescorer {
    public LateInteractionRescorer(LateInteractionFloatValuesSource valuesSource) {
        super(valuesSource);
    }

    public static LateInteractionRescorer create(String fieldName, float[][] queryVector) {
        return LateInteractionRescorer.create(fieldName, queryVector, VectorSimilarityFunction.COSINE);
    }

    public static LateInteractionRescorer create(String fieldName, float[][] queryVector, VectorSimilarityFunction vectorSimilarityFunction) {
        LateInteractionFloatValuesSource valuesSource = new LateInteractionFloatValuesSource(fieldName, queryVector, vectorSimilarityFunction);
        return new LateInteractionRescorer(valuesSource);
    }

    @Override
    protected float combine(float firstPassScore, boolean valuePresent, double sourceValue) {
        return valuePresent ? (float)sourceValue : 0.0f;
    }

    public static LateInteractionRescorer withFallbackToFirstPassScore(String fieldName, float[][] queryVector, VectorSimilarityFunction vectorSimilarityFunction) {
        LateInteractionFloatValuesSource valuesSource = new LateInteractionFloatValuesSource(fieldName, queryVector, vectorSimilarityFunction);
        return new LateInteractionRescorer(valuesSource){

            @Override
            protected float combine(float firstPassScore, boolean valuePresent, double sourceValue) {
                return valuePresent ? (float)sourceValue : firstPassScore;
            }
        };
    }
}

