/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references.search;

import java.util.List;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.references.search.SearchNode;
import org.eclipse.lemminx.extensions.references.search.SearchNodeFactory;
import org.eclipse.lemminx.extensions.references.search.SearchQueryFactory;
import org.eclipse.lemminx.extensions.references.settings.XMLReferenceExpression;

public class SearchQuery {
    private final DOMNode node;
    private final List<XMLReferenceExpression> expressions;
    private final QueryDirection queryDirection;
    private boolean searchInAttribute;
    private boolean searchInText;
    private boolean matchNode;
    private boolean searchInIncludedFiles;
    private SearchNode searchNode;

    public SearchQuery(DOMNode node, int offset, List<XMLReferenceExpression> expressions, QueryDirection direction) {
        this(node, offset, null, expressions, direction);
    }

    public SearchQuery(SearchNode searchNode, List<XMLReferenceExpression> expressions, QueryDirection direction) {
        this(searchNode.getNode(), -1, searchNode, expressions, direction);
    }

    private SearchQuery(DOMNode node, int offset, SearchNode searchNode, List<XMLReferenceExpression> expressions, QueryDirection queryDirection) {
        this.node = node;
        this.expressions = expressions;
        this.queryDirection = queryDirection;
        this.searchInAttribute = false;
        this.searchInText = false;
        boolean hasMultiple = false;
        String prefix = null;
        SearchNode.Direction searchNodeDirection = this.getSearchNodeDirection(offset, queryDirection);
        for (XMLReferenceExpression expression : expressions) {
            SearchNode.Direction status;
            if (!this.searchInAttribute) {
                this.searchInAttribute = SearchQuery.isSearchInAttribute(expression, queryDirection);
            }
            if (!this.searchInText) {
                this.searchInText = SearchQuery.isSearchInText(expression, queryDirection);
            }
            if (!hasMultiple) {
                hasMultiple = expression.isMultiple();
            }
            if (prefix == null) {
                prefix = expression.getPrefix();
            }
            if (searchNodeDirection != null || (status = SearchQueryFactory.getInversedDirection(node, expression, queryDirection)) == null) continue;
            searchNodeDirection = status;
        }
        if (searchNode != null) {
            this.searchNode = searchNode;
        } else if (offset != -1) {
            this.searchNode = SearchNodeFactory.getSearchNodeAt(node, offset, prefix, hasMultiple, searchNodeDirection);
        }
    }

    private SearchNode.Direction getSearchNodeDirection(int offset, QueryDirection queryDirection) {
        switch (queryDirection) {
            case FROM_2_TO: {
                return SearchNode.Direction.FROM;
            }
            case TO_2_FROM: {
                return SearchNode.Direction.TO;
            }
        }
        if (offset != -1) {
            return null;
        }
        return null;
    }

    public DOMNode getNode() {
        return this.node;
    }

    public List<XMLReferenceExpression> getExpressions() {
        return this.expressions;
    }

    public boolean isMatchNode() {
        return this.matchNode;
    }

    public boolean isSearchInIncludedFiles() {
        return this.searchInIncludedFiles;
    }

    public void setSearchInIncludedFiles(boolean searchInIncludedFiles) {
        this.searchInIncludedFiles = searchInIncludedFiles;
    }

    public void setMatchNode(boolean matchNode) {
        this.matchNode = matchNode;
    }

    public boolean isSearchInAttribute() {
        return this.searchInAttribute;
    }

    public boolean isSearchInText() {
        return this.searchInText;
    }

    public SearchNode getSearchNode() {
        return this.searchNode;
    }

    public QueryDirection getQueryDirection() {
        return this.queryDirection;
    }

    private static boolean isSearchInAttribute(XMLReferenceExpression expression, QueryDirection direction) {
        switch (direction) {
            case FROM_2_TO: {
                return expression.isToSearchInAttribute();
            }
            case TO_2_FROM: {
                return expression.isFromSearchInAttribute();
            }
        }
        return expression.isToSearchInAttribute() || expression.isFromSearchInAttribute();
    }

    private static boolean isSearchInText(XMLReferenceExpression expression, QueryDirection direction) {
        switch (direction) {
            case FROM_2_TO: {
                return expression.isToSearchInText();
            }
            case TO_2_FROM: {
                return expression.isFromSearchInText();
            }
        }
        return expression.isToSearchInText() || expression.isFromSearchInText();
    }

    public static enum QueryDirection {
        FROM_2_TO,
        TO_2_FROM,
        BOTH;

    }
}

