/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtilsCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;

public class TypedSource {
    private final String fSource;
    private final int fType;

    private TypedSource(String source, int type) {
        Assert.isNotNull((Object)source);
        Assert.isTrue((boolean)TypedSource.canCreateForType(type));
        this.fSource = source;
        this.fType = type;
    }

    public static TypedSource create(String source, int type) {
        if (source == null || !TypedSource.canCreateForType(type)) {
            return null;
        }
        return new TypedSource(source, type);
    }

    public String getSource() {
        return this.fSource;
    }

    public int getType() {
        return this.fType;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TypedSource)) {
            return false;
        }
        TypedSource ts = (TypedSource)other;
        return ts.getSource().equals(this.getSource()) && ts.getType() == this.getType();
    }

    public int hashCode() {
        return this.getSource().hashCode() ^ 97 * this.getType();
    }

    private static boolean canCreateForType(int type) {
        return type == 8 || type == 7 || type == 12 || type == 13 || type == 10 || type == 9 || type == 11 || type == 17;
    }

    public static void sortByType(TypedSource[] typedSources) {
        Arrays.sort(typedSources, TypedSource.createTypeComparator());
    }

    public static Comparator<TypedSource> createTypeComparator() {
        return (arg0, arg1) -> arg0.getType() - arg1.getType();
    }

    public static TypedSource[] createTypedSources(IJavaElement[] javaElements) throws CoreException {
        Map<ICompilationUnit, List<IJavaElement>> grouped = ReorgUtilsCore.groupByCompilationUnit(Arrays.asList(javaElements));
        ArrayList<TypedSource> result = new ArrayList<TypedSource>(javaElements.length);
        for (Map.Entry<ICompilationUnit, List<IJavaElement>> entry : grouped.entrySet()) {
            ICompilationUnit cu = entry.getKey();
            for (IJavaElement javaElement : entry.getValue()) {
                SourceTuple tuple;
                TypedSource[] ts = TypedSource.createTypedSources(javaElement, tuple = new SourceTuple(cu));
                if (ts == null) continue;
                result.addAll(Arrays.asList(ts));
            }
        }
        return result.toArray(new TypedSource[result.size()]);
    }

    private static TypedSource[] createTypedSources(IJavaElement elem, SourceTuple tuple) throws CoreException {
        if (!ReorgUtilsCore.isInsideCompilationUnit(elem)) {
            return null;
        }
        if (elem.getElementType() == 12) {
            return TypedSource.createTypedSourcesForImportContainer(tuple, (IImportContainer)elem);
        }
        if (elem.getElementType() == 8) {
            return new TypedSource[]{TypedSource.create(TypedSource.getFieldSource((IField)elem, tuple), elem.getElementType())};
        }
        return new TypedSource[]{TypedSource.create(TypedSource.getSourceOfDeclararationNode(elem, tuple.unit), elem.getElementType())};
    }

    private static TypedSource[] createTypedSourcesForImportContainer(SourceTuple tuple, IImportContainer container) throws JavaModelException, CoreException {
        IJavaElement[] imports = container.getChildren();
        ArrayList<TypedSource> result = new ArrayList<TypedSource>(imports.length);
        IJavaElement[] iJavaElementArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement importedElement = iJavaElementArray[n2];
            result.addAll(Arrays.asList(TypedSource.createTypedSources(importedElement, tuple)));
            ++n2;
        }
        return result.toArray(new TypedSource[result.size()]);
    }

    private static String getFieldSource(IField field, SourceTuple tuple) throws CoreException {
        if (Flags.isEnum((int)field.getFlags())) {
            String source = field.getSource();
            if (source != null) {
                return source;
            }
        } else {
            FieldDeclaration declaration;
            if (tuple.node == null) {
                ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
                parser.setSource(tuple.unit);
                tuple.node = (CompilationUnit)parser.createAST(null);
            }
            if ((declaration = ASTNodeSearchUtil.getFieldDeclarationNode(field, tuple.node)).fragments().size() == 1) {
                return TypedSource.getSourceOfDeclararationNode((IJavaElement)field, tuple.unit);
            }
            VariableDeclarationFragment declarationFragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(field, tuple.node);
            IBuffer buffer = tuple.unit.getBuffer();
            StringBuilder buff = new StringBuilder();
            buff.append(buffer.getText(declaration.getStartPosition(), ((ASTNode)declaration.fragments().get(0)).getStartPosition() - declaration.getStartPosition()));
            buff.append(buffer.getText(declarationFragment.getStartPosition(), declarationFragment.getLength()));
            buff.append(";");
            return buff.toString();
        }
        return "";
    }

    private static String getSourceOfDeclararationNode(IJavaElement elem, ICompilationUnit cu) throws JavaModelException, CoreException {
        ISourceReference reference;
        String source;
        Assert.isTrue((elem.getElementType() != 12 ? 1 : 0) != 0);
        if (elem instanceof ISourceReference && (source = (reference = (ISourceReference)elem).getSource()) != null) {
            return Strings.trimIndentation(source, cu, false);
        }
        return "";
    }

    private static class SourceTuple {
        private ICompilationUnit unit;
        private CompilationUnit node;

        private SourceTuple(ICompilationUnit unit) {
            this.unit = unit;
        }
    }
}

