/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bnd;

import aQute.bnd.osgi.Jar;
import aQute.bnd.service.RepositoryListenerPlugin;
import aQute.bnd.service.RepositoryPlugin;
import java.io.File;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class DelegateRepositoryListener
implements RepositoryListenerPlugin {
    private final Supplier<Stream<RepositoryListenerPlugin>> delegateSupplier;

    public DelegateRepositoryListener(Supplier<Stream<RepositoryListenerPlugin>> delegateSupplier) {
        this.delegateSupplier = delegateSupplier;
    }

    public void bundleAdded(RepositoryPlugin repository, Jar jar, File file) {
        this.delegateSupplier.get().forEach(listener -> listener.bundleAdded(repository, jar, file));
    }

    public void bundleRemoved(RepositoryPlugin repository, Jar jar, File file) {
        this.delegateSupplier.get().forEach(listener -> listener.bundleRemoved(repository, jar, file));
    }

    public void repositoryRefreshed(RepositoryPlugin repository) {
        this.delegateSupplier.get().forEach(listener -> listener.repositoryRefreshed(repository));
    }

    public void repositoriesRefreshed() {
        this.delegateSupplier.get().forEach(listener -> listener.repositoriesRefreshed());
    }
}

