/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.presentation;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.mapping.MappingFactory;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class MappingUIPlugin
extends AbstractUIPlugin {
    protected static MappingUIPlugin instance;

    public static MappingUIPlugin getPlugin() {
        return instance;
    }

    public MappingUIPlugin() {
        instance = this;
    }

    MappingRoot createInitialModel() {
        MappingRoot mappingRoot = MappingFactory.eINSTANCE.createMappingRoot();
        return mappingRoot;
    }

    public String getString(String key) {
        return Platform.getResourceBundle((Bundle)this.getBundle()).getString(key);
    }

    public String getString(String key, Object s1) {
        return MessageFormat.format(this.getString(key), s1);
    }

    public String getString(String key, Object s1, Object s2) {
        return MessageFormat.format(this.getString(key), s1, s2);
    }

    public ImageDescriptor getImageDescriptor(String key) {
        try {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(this.getBundle().getEntry("/"), "icons/" + key + ".gif"));
            return imageDescriptor;
        }
        catch (MalformedURLException exception) {
            System.out.println("Failed to load image for '" + key + "'");
            exception.printStackTrace();
            return null;
        }
    }

    public Image getImage(String key) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            imageRegistry.put(key, this.getImageDescriptor(key));
            image = imageRegistry.get(key);
        }
        return image;
    }
}

