/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.IDetailPane3;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.breakpoints.AbstractJavaBreakpointEditor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.EditorActionBarContributor;

public abstract class AbstractDetailPane
implements IDetailPane3 {
    private final String fName;
    private final String fDescription;
    private final String fId;
    private AbstractJavaBreakpointEditor fEditor;
    private final Set<Integer> fAutoSaveProperties = new HashSet<Integer>();
    private IWorkbenchPartSite fSite;
    private final ListenerList<IPropertyListener> fListeners = new ListenerList();
    private Composite fEditorParent;

    public AbstractDetailPane(String name, String description, String id) {
        this.fName = name;
        this.fDescription = description;
        this.fId = id;
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public ISelectionProvider getSelectionProvider() {
        return null;
    }

    protected void firePropertyChange(int property) {
        for (IPropertyListener listener : this.fListeners) {
            listener.propertyChanged((Object)this, property);
        }
    }

    public void init(IWorkbenchPartSite partSite) {
        this.fSite = partSite;
    }

    public String getID() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public void dispose() {
        this.fEditor = null;
        this.fSite = null;
        this.fListeners.clear();
        this.fAutoSaveProperties.clear();
        this.fEditorParent.dispose();
    }

    protected void addAutosaveProperties(int[] autosave) {
        int[] nArray = autosave;
        int n = autosave.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            this.fAutoSaveProperties.add(element);
            ++n2;
        }
    }

    public Control createControl(Composite parent) {
        this.fEditorParent = SWTFactory.createComposite((Composite)parent, (int)1, (int)1, (int)1808);
        this.fEditorParent.setBackground(parent.getDisplay().getSystemColor(25));
        this.fEditor = this.createEditor(this.fEditorParent);
        this.fEditor.setMnemonics(false);
        this.fEditor.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (AbstractDetailPane.this.fAutoSaveProperties.contains(propId)) {
                    try {
                        AbstractDetailPane.this.fEditor.doSave();
                        return;
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                AbstractDetailPane.this.firePropertyChange(257);
            }
        });
        return this.fEditor.createControl(this.fEditorParent);
    }

    protected abstract AbstractJavaBreakpointEditor createEditor(Composite var1);

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty() && this.fEditor.getStatus().isOK();
    }

    public boolean setFocus() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        IStatusLineManager statusLine = this.getStatusLine();
        if (statusLine != null) {
            statusLine.setErrorMessage(null);
        }
        try {
            this.fEditor.doSave();
        }
        catch (CoreException e) {
            if (statusLine != null) {
                statusLine.setErrorMessage(e.getMessage());
            }
            JDIDebugUIPlugin.log(e.getStatus());
        }
    }

    private IStatusLineManager getStatusLine() {
        if (this.fSite instanceof IViewSite) {
            IEditorPart activeEditorPart;
            IEditorActionBarContributor contributor;
            IViewSite site = (IViewSite)this.fSite;
            IWorkbenchPage page = site.getPage();
            IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof IViewPart) {
                IViewPart activeViewPart = (IViewPart)activePart;
                IViewSite activeViewSite = activeViewPart.getViewSite();
                return activeViewSite.getActionBars().getStatusLineManager();
            }
            if (activePart instanceof IEditorPart && (contributor = (activeEditorPart = (IEditorPart)activePart).getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
                return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
            }
            return site.getActionBars().getStatusLineManager();
        }
        return null;
    }

    public boolean isDirty() {
        return this.fEditor != null && this.fEditor.isDirty();
    }

    protected AbstractJavaBreakpointEditor getEditor() {
        return this.fEditor;
    }

    public void display(IStructuredSelection selection) {
        IStatusLineManager statusLine = this.getStatusLine();
        if (statusLine != null) {
            statusLine.setErrorMessage(null);
        }
        AbstractJavaBreakpointEditor editor = this.getEditor();
        Object input = null;
        if (selection != null && selection.size() == 1) {
            input = selection.getFirstElement();
        }
        try {
            editor.setInput(input);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }
}

