/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.json.internal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.FrameworkUtil;

public class Util {
    public static String getValueOrDefault(JsonObject jsonObject, String element, String defaultValue) {
        if (jsonObject.has(element)) {
            return jsonObject.get(element).getAsString();
        }
        return defaultValue;
    }

    public static int getValueOrDefault(JsonObject jsonObject, String element, int defaultValue) {
        if (jsonObject.has(element)) {
            return jsonObject.get(element).getAsInt();
        }
        return defaultValue;
    }

    public static double getValueOrDefault(JsonObject jsonObject, String element, double defaultValue) {
        if (jsonObject.has(element)) {
            return jsonObject.get(element).getAsDouble();
        }
        return defaultValue;
    }

    public static String replace(JsonObject object, String input) {
        String result = Util.doReplace(object, input);
        JsonObject vars = object.getAsJsonObject("variables");
        if (vars != null) {
            result = Util.replace(vars, result);
        }
        return result;
    }

    private static String doReplace(JsonObject object, String input) {
        Object result = input;
        for (Map.Entry entry : object.entrySet()) {
            JsonElement jsonElement = (JsonElement)entry.getValue();
            if (!jsonElement.isJsonPrimitive()) continue;
            String search = "${" + (String)entry.getKey() + "}";
            String replace = jsonElement.getAsString();
            int index = ((String)result).indexOf(search);
            while (index > -1) {
                result = ((String)result).substring(0, index) + replace + ((String)result).substring(index + search.length());
                index = ((String)result).indexOf(search);
            }
        }
        return result;
    }

    public static IStatus isValidUrl(String pUrl) {
        String symbolicName = FrameworkUtil.getBundle(Util.class).getSymbolicName();
        try {
            URL url = new URL(pUrl);
            HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
            int responseCode = httpCon.getResponseCode();
            if (responseCode != 200) {
                return new Status(4, symbolicName, MessageFormat.format("Received response code {0} from {1}.", "" + responseCode, pUrl));
            }
            if (httpCon.getContentLength() <= 0) {
                return new Status(4, symbolicName, MessageFormat.format("Received empty file from {0}.", pUrl));
            }
        }
        catch (Exception e) {
            return new Status(4, symbolicName, MessageFormat.format("Received empty file from {0}.", pUrl), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

