/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.SimpleScorable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.PriorityQueue;

final class DisjunctionMaxBulkScorer
extends BulkScorer {
    private static final int WINDOW_SIZE = 4096;
    private final FixedBitSet windowMatches = new FixedBitSet(4097);
    private final float[] windowScores = new float[4096];
    private final PriorityQueue<BulkScorerAndNext> scorers;
    private final SimpleScorable topLevelScorable = new SimpleScorable();

    DisjunctionMaxBulkScorer(List<BulkScorer> scorers) {
        if (scorers.size() < 2) {
            throw new IllegalArgumentException();
        }
        this.scorers = new PriorityQueue<BulkScorerAndNext>(this, scorers.size()){

            @Override
            protected boolean lessThan(BulkScorerAndNext a, BulkScorerAndNext b) {
                return a.next < b.next;
            }
        };
        for (BulkScorer scorer : scorers) {
            this.scorers.add(new BulkScorerAndNext(scorer));
        }
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        BulkScorerAndNext top = this.scorers.top();
        while (top.next < max) {
            final int windowMin = Math.max(top.next, min);
            int windowMax = MathUtil.unsignedMin(max, windowMin + 4096);
            do {
                top.next = top.scorer.score(new LeafCollector(){
                    private Scorable scorer;

                    @Override
                    public void setScorer(Scorable scorer) throws IOException {
                        this.scorer = scorer;
                        if (DisjunctionMaxBulkScorer.this.topLevelScorable.minCompetitiveScore != 0.0f) {
                            scorer.setMinCompetitiveScore(DisjunctionMaxBulkScorer.this.topLevelScorable.minCompetitiveScore);
                        }
                    }

                    @Override
                    public void collect(int doc) throws IOException {
                        int delta = doc - windowMin;
                        DisjunctionMaxBulkScorer.this.windowMatches.set(doc - windowMin);
                        DisjunctionMaxBulkScorer.this.windowScores[delta] = Math.max(DisjunctionMaxBulkScorer.this.windowScores[delta], this.scorer.score());
                    }
                }, acceptDocs, windowMin, windowMax);
                top = this.scorers.updateTop();
            } while (top.next < windowMax);
            collector.setScorer(this.topLevelScorable);
            int windowDoc = this.windowMatches.nextSetBit(0);
            while (windowDoc != Integer.MAX_VALUE) {
                int doc = windowMin + windowDoc;
                this.topLevelScorable.score = this.windowScores[windowDoc];
                collector.collect(doc);
                windowDoc = this.windowMatches.nextSetBit(windowDoc + 1);
            }
            this.windowMatches.clear();
            Arrays.fill(this.windowScores, 0.0f);
        }
        return top.next;
    }

    @Override
    public long cost() {
        long cost = 0L;
        for (BulkScorerAndNext scorer : this.scorers) {
            cost += scorer.scorer.cost();
        }
        return cost;
    }

    private static class BulkScorerAndNext {
        public final BulkScorer scorer;
        public int next = 0;

        BulkScorerAndNext(BulkScorer scorer) {
            this.scorer = Objects.requireNonNull(scorer);
        }
    }
}

