/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.manifest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.manifest.AggregateDefinition;
import org.eclipse.datatools.connectivity.oda.spec.manifest.CombinedExpressionOperatorDefinition;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ExtensionContributor;
import org.eclipse.datatools.connectivity.oda.spec.manifest.FilterExpressionDefinition;
import org.eclipse.datatools.connectivity.oda.spec.manifest.FunctionExpressionDefinition;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ResultExtensionUtil;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestUtil;

public class ResultExtensionExplorer {
    public static final String DTP_ODA_DYNAMIC_RESULT_SETS_EXT_POINT = "org.eclipse.datatools.connectivity.oda.dynamicResultSet";
    public static final String FILTER_GROUP_NAME = "filterExpressionTypes";
    public static final String AGGREGATE_GROUP_NAME = "aggregateExpressionTypes";
    public static final String VALUE_EXPR_GROUP_NAME = "valueExpressionTypes";
    private static final String COMBINED_OPERATOR_SUBGROUP_NAME = "combinedOperatorTypes";
    private static ResultExtensionExplorer sm_instance = null;
    private static Logger sm_logger = null;
    private static final ExtensionContributor[] EMTPY_CONTRIBUTOR_ARRAY = new ExtensionContributor[0];
    private static final FilterExpressionDefinition[] EMPTY_FILTER_EXPRS_ARRAY = new FilterExpressionDefinition[0];
    private static final AggregateDefinition[] EMPTY_AGGR_EXPRS_ARRAY = new AggregateDefinition[0];
    private static final CombinedExpressionOperatorDefinition[] EMPTY_COMBINED_OP_ARRAY = new CombinedExpressionOperatorDefinition[0];
    private static final FunctionExpressionDefinition[] EMPTY_FUNC_TYPES_ARRAY = new FunctionExpressionDefinition[0];
    private Map<ExtensionContributor, Map<String, FilterExpressionDefinition>> m_filterTypesByExtn;
    private Map<ExtensionContributor, Map<String, AggregateDefinition>> m_aggregateTypesByExtn;
    private Map<String, Map<String, CombinedExpressionOperatorDefinition>> m_combinedOpTypesByExtnId;
    private Map<String, Map<String, FunctionExpressionDefinition>> m_functionTypesByExtnId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResultExtensionExplorer getInstance() {
        if (sm_instance != null) return sm_instance;
        Class<ResultExtensionExplorer> clazz = ResultExtensionExplorer.class;
        synchronized (ResultExtensionExplorer.class) {
            if (sm_instance != null) return sm_instance;
            sm_instance = new ResultExtensionExplorer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseInstance() {
        Class<ResultExtensionExplorer> clazz = ResultExtensionExplorer.class;
        synchronized (ResultExtensionExplorer.class) {
            sm_instance = null;
            sm_logger = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Logger getLogger() {
        if (sm_logger != null) return sm_logger;
        Class<ResultExtensionExplorer> clazz = ResultExtensionExplorer.class;
        synchronized (ResultExtensionExplorer.class) {
            if (sm_logger != null) return sm_logger;
            sm_logger = Logger.getLogger(ResultExtensionExplorer.class.getPackage().getName());
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_logger;
        }
    }

    private ResultExtensionExplorer() {
        this.addAllExtensions();
    }

    public void refresh() {
        this.addAllExtensions();
    }

    private void resetCache() {
        if (this.m_filterTypesByExtn != null) {
            this.m_filterTypesByExtn.clear();
        }
        if (this.m_aggregateTypesByExtn != null) {
            this.m_aggregateTypesByExtn.clear();
        }
        if (this.m_combinedOpTypesByExtnId != null) {
            this.m_combinedOpTypesByExtnId.clear();
        }
        if (this.m_functionTypesByExtnId != null) {
            this.m_functionTypesByExtnId.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ExtensionContributor, Map<String, FilterExpressionDefinition>> getCachedFilterExtensions() {
        if (this.m_filterTypesByExtn == null) {
            ResultExtensionExplorer resultExtensionExplorer = this;
            synchronized (resultExtensionExplorer) {
                if (this.m_filterTypesByExtn == null) {
                    this.m_filterTypesByExtn = new HashMap<ExtensionContributor, Map<String, FilterExpressionDefinition>>(4);
                }
            }
        }
        return this.m_filterTypesByExtn;
    }

    private Map<String, FilterExpressionDefinition> getCachedFilterDefinitionsByExtension(String extensionId) {
        ExtensionContributor contributor = this.findCachedContributorOfFilterExtension(extensionId);
        if (contributor != null) {
            return this.getCachedFilterExtensions().get(contributor);
        }
        return null;
    }

    private ExtensionContributor findCachedContributorOfFilterExtension(String extensionId) {
        if (this.getCachedFilterExtensions().isEmpty()) {
            return null;
        }
        for (ExtensionContributor aContributor : this.getCachedFilterExtensions().keySet()) {
            if (!aContributor.getDeclaringExtensionId().equals(extensionId)) continue;
            return aContributor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ExtensionContributor, Map<String, AggregateDefinition>> getCachedAggregateExtensions() {
        if (this.m_aggregateTypesByExtn == null) {
            ResultExtensionExplorer resultExtensionExplorer = this;
            synchronized (resultExtensionExplorer) {
                if (this.m_aggregateTypesByExtn == null) {
                    this.m_aggregateTypesByExtn = new HashMap<ExtensionContributor, Map<String, AggregateDefinition>>(4);
                }
            }
        }
        return this.m_aggregateTypesByExtn;
    }

    private Map<String, AggregateDefinition> getCachedAggregateDefinitionsByExtension(String extensionId) {
        ExtensionContributor contributor = this.findCachedContributorOfAggregateExtension(extensionId);
        if (contributor != null) {
            return this.getCachedAggregateExtensions().get(contributor);
        }
        return null;
    }

    private ExtensionContributor findCachedContributorOfAggregateExtension(String extensionId) {
        if (this.getCachedAggregateExtensions().isEmpty()) {
            return null;
        }
        for (ExtensionContributor aContributor : this.getCachedAggregateExtensions().keySet()) {
            if (!aContributor.getDeclaringExtensionId().equals(extensionId)) continue;
            return aContributor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, CombinedExpressionOperatorDefinition>> getCachedCombinedOperatorExtensions() {
        if (this.m_combinedOpTypesByExtnId == null) {
            ResultExtensionExplorer resultExtensionExplorer = this;
            synchronized (resultExtensionExplorer) {
                if (this.m_combinedOpTypesByExtnId == null) {
                    this.m_combinedOpTypesByExtnId = new HashMap<String, Map<String, CombinedExpressionOperatorDefinition>>(4);
                }
            }
        }
        return this.m_combinedOpTypesByExtnId;
    }

    private Map<String, CombinedExpressionOperatorDefinition> getCachedCombinedOpDefinitionsByExtension(String extensionId) {
        return this.getCachedCombinedOperatorExtensions().get(extensionId);
    }

    private Map<String, FunctionExpressionDefinition> getCachedFunctionDefinitionsByExtension(String extensionId) {
        return this.getCachedFunctionExtensions().get(extensionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, FunctionExpressionDefinition>> getCachedFunctionExtensions() {
        if (this.m_functionTypesByExtnId == null) {
            ResultExtensionExplorer resultExtensionExplorer = this;
            synchronized (resultExtensionExplorer) {
                if (this.m_functionTypesByExtnId == null) {
                    this.m_functionTypesByExtnId = new HashMap<String, Map<String, FunctionExpressionDefinition>>(4);
                }
            }
        }
        return this.m_functionTypesByExtnId;
    }

    private static FilterExpressionDefinition[] convertFilterDefnValuesToSortByNameArray(Map<String, FilterExpressionDefinition> exprDefns) {
        if (exprDefns == null) {
            return EMPTY_FILTER_EXPRS_ARRAY;
        }
        TreeMap<String, FilterExpressionDefinition> sortedDefnsByName = new TreeMap<String, FilterExpressionDefinition>();
        for (FilterExpressionDefinition exprDefn : exprDefns.values()) {
            sortedDefnsByName.put(exprDefn.getDisplayName(), exprDefn);
        }
        return sortedDefnsByName.values().toArray(new FilterExpressionDefinition[sortedDefnsByName.size()]);
    }

    private static AggregateDefinition[] convertAggregateDefnValuesToSortByNameArray(Map<String, AggregateDefinition> exprDefns) {
        if (exprDefns == null) {
            return EMPTY_AGGR_EXPRS_ARRAY;
        }
        TreeMap<String, AggregateDefinition> sortedDefnsByName = new TreeMap<String, AggregateDefinition>();
        for (AggregateDefinition exprDefn : exprDefns.values()) {
            sortedDefnsByName.put(exprDefn.getDisplayName(), exprDefn);
        }
        return sortedDefnsByName.values().toArray(new AggregateDefinition[sortedDefnsByName.size()]);
    }

    private static CombinedExpressionOperatorDefinition[] convertCombinedOpDefnValuesToArray(Map<String, CombinedExpressionOperatorDefinition> combinedOpDefns) {
        if (combinedOpDefns == null) {
            return EMPTY_COMBINED_OP_ARRAY;
        }
        return combinedOpDefns.values().toArray(new CombinedExpressionOperatorDefinition[combinedOpDefns.size()]);
    }

    private static FunctionExpressionDefinition[] convertFunctionDefnValuesToSortByNameArray(Map<String, FunctionExpressionDefinition> functionTypes) {
        if (functionTypes == null) {
            return EMPTY_FUNC_TYPES_ARRAY;
        }
        TreeMap<String, FunctionExpressionDefinition> sortedDefnsByName = new TreeMap<String, FunctionExpressionDefinition>();
        for (FunctionExpressionDefinition functionType : functionTypes.values()) {
            sortedDefnsByName.put(functionType.getDisplayName(), functionType);
        }
        return sortedDefnsByName.values().toArray(new FunctionExpressionDefinition[sortedDefnsByName.size()]);
    }

    public ExtensionContributor[] getContributorsOfDataSet(String odaDataSourceId, String odaDataSetId) throws IllegalArgumentException, OdaException {
        ResultExtensionExplorer.validateArgumentExists(odaDataSourceId);
        ResultExtensionExplorer.validateArgumentExists(odaDataSetId);
        ExtensionContributor[] contributors = this.findCachedContributorsByDataSet(odaDataSourceId, odaDataSetId);
        return contributors == null ? EMTPY_CONTRIBUTOR_ARRAY : contributors;
    }

    private ExtensionContributor[] findCachedContributorsByDataSet(String odaDataSourceId, String odaDataSetId) {
        List<ExtensionContributor> aggrContributors;
        HashSet<ExtensionContributor> contributors = new HashSet<ExtensionContributor>(4);
        List<ExtensionContributor> filterContributors = this.findCachedContributorsOfFilterExtension(odaDataSourceId, odaDataSetId);
        if (filterContributors != null) {
            contributors.addAll(filterContributors);
        }
        if ((aggrContributors = this.findCachedContributorsOfAggregateExtension(odaDataSourceId, odaDataSetId)) != null) {
            contributors.addAll(aggrContributors);
        }
        return contributors.isEmpty() ? null : contributors.toArray(new ExtensionContributor[contributors.size()]);
    }

    private List<ExtensionContributor> findCachedContributorsOfFilterExtension(String odaDataSourceId, String odaDataSetId) {
        if (this.getCachedFilterExtensions().isEmpty()) {
            return null;
        }
        return this.findSupportingContributors(this.getCachedFilterExtensions().keySet().iterator(), odaDataSourceId, odaDataSetId);
    }

    private List<ExtensionContributor> findCachedContributorsOfAggregateExtension(String odaDataSourceId, String odaDataSetId) {
        if (this.getCachedAggregateExtensions().isEmpty()) {
            return null;
        }
        return this.findSupportingContributors(this.getCachedAggregateExtensions().keySet().iterator(), odaDataSourceId, odaDataSetId);
    }

    private List<ExtensionContributor> findSupportingContributors(Iterator<ExtensionContributor> iter, String odaDataSourceId, String odaDataSetId) {
        ArrayList<ExtensionContributor> contributors = null;
        while (iter.hasNext()) {
            ExtensionContributor aContributor = iter.next();
            if (!aContributor.supportsDataSetType(odaDataSourceId, odaDataSetId)) continue;
            if (contributors == null) {
                contributors = new ArrayList<ExtensionContributor>(4);
            }
            contributors.add(aContributor);
        }
        return contributors == null || contributors.isEmpty() ? null : contributors;
    }

    public FilterExpressionDefinition[] getContributedFilterDefinitions(ExtensionContributor extensionContributor) throws IllegalArgumentException, OdaException {
        Map<String, FilterExpressionDefinition> filterExprDefns = this.getFilterDefinitionsByContributor(extensionContributor);
        return ResultExtensionExplorer.convertFilterDefnValuesToSortByNameArray(filterExprDefns);
    }

    public FilterExpressionDefinition getContributedFilterDefinition(ExtensionContributor extensionContributor, String exprId) throws IllegalArgumentException, OdaException {
        ResultExtensionExplorer.validateArgumentExists(exprId);
        Map<String, FilterExpressionDefinition> filterExprDefns = this.getFilterDefinitionsByContributor(extensionContributor);
        return filterExprDefns == null ? null : filterExprDefns.get(exprId);
    }

    public FilterExpressionDefinition[] getExtensionFilterDefinitions(String extensionId) throws IllegalArgumentException, OdaException {
        Map<String, FilterExpressionDefinition> filterExprDefns = this.getFilterDefinitionsByExtension(extensionId);
        return ResultExtensionExplorer.convertFilterDefnValuesToSortByNameArray(filterExprDefns);
    }

    public FilterExpressionDefinition getExtensionFilterDefinition(String extensionId, String exprId) throws IllegalArgumentException, OdaException {
        ResultExtensionExplorer.validateArgumentExists(exprId);
        Map<String, FilterExpressionDefinition> filterExprDefns = this.getFilterDefinitionsByExtension(extensionId);
        return filterExprDefns == null ? null : filterExprDefns.get(exprId);
    }

    private Map<String, FilterExpressionDefinition> getFilterDefinitionsByExtension(String extensionId) throws IllegalArgumentException, OdaException {
        ResultExtensionExplorer.validateArgumentExists(extensionId);
        Map<String, FilterExpressionDefinition> filterExprDefns = this.getCachedFilterDefinitionsByExtension(extensionId);
        return filterExprDefns;
    }

    private Map<String, FilterExpressionDefinition> getFilterDefinitionsByContributor(ExtensionContributor extensionContributor) throws IllegalArgumentException, OdaException {
        ResultExtensionExplorer.validateArgumentExists(extensionContributor);
        Map<String, FilterExpressionDefinition> filterExprDefns = this.getCachedFilterExtensions().get(extensionContributor);
        return filterExprDefns;
    }

    public ExtensionContributor getExtensionContributor(String extensionId) throws OdaException {
        ExtensionContributor contributor = this.findCachedContributorOfFilterExtension(extensionId);
        if (contributor != null) {
            return contributor;
        }
        contributor = this.findCachedContributorOfAggregateExtension(extensionId);
        return contributor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllExtensions() {
        IExtension[] extensions = ManifestExplorer.getExtensions(DTP_ODA_DYNAMIC_RESULT_SETS_EXT_POINT);
        ResultExtensionExplorer resultExtensionExplorer = this;
        synchronized (resultExtensionExplorer) {
            this.resetCache();
            int i = 0;
            while (i < extensions.length) {
                try {
                    this.addExtension(extensions[i], false);
                }
                catch (OdaException ex) {
                    ResultExtensionExplorer.getLogger().log(Level.WARNING, "Ignoring invalid org.eclipse.datatools.connectivity.oda.dynamicResultSet extension.", ex);
                }
                ++i;
            }
        }
    }

    private ExtensionContributor addExtension(IExtension dynamicResultExtn, boolean replaceExisting) throws OdaException {
        IConfigurationElement[] valueExprGroup;
        IConfigurationElement[] aggregateExprGroup;
        int i;
        IConfigurationElement[] filterExprGroup;
        IConfigurationElement contributorElement = ManifestUtil.getNamedElement(dynamicResultExtn, "contributor");
        if (contributorElement == null) {
            throw new OdaException(Messages.bind((String)Messages.querySpec_MISSING_EXT_POINT_ELEMENT, (Object[])new Object[]{DTP_ODA_DYNAMIC_RESULT_SETS_EXT_POINT, dynamicResultExtn.getUniqueIdentifier(), "contributor"}));
        }
        ExtensionContributor contributor = new ExtensionContributor(contributorElement);
        if ((replaceExisting || this.getCachedFilterExtensions().get(contributor) == null) && (filterExprGroup = ManifestUtil.getNamedElements(dynamicResultExtn, FILTER_GROUP_NAME)).length > 0) {
            contributor.setSupportedOdaFilterExpressions(filterExprGroup[0]);
            IConfigurationElement[] filterExprElements = filterExprGroup[0].getChildren("filterType");
            HashMap<String, FilterExpressionDefinition> filterExprs = new HashMap<String, FilterExpressionDefinition>(filterExprElements.length);
            i = 0;
            while (i < filterExprElements.length) {
                FilterExpressionDefinition filerExprDefn = new FilterExpressionDefinition(filterExprElements[i], contributor);
                filterExprs.put(filerExprDefn.getId(), filerExprDefn);
                ++i;
            }
            this.getCachedFilterExtensions().put(contributor, filterExprs);
        }
        if ((replaceExisting || this.getCachedAggregateExtensions().get(contributor) == null) && (aggregateExprGroup = ManifestUtil.getNamedElements(dynamicResultExtn, AGGREGATE_GROUP_NAME)).length > 0) {
            IConfigurationElement[] aggregateElements = aggregateExprGroup[0].getChildren("aggregateType");
            HashMap<String, AggregateDefinition> aggregateExprs = new HashMap<String, AggregateDefinition>(aggregateElements.length);
            i = 0;
            while (i < aggregateElements.length) {
                AggregateDefinition aggregateDefn = new AggregateDefinition(aggregateElements[i], contributor);
                aggregateExprs.put(aggregateDefn.getId(), aggregateDefn);
                ++i;
            }
            this.getCachedAggregateExtensions().put(contributor, aggregateExprs);
        }
        if ((replaceExisting || this.getCachedCombinedOperatorExtensions().get(contributor.getDeclaringExtensionId()) == null) && (valueExprGroup = ManifestUtil.getNamedElements(dynamicResultExtn, VALUE_EXPR_GROUP_NAME)).length > 0) {
            this.addExtensionValueExprGroupElement(contributor, valueExprGroup[0]);
        }
        return contributor;
    }

    private void addExtensionValueExprGroupElement(ExtensionContributor contributor, IConfigurationElement valueExprGroupElement) throws OdaException {
        IConfigurationElement[] combinedOperatorGroup = valueExprGroupElement.getChildren(COMBINED_OPERATOR_SUBGROUP_NAME);
        if (combinedOperatorGroup.length > 0) {
            this.addExtensionCombinedOperatorGroupElement(contributor.getDeclaringExtensionId(), combinedOperatorGroup[0]);
        }
        IConfigurationElement[] functionTypeElements = valueExprGroupElement.getChildren("functionExpressionType");
        this.addExtensionFunctionTypeElements(contributor, functionTypeElements);
        contributor.processSupportedValueExpressionType(valueExprGroupElement);
    }

    private void addExtensionCombinedOperatorGroupElement(String extensionId, IConfigurationElement combinedOperatorGroup) throws OdaException {
        IConfigurationElement[] supportedOdaCombinedOpElements = combinedOperatorGroup.getChildren("supportedOdaCombinedOperator");
        IConfigurationElement[] customCombinedOpElements = combinedOperatorGroup.getChildren("combinedOperatorType");
        HashMap<String, CombinedExpressionOperatorDefinition> combinedOperatorTypes = new HashMap<String, CombinedExpressionOperatorDefinition>(supportedOdaCombinedOpElements.length + customCombinedOpElements.length);
        int i = 0;
        while (i < supportedOdaCombinedOpElements.length) {
            CombinedExpressionOperatorDefinition supportedOdaCombinedOpDefn = new CombinedExpressionOperatorDefinition(supportedOdaCombinedOpElements[i]);
            combinedOperatorTypes.put(supportedOdaCombinedOpDefn.getId(), supportedOdaCombinedOpDefn);
            ++i;
        }
        i = 0;
        while (i < customCombinedOpElements.length) {
            CombinedExpressionOperatorDefinition.CustomCombinedOperatorDefinition customCombinedOpDefn = CombinedExpressionOperatorDefinition.newCustomDefinition(customCombinedOpElements[i]);
            combinedOperatorTypes.put(customCombinedOpDefn.getId(), customCombinedOpDefn);
            ++i;
        }
        this.getCachedCombinedOperatorExtensions().put(extensionId, combinedOperatorTypes);
    }

    private void addExtensionFunctionTypeElements(ExtensionContributor contributor, IConfigurationElement[] functionTypeElements) throws OdaException {
        if (functionTypeElements.length == 0) {
            return;
        }
        HashMap<String, FunctionExpressionDefinition> functionTypes = new HashMap<String, FunctionExpressionDefinition>(functionTypeElements.length);
        int i = 0;
        while (i < functionTypeElements.length) {
            FunctionExpressionDefinition funcDefn = new FunctionExpressionDefinition(functionTypeElements[i], contributor);
            functionTypes.put(funcDefn.getId(), funcDefn);
            ++i;
        }
        this.getCachedFunctionExtensions().put(contributor.getDeclaringExtensionId(), functionTypes);
    }

    public AggregateDefinition[] getContributedAggregateDefinitions(ExtensionContributor extensionContributor) throws IllegalArgumentException, OdaException {
        Map<String, AggregateDefinition> aggrExprDefns = this.getAggregateDefinitionsByContributor(extensionContributor);
        return ResultExtensionExplorer.convertAggregateDefnValuesToSortByNameArray(aggrExprDefns);
    }

    public AggregateDefinition getContributedAggregateDefinition(ExtensionContributor extensionContributor, String exprId) throws IllegalArgumentException, OdaException {
        ResultExtensionExplorer.validateArgumentExists(exprId);
        Map<String, AggregateDefinition> aggrExprDefns = this.getAggregateDefinitionsByContributor(extensionContributor);
        return aggrExprDefns == null ? null : aggrExprDefns.get(exprId);
    }

    public AggregateDefinition[] getExtensionAggregateDefinitions(String extensionId) throws IllegalArgumentException, OdaException {
        Map<String, AggregateDefinition> aggrExprDefns = this.getAggregateDefinitionsByExtension(extensionId);
        return ResultExtensionExplorer.convertAggregateDefnValuesToSortByNameArray(aggrExprDefns);
    }

    public AggregateDefinition getExtensionAggregateDefinition(String extensionId, String exprId) throws IllegalArgumentException, OdaException {
        ResultExtensionExplorer.validateArgumentExists(exprId);
        Map<String, AggregateDefinition> aggrExprDefns = this.getAggregateDefinitionsByExtension(extensionId);
        return aggrExprDefns == null ? null : aggrExprDefns.get(exprId);
    }

    private Map<String, AggregateDefinition> getAggregateDefinitionsByExtension(String extensionId) throws IllegalArgumentException, OdaException {
        ResultExtensionExplorer.validateArgumentExists(extensionId);
        Map<String, AggregateDefinition> exprDefns = this.getCachedAggregateDefinitionsByExtension(extensionId);
        return exprDefns;
    }

    private Map<String, AggregateDefinition> getAggregateDefinitionsByContributor(ExtensionContributor extensionContributor) throws OdaException {
        ResultExtensionExplorer.validateArgumentExists(extensionContributor);
        Map<String, AggregateDefinition> aggregateDefns = this.getCachedAggregateExtensions().get(extensionContributor);
        return aggregateDefns;
    }

    public CombinedExpressionOperatorDefinition[] getExtensionCombinedOperatorDefinitions(String extensionId) throws IllegalArgumentException, OdaException {
        ResultExtensionExplorer.validateArgumentExists(extensionId);
        Map<String, CombinedExpressionOperatorDefinition> combinedOpDefns = this.getCachedCombinedOpDefinitionsByExtension(extensionId);
        return ResultExtensionExplorer.convertCombinedOpDefnValuesToArray(combinedOpDefns);
    }

    public CombinedExpressionOperatorDefinition getExtensionCombinedOperatorDefinition(String extensionId, String operatorId) throws IllegalArgumentException, OdaException {
        ResultExtensionExplorer.validateArgumentExists(extensionId);
        ResultExtensionExplorer.validateArgumentExists(operatorId);
        Map<String, CombinedExpressionOperatorDefinition> combinedOpDefns = this.getCachedCombinedOpDefinitionsByExtension(extensionId);
        return combinedOpDefns == null ? null : combinedOpDefns.get(operatorId);
    }

    boolean supportsOdaCombinedOperator(String extensionId, String builtInOperatorId) {
        CombinedExpressionOperatorDefinition opDefn = null;
        try {
            opDefn = this.getExtensionCombinedOperatorDefinition(extensionId, builtInOperatorId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        catch (OdaException odaException) {
            return false;
        }
        return opDefn != null && opDefn.isBuiltInOperator();
    }

    boolean supportsCombinedValueExpressionType(String extensionId) {
        Map<String, CombinedExpressionOperatorDefinition> combinedOpDefns = this.getCachedCombinedOpDefinitionsByExtension(extensionId);
        return combinedOpDefns != null && !combinedOpDefns.isEmpty();
    }

    public FunctionExpressionDefinition[] getExtensionFunctionDefinitions(String extensionId) throws IllegalArgumentException, OdaException {
        ResultExtensionExplorer.validateArgumentExists(extensionId);
        Map<String, FunctionExpressionDefinition> functionDefns = this.getCachedFunctionDefinitionsByExtension(extensionId);
        return ResultExtensionExplorer.convertFunctionDefnValuesToSortByNameArray(functionDefns);
    }

    public FunctionExpressionDefinition getExtensionFunctionDefinition(String extensionId, String functionId) throws IllegalArgumentException, OdaException {
        ResultExtensionExplorer.validateArgumentExists(extensionId);
        ResultExtensionExplorer.validateArgumentExists(functionId);
        Map<String, FunctionExpressionDefinition> functionDefns = this.getCachedFunctionDefinitionsByExtension(extensionId);
        return functionDefns == null ? null : functionDefns.get(functionId);
    }

    boolean supportsFunctionValueExpressionType(String extensionId) {
        Map<String, FunctionExpressionDefinition> functionDefns = this.getCachedFunctionDefinitionsByExtension(extensionId);
        return functionDefns != null && !functionDefns.isEmpty();
    }

    private static void validateArgumentExists(String arg) throws IllegalArgumentException {
        ResultExtensionUtil.validateArgumentExists(arg);
    }

    private static void validateArgumentExists(ExtensionContributor contributor) throws IllegalArgumentException {
        ResultExtensionUtil.validateArgumentExists(contributor);
    }
}

