/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jst.ws.jaxws.utils.ContractChecker;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotationInspector;
import org.eclipse.jst.ws.jaxws.utils.annotations.ILocator;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;
import org.eclipse.jst.ws.jaxws.utils.clazz.ASTUtils;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.AnnotationImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.ArrayValueImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.BooleanValueImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.ClassValueImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.IntegerValueImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.LocatorImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.ParamValuePairImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.QualifiedNameValueImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.StringValueImpl;

public class AnnotationInspectorImpl
implements IAnnotationInspector {
    private IType iType;
    private CompilationUnit cUnit;

    public AnnotationInspectorImpl(IType type) {
        ContractChecker.nullCheckParam(type, "type");
        this.iType = type;
    }

    @Override
    public IAnnotation<IMethod> inspectMethod(IMethod method, String annotationQName) throws JavaModelException {
        ContractChecker.nullCheckParam(method, "method");
        ContractChecker.nullCheckParam(annotationQName, "annotationQName");
        if (!(method instanceof IMethod)) {
            throw new IllegalArgumentException("method argument is not of correct Type!");
        }
        if (annotationQName.trim().equals("")) {
            throw new IllegalArgumentException("annotationQName argument is not with propper value!");
        }
        return this.getSpecificAnnotationFromMember(method, method.getParent().getElementName(), annotationQName);
    }

    @Override
    public Collection<IAnnotation<IMethod>> inspectMethod(IMethod method) throws JavaModelException {
        ContractChecker.nullCheckParam(method, "method");
        if (!(method instanceof IMethod)) {
            throw new IllegalArgumentException("method argument is not of correct Type!");
        }
        return this.getFromMember(method, method.getParent().getElementName());
    }

    @Override
    public IAnnotation<IField> inspectField(IField field, String annotationQName) throws JavaModelException {
        ContractChecker.nullCheckParam(field, "field");
        ContractChecker.nullCheckParam(annotationQName, "annotationQName");
        if (!(field instanceof IField)) {
            throw new IllegalArgumentException("field argument is not of correct Type!");
        }
        if (annotationQName.trim().equals("")) {
            throw new IllegalArgumentException("annotationQName argument is not with propper value!");
        }
        String className = field.getParent().getElementName();
        return this.getSpecificAnnotationFromMember(field, className, annotationQName);
    }

    @Override
    public Collection<IAnnotation<IField>> inspectField(IField field) throws JavaModelException {
        if (field == null) {
            throw new NullPointerException("field should not be null!");
        }
        if (!(field instanceof IField)) {
            throw new IllegalArgumentException("field argument is not of correct Type!");
        }
        String className = field.getParent().getElementName();
        return this.getFromMember(field, className);
    }

    @Override
    public IAnnotation<ITypeParameter> inspectParam(ITypeParameter param, String annotationQName) throws JavaModelException {
        ContractChecker.nullCheckParam(param, "param");
        ContractChecker.nullCheckParam(annotationQName, "annotationQName");
        if (!(param instanceof ITypeParameter)) {
            throw new IllegalArgumentException("param argument is not of correct Type!");
        }
        if (annotationQName.trim().equals("")) {
            throw new IllegalArgumentException("annotationQName argument is not with propper value!");
        }
        String className = this.getClassNameFromParam(param);
        return this.getSpecificAnnotationFromMember(param, className, annotationQName);
    }

    @Override
    public Collection<IAnnotation<ITypeParameter>> inspectParam(ITypeParameter param) throws JavaModelException {
        if (param == null) {
            throw new NullPointerException("param should not be null!");
        }
        if (!(param instanceof ITypeParameter)) {
            throw new IllegalArgumentException("param argument is not of correct Type!");
        }
        return this.getFromMember(param, this.getClassNameFromParam(param));
    }

    @Override
    public IAnnotation<IType> inspectType(String annotationQName) throws JavaModelException {
        ContractChecker.nullCheckParam(annotationQName, "annotationQName");
        if (annotationQName.trim().equals("")) {
            throw new IllegalArgumentException("annotationQName argument is not with propper value!");
        }
        return this.getSpecificAnnotationFromMember(this.iType, this.iType.getElementName(), annotationQName);
    }

    @Override
    public Collection<IAnnotation<IType>> inspectType() throws JavaModelException {
        return this.getFromMember(this.iType, this.iType.getElementName());
    }

    private String getClassNameFromParam(ITypeParameter param) throws JavaModelException {
        if (param.getDeclaringMember() instanceof IMethod) {
            return param.getDeclaringMember().getParent().getElementName();
        }
        return param.getDeclaringMember().getElementName();
    }

    protected <T extends IJavaElement> Set<IAnnotation<T>> getFromMember(T type, String className) throws JavaModelException {
        if (!this.isSupportedJavaElement(type)) {
            throw new IllegalArgumentException("passed argument is not of correct type.");
        }
        ICompilationUnit cUnit = null;
        cUnit = type instanceof IMember ? ((IMember)type).getCompilationUnit() : ((ITypeParameter)type).getDeclaringMember().getCompilationUnit();
        if (cUnit == null) {
            return new HashSet<IAnnotation<T>>();
        }
        CompilationUnit unit = this.getCompilationUnit();
        AbstractTypeDeclaration typeDeclaration = ASTUtils.getInstance().getTypeDeclaration(className, unit);
        switch (type.getElementType()) {
            case 7: {
                return this.getAnnotations(type, (BodyDeclaration)typeDeclaration);
            }
            case 8: {
                FieldDeclaration fieldDeclaration = ASTUtils.getInstance().getFieldDeclaration((IField)type, (TypeDeclaration)typeDeclaration);
                return this.getAnnotations(type, (BodyDeclaration)fieldDeclaration);
            }
            case 9: {
                MethodDeclaration methodDeclaration = ASTUtils.getInstance().getMethodDeclaration((IMethod)type, (TypeDeclaration)typeDeclaration);
                return this.getAnnotations(type, (BodyDeclaration)methodDeclaration);
            }
            case 15: {
                MethodDeclaration methodDeclaration = ASTUtils.getInstance().getMethodDeclaration((IMethod)((ITypeParameter)type).getParent(), (TypeDeclaration)typeDeclaration);
                return this.getParamAnnotations(type, methodDeclaration);
            }
        }
        return new HashSet<IAnnotation<T>>();
    }

    private <T extends IJavaElement> Set<IAnnotation<T>> getAnnotations(T iMember, BodyDeclaration bodyDeclaration) throws JavaModelException {
        if (bodyDeclaration != null) {
            List list = bodyDeclaration.modifiers();
            return this.extractAnnotations(iMember, list);
        }
        return new HashSet<IAnnotation<T>>();
    }

    private <T extends IJavaElement> Set<IAnnotation<T>> getParamAnnotations(T iMember, MethodDeclaration methodDeclaration) throws JavaModelException {
        if (methodDeclaration != null) {
            for (Object param : methodDeclaration.parameters()) {
                if (!(param instanceof SingleVariableDeclaration) || !((ITypeParameter)iMember).getElementName().toString().equals(((SingleVariableDeclaration)param).getName().toString())) continue;
                List list = ((SingleVariableDeclaration)param).modifiers();
                return this.extractAnnotations(iMember, list);
            }
        }
        return new HashSet<IAnnotation<T>>();
    }

    private <T extends IJavaElement> Set<IAnnotation<T>> extractAnnotations(T iMember, List list) throws JavaModelException {
        Iterator iter = list.iterator();
        HashSet<IValue> values = new HashSet<IValue>();
        while (iter.hasNext()) {
            IExtendedModifier element = (IExtendedModifier)iter.next();
            if (!element.isAnnotation()) continue;
            values.add(this.convertExpression((Expression)element));
        }
        HashSet<IAnnotation<T>> expressions = new HashSet<IAnnotation<T>>();
        for (IValue value : values) {
            AnnotationImpl ann = (AnnotationImpl)value;
            ann.setAppliedElementWithoutSave(iMember);
            expressions.add(ann);
        }
        return expressions;
    }

    private <T extends IJavaElement> IAnnotation<T> extractSpecificAnnotation(T iMember, List list, IType type, String annotationQName) throws JavaModelException {
        Iterator iter = list.iterator();
        HashSet<IValue> values = new HashSet<IValue>();
        while (iter.hasNext()) {
            Name typeName;
            IExtendedModifier element = (IExtendedModifier)iter.next();
            if (!element.isAnnotation() || !annotationQName.endsWith((typeName = ((Annotation)element).getTypeName()).getFullyQualifiedName())) continue;
            values.add(this.convertExpression((Expression)element));
        }
        for (IValue value : values) {
            AnnotationImpl tmpAnnotation = (AnnotationImpl)value;
            if (!this.checkSpecificAnnotattion(tmpAnnotation, type, annotationQName)) continue;
            AnnotationImpl<T> result = new AnnotationImpl<T>(annotationQName, tmpAnnotation.getParamValuePairs());
            result.setAppliedElementWithoutSave(iMember);
            result.setLocator(tmpAnnotation.getLocator());
            return result;
        }
        return null;
    }

    private <T extends IJavaElement> boolean checkSpecificAnnotattion(AnnotationImpl<T> annotation, IType type, String annotationQName) throws JavaModelException {
        IImportDeclaration importDeclaration;
        IImportDeclaration[] imports;
        if (annotation.getAnnotationName().equals(annotationQName) || (String.valueOf(type.getPackageFragment().getElementName()) + "." + annotation.getAnnotationName()).equals(annotationQName)) {
            return true;
        }
        ICompilationUnit cUnit = type.getCompilationUnit();
        IImportDeclaration[] iImportDeclarationArray = imports = cUnit.getImports();
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            importDeclaration = iImportDeclarationArray[n2];
            if (annotationQName.endsWith(annotation.getAnnotationName()) && importDeclaration.getElementName().equals(annotationQName)) {
                return true;
            }
            ++n2;
        }
        iImportDeclarationArray = imports;
        n = imports.length;
        n2 = 0;
        while (n2 < n) {
            importDeclaration = iImportDeclarationArray[n2];
            if (importDeclaration.getElementName().endsWith("*")) {
                String importStr = importDeclaration.getElementName().substring(0, importDeclaration.getElementName().length() - 1);
                if (annotationQName.endsWith(annotation.getAnnotationName()) && annotationQName.indexOf(importStr) == 0) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private IValue convertExpression(Expression element) throws JavaModelException {
        switch (element.getNodeType()) {
            case 78: {
                MarkerAnnotation ma = (MarkerAnnotation)element;
                AnnotationImpl annotation = new AnnotationImpl(this.getFullyQualifiedAnnotationName((Annotation)ma), new HashSet<IParamValuePair>());
                annotation.setLocator(this.createLocator((ASTNode)ma));
                return annotation;
            }
            case 79: {
                SingleMemberAnnotation sma = (SingleMemberAnnotation)element;
                HashSet<IParamValuePair> values = new HashSet<IParamValuePair>();
                IValue value = this.convertExpression(sma.getValue());
                if (value != null) {
                    values.add(AnnotationFactory.createParamValuePairValue("value", value));
                }
                AnnotationImpl annotation = new AnnotationImpl(this.getFullyQualifiedAnnotationName((Annotation)sma), values);
                annotation.setLocator(this.createLocator((ASTNode)sma));
                return annotation;
            }
            case 77: {
                return this.getNormalAnnotationValue((NormalAnnotation)element);
            }
            case 4: {
                ArrayInitializer arr = (ArrayInitializer)element;
                List list = arr.expressions();
                Iterator iter = list.iterator();
                HashSet<IValue> result = new HashSet<IValue>();
                while (iter.hasNext()) {
                    Expression expr = (Expression)iter.next();
                    result.add(this.convertExpression(expr));
                }
                return new ArrayValueImpl(result);
            }
            case 33: {
                break;
            }
            case 42: {
                break;
            }
            case 57: {
                return this.getTypeLiteralValue((TypeLiteral)element);
            }
            case 40: {
                QualifiedName qn = (QualifiedName)element;
                QualifiedNameValueImpl qnValue = new QualifiedNameValueImpl(qn.getFullyQualifiedName());
                qnValue.setLocator(this.createLocator((ASTNode)qn));
                return qnValue;
            }
            case 9: {
                BooleanLiteral bl = (BooleanLiteral)element;
                BooleanValueImpl bValue = new BooleanValueImpl(bl.booleanValue());
                bValue.setLocator(this.createLocator((ASTNode)bl));
                return bValue;
            }
            case 13: {
                break;
            }
            case 34: {
                NumberLiteral nl = (NumberLiteral)element;
                IntegerValueImpl intValue = new IntegerValueImpl(nl.getToken());
                intValue.setLocator(this.createLocator((ASTNode)nl));
                return intValue;
            }
            case 45: {
                StringLiteral sl = (StringLiteral)element;
                StringValueImpl strValue = new StringValueImpl(sl.getLiteralValue());
                strValue.setLocator(this.createLocator((ASTNode)sl));
                return strValue;
            }
        }
        return null;
    }

    private IValue getTypeLiteralValue(TypeLiteral tl) throws JavaModelException {
        CompilationUnit cu;
        Type type = tl.getType();
        SimpleName name = null;
        if (type.isQualifiedType()) {
            name = ((QualifiedType)type).getName();
        } else if (type.isSimpleType()) {
            name = ((SimpleType)type).getName();
        }
        if (name != null && (cu = this.getCompilationUnit((Expression)tl)) != null) {
            String fullyQualifiedName = name.getFullyQualifiedName();
            if (type.isSimpleType()) {
                fullyQualifiedName = this.resolveType((ICompilationUnit)cu.getJavaElement(), fullyQualifiedName);
            }
            ClassValueImpl cValue = new ClassValueImpl(fullyQualifiedName);
            cValue.setLocator(this.createLocator((ASTNode)tl));
            return cValue;
        }
        return null;
    }

    private IValue getNormalAnnotationValue(NormalAnnotation na) throws JavaModelException {
        List l = na.values();
        Iterator iter = l.iterator();
        HashSet<IParamValuePair> result = new HashSet<IParamValuePair>();
        while (iter.hasNext()) {
            MemberValuePair mvp = (MemberValuePair)iter.next();
            IValue mvpval = this.convertExpression(mvp.getValue());
            ParamValuePairImpl pair = new ParamValuePairImpl(mvp.getName().getIdentifier(), mvpval);
            pair.setLocator(this.createLocator((ASTNode)mvp));
            result.add(pair);
        }
        AnnotationImpl annotation = new AnnotationImpl(this.getFullyQualifiedAnnotationName((Annotation)na), result);
        annotation.setLocator(this.createLocator((ASTNode)na));
        return annotation;
    }

    private String getFullyQualifiedAnnotationName(Annotation anno) throws JavaModelException {
        Name typeName = anno.getTypeName();
        String fullyQualifiedName = typeName.getFullyQualifiedName();
        if (typeName.isSimpleName()) {
            CompilationUnit cu = this.getCompilationUnit((Expression)anno);
            fullyQualifiedName = this.resolveType((ICompilationUnit)cu.getJavaElement(), fullyQualifiedName);
        }
        return fullyQualifiedName;
    }

    private CompilationUnit getCompilationUnit(Expression element) {
        Expression cu = element;
        while (cu != null && !(cu instanceof CompilationUnit)) {
            cu = cu.getParent();
        }
        return (CompilationUnit)cu;
    }

    private String resolveType(ICompilationUnit icu, String fullyQualifiedName) throws JavaModelException {
        String localFullyQualifiedName = fullyQualifiedName;
        IType[] allTypes = icu.getAllTypes();
        if (allTypes == null) {
            return localFullyQualifiedName;
        }
        int i = 0;
        while (i < allTypes.length) {
            String[][] resolvedType = allTypes[i].resolveType(localFullyQualifiedName);
            if (resolvedType != null && resolvedType.length > 0) {
                StringBuffer buf = new StringBuffer();
                int j = 0;
                while (j < resolvedType[0].length) {
                    buf = this.appendDot(j, buf);
                    buf.append(resolvedType[0][j]);
                    ++j;
                }
                localFullyQualifiedName = buf.toString();
                break;
            }
            ++i;
        }
        return localFullyQualifiedName;
    }

    private StringBuffer appendDot(int index, StringBuffer buff) {
        StringBuffer result = buff;
        if (index != 0) {
            result.append('.');
        }
        return result;
    }

    protected <T extends IJavaElement> IAnnotation<T> getSpecificAnnotationFromMember(T type, String className, String annotationQName) throws JavaModelException {
        if (!this.isSupportedJavaElement(type)) {
            throw new IllegalArgumentException("passed argument is not of correct type.");
        }
        ICompilationUnit cUnit = null;
        cUnit = type instanceof IMember ? ((IMember)type).getCompilationUnit() : ((ITypeParameter)type).getDeclaringMember().getCompilationUnit();
        if (cUnit == null) {
            return null;
        }
        CompilationUnit unit = this.getCompilationUnit();
        AbstractTypeDeclaration typeDeclaration = ASTUtils.getInstance().getTypeDeclaration(className, unit);
        switch (type.getElementType()) {
            case 7: {
                return this.getSpecificAnnotation(type, (BodyDeclaration)typeDeclaration, (IType)type, annotationQName);
            }
            case 8: {
                IField field = (IField)type;
                FieldDeclaration fieldDeclaration = ASTUtils.getInstance().getFieldDeclaration(field, (TypeDeclaration)typeDeclaration);
                return this.getSpecificAnnotation(type, (BodyDeclaration)fieldDeclaration, field.getDeclaringType(), annotationQName);
            }
            case 9: {
                IMethod method = (IMethod)type;
                MethodDeclaration methodDeclaration = ASTUtils.getInstance().getMethodDeclaration(method, (TypeDeclaration)typeDeclaration);
                return this.getSpecificAnnotation(type, (BodyDeclaration)methodDeclaration, method.getDeclaringType(), annotationQName);
            }
            case 15: {
                IMethod method = (IMethod)((ITypeParameter)type).getParent();
                MethodDeclaration methodDeclaration = ASTUtils.getInstance().getMethodDeclaration(method, (TypeDeclaration)typeDeclaration);
                return this.getSpecificParamAnnotation(type, methodDeclaration, method.getDeclaringType(), annotationQName);
            }
        }
        return null;
    }

    private <T extends IJavaElement> IAnnotation<T> getSpecificAnnotation(T iMember, BodyDeclaration bodyDeclaration, IType type, String annotationQName) throws JavaModelException {
        if (bodyDeclaration != null) {
            List list = bodyDeclaration.modifiers();
            return this.extractSpecificAnnotation(iMember, list, type, annotationQName);
        }
        return null;
    }

    private <T extends IJavaElement> IAnnotation<T> getSpecificParamAnnotation(T iMember, MethodDeclaration methodDeclaration, IType type, String annotationQName) throws JavaModelException {
        if (methodDeclaration != null) {
            for (Object param : methodDeclaration.parameters()) {
                if (!(param instanceof SingleVariableDeclaration) || !((ITypeParameter)iMember).getElementName().toString().equals(((SingleVariableDeclaration)param).getName().toString())) continue;
                List list = ((SingleVariableDeclaration)param).modifiers();
                return this.extractSpecificAnnotation(iMember, list, type, annotationQName);
            }
        }
        return null;
    }

    private boolean isSupportedJavaElement(IJavaElement javaElement) {
        return javaElement.getElementType() == 9 || javaElement.getElementType() == 7 || javaElement.getElementType() == 8 || javaElement.getElementType() == 15;
    }

    private CompilationUnit getCompilationUnit() {
        if (this.cUnit == null) {
            this.cUnit = ASTUtils.getInstance().createCompilationUnit(this.iType.getCompilationUnit(), null);
        }
        return this.cUnit;
    }

    private ILocator createLocator(ASTNode node) {
        int lineNumber = this.getCompilationUnit().getLineNumber(node.getStartPosition());
        return new LocatorImpl(lineNumber, node.getStartPosition(), node.getLength());
    }
}

