/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.buildpath;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.CorrectionEngine;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.buildpath.BuildPathSupport;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class ClasspathVariableMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private static final IMarkerResolution[] NO_RESOLUTION = new IMarkerResolution[0];

    public boolean hasResolutions(IMarker marker) {
        int id = marker.getAttribute("id", -1);
        if (id == 1010) {
            String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
            if (arguments == null || arguments.length == 0) {
                return false;
            }
            if (arguments[0].startsWith("JUNIT_HOME/") || arguments[0].startsWith("JUNIT_SRC_HOME/")) {
                return true;
            }
        }
        return false;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        if (!this.hasResolutions(marker)) {
            return NO_RESOLUTION;
        }
        String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
        Path path = new Path(arguments[0]);
        final IJavaProject project = this.getJavaProject(marker);
        return new IMarkerResolution2[]{new IMarkerResolution2((IPath)path){
            private final /* synthetic */ IPath val$path;
            {
                this.val$path = iPath;
            }

            public Image getImage() {
                return JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
            }

            public String getLabel() {
                return JUnitMessages.ClasspathVariableMarkerResolutionGenerator_use_JUnit3;
            }

            public String getDescription() {
                return JUnitMessages.ClasspathVariableMarkerResolutionGenerator_use_JUnit3_desc;
            }

            public void run(IMarker nonsenseArgument) {
                try {
                    IClasspathEntry[] entries = project.getRawClasspath();
                    int idx = ClasspathVariableMarkerResolutionGenerator.this.indexOfClasspath(entries, this.val$path);
                    if (idx == -1) {
                        return;
                    }
                    entries[idx] = BuildPathSupport.getJUnit3ClasspathEntry();
                    ClasspathVariableMarkerResolutionGenerator.setClasspath(project, entries, (IRunnableContext)new BusyIndicatorRunnableContext());
                }
                catch (JavaModelException e) {
                    JUnitPlugin.log(e);
                }
            }
        }};
    }

    private IJavaProject getJavaProject(IMarker marker) {
        return JavaCore.create((IProject)marker.getResource().getProject());
    }

    private int indexOfClasspath(IClasspathEntry[] entries, IPath path) {
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry curr = entries[i];
            if (curr.getEntryKind() == 4 && curr.getPath().equals((Object)path)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static void setClasspath(IJavaProject project, IClasspathEntry[] entries, IRunnableContext context) {
        try {
            context.run(true, false, monitor -> {
                try {
                    project.setRawClasspath(entries, monitor);
                }
                catch (JavaModelException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            JUnitPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

