/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.w3c.dom.Node;

public class DTDDeclNode
extends DOMNode {
    public DTDDeclParameter unrecognized;
    public DTDDeclParameter declType;
    private List<DTDDeclParameter> parameters;
    private DTDDeclParameter name;

    public DTDDeclNode(int start, int end) {
        super(start, end);
    }

    public String getName() {
        DTDDeclParameter name = this.getNameParameter();
        return name != null ? name.getParameter() : null;
    }

    public DTDDeclParameter getNameParameter() {
        return this.name;
    }

    protected DTDDeclParameter getParameterAtIndex(int index) {
        return this.parameters != null && this.parameters.size() > index ? this.parameters.get(index) : null;
    }

    public void setName(int start, int end) {
        this.name = this.addNewParameter(start, end);
    }

    public boolean isInNameParameter(int offset) {
        DTDDeclParameter name = this.getNameParameter();
        return DOMNode.isIncluded(name, offset);
    }

    public DOMDocumentType getOwnerDocType() {
        for (Node node = this.parent; node != null; node = node.getParentNode()) {
            if (node.getNodeType() != 10) continue;
            return (DOMDocumentType)node;
        }
        return null;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public short getNodeType() {
        return 105;
    }

    public String getUnrecognized() {
        return this.unrecognized.getParameter();
    }

    public void setUnrecognized(int start, int end) {
        this.unrecognized = this.addNewParameter(start, end);
    }

    public DTDDeclParameter addNewParameter(int start, int end) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<DTDDeclParameter>();
        }
        DTDDeclParameter parameter = new DTDDeclParameter(this, start, end);
        this.parameters.add(parameter);
        this.end = end;
        return parameter;
    }

    public void updateLastParameterEnd(int end) {
        if (this.parameters != null && this.parameters.size() > 0) {
            DTDDeclParameter last = this.parameters.get(this.parameters.size() - 1);
            last.end = end;
            this.end = end;
        }
    }

    public List<DTDDeclParameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<DTDDeclParameter>();
        }
        return this.parameters;
    }

    public void setDeclType(int start, int end) {
        this.declType = new DTDDeclParameter(this, start, end);
    }

    public String getDeclType() {
        if (this.declType != null) {
            return this.declType.getParameter();
        }
        return null;
    }

    public DTDDeclParameter getReferencedElementNameAt(int offset) {
        if (this.isInNameParameter(offset)) {
            return this.getNameParameter();
        }
        return null;
    }
}

