/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.action.contributionitem;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.AbstractContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.CommonUIServicesActionPlugin;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.ContributeToActionBarsOperation;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.ContributeToPopupMenuOperation;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.DisposeContributionsOperation;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.IContributionDescriptorReader;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.IContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.ProviderContributionDescriptor;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.UpdateActionBarsOperation;
import org.eclipse.gmf.runtime.common.ui.services.util.ActivityFilterProviderDescriptor;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.common.ui.util.WorkbenchPartDescriptor;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.framework.Bundle;

public class ContributionItemService
extends Service
implements IContributionItemProvider {
    private static final ContributionItemService instance = new ContributionItemService();

    public static ContributionItemService getInstance() {
        return instance;
    }

    private ContributionItemService() {
        this.configureProviders(CommonUIServicesActionPlugin.getPluginId(), "contributionItemProviders");
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    public void contributeToActionBars(IActionBars actionBars, IWorkbenchPart workbenchPart) {
        this.contributeToActionBars(actionBars, (IWorkbenchPartDescriptor)new WorkbenchPartDescriptor(workbenchPart.getSite().getId(), workbenchPart.getClass(), workbenchPart.getSite().getPage()));
    }

    @Override
    public void contributeToActionBars(IActionBars actionBars, IWorkbenchPartDescriptor workbenchPartDescriptor) {
        this.execute(new ContributeToActionBarsOperation(actionBars, workbenchPartDescriptor));
    }

    @Override
    public void contributeToPopupMenu(IMenuManager popupMenu, IWorkbenchPart workbenchPart) {
        this.execute(new ContributeToPopupMenuOperation(popupMenu, workbenchPart));
    }

    @Override
    public void disposeContributions(IWorkbenchPartDescriptor workbenchPartDescriptor) {
        this.execute(new DisposeContributionsOperation(workbenchPartDescriptor));
    }

    @Override
    public void updateActionBars(IActionBars actionBars, IWorkbenchPartDescriptor workbenchPartDescriptor) {
        this.execute(new UpdateActionBarsOperation(actionBars, workbenchPartDescriptor));
    }

    public void disposeContributions(IWorkbenchPart workbenchPart) {
        this.execute(new DisposeContributionsOperation((IWorkbenchPartDescriptor)new WorkbenchPartDescriptor(workbenchPart.getSite().getId(), workbenchPart.getClass(), workbenchPart.getSite().getPage())));
    }

    private void execute(IOperation operation) {
        this.execute(ExecutionStrategy.REVERSE, operation);
    }

    protected static class ProviderDescriptor
    extends ActivityFilterProviderDescriptor {
        private static final String CHECK_PLUGIN_LOADED = "checkPluginLoaded";
        private ProviderContributionDescriptor contributionDescriptor;
        private boolean checkPluginLoaded = true;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            String s = element.getAttribute(CHECK_PLUGIN_LOADED);
            if (s != null) {
                this.checkPluginLoaded = Boolean.valueOf(s);
            }
            this.contributionDescriptor = ProviderContributionDescriptor.parse(element);
            assert (this.contributionDescriptor != null) : "contributionDescriptor cannot be null";
        }

        public boolean provides(IOperation operation) {
            if (operation instanceof DisposeContributionsOperation && this.provider != null) {
                return this.provider.provides(operation);
            }
            if (!super.provides(operation)) {
                return false;
            }
            if (this.checkPluginLoaded && !this.isPluginLoaded()) {
                return false;
            }
            if (!this.contributionDescriptor.hasContributions()) {
                if (!this.policyInitialized) {
                    this.policyInitialized = true;
                    this.policy = this.getPolicy();
                }
                if (this.policy != null) {
                    return this.getPolicy().provides(operation);
                }
                if (this.getProvider() != null) {
                    return this.getProvider().provides(operation);
                }
            }
            if (operation instanceof ContributeToActionBarsOperation) {
                ContributeToActionBarsOperation op = (ContributeToActionBarsOperation)operation;
                return this.contributionDescriptor.hasContributionsFor(op.getWorkbenchPartDescriptor().getPartId(), op.getWorkbenchPartDescriptor().getPartClass());
            }
            if (operation instanceof ContributeToPopupMenuOperation) {
                ContributeToPopupMenuOperation op = (ContributeToPopupMenuOperation)operation;
                ISelection selection = op.getWorkbenchPart().getSite().getSelectionProvider().getSelection();
                return this.contributionDescriptor.hasContributionsFor(op.getPopupMenu(), selection);
            }
            return false;
        }

        public IProvider getProvider() {
            if (this.provider == null) {
                IProvider newProvider = super.getProvider();
                if (this.provider instanceof IContributionDescriptorReader) {
                    IContributionDescriptorReader reader = (IContributionDescriptorReader)newProvider;
                    reader.setContributionDescriptor(this.contributionDescriptor);
                }
                if (this.provider instanceof AbstractContributionItemProvider) {
                    ((AbstractContributionItemProvider)this.provider).setPluginContribution(new IPluginContribution(){

                        public String getLocalId() {
                            return this.getElement().getDeclaringExtension().getSimpleIdentifier();
                        }

                        public String getPluginId() {
                            return this.getElement().getContributor().getName();
                        }
                    });
                }
                return newProvider;
            }
            return super.getProvider();
        }

        private boolean isPluginLoaded() {
            if (!this.getElement().isValid()) {
                return false;
            }
            String pluginId = this.getElement().getDeclaringExtension().getContributor().getName();
            Bundle bundle = Platform.getBundle((String)pluginId);
            return bundle != null && bundle.getState() == 32;
        }
    }
}

