package aQute.maven.dto;

import aQute.bnd.util.dto.DTO;

/**
 * Generic informations for a build.
 */
public class BuildBaseDTO extends DTO {
	/**
	 * The default goal (or phase in Maven 2) to execute when none is specified
	 * for the project. Note that in case of a multi-module build, only the
	 * default goal of the top-level project is relevant, i.e. the default goals
	 * of child modules are ignored. Since Maven 3, multiple goals/phases can be
	 * separated by whitespace.
	 */
	public String				defaultGoal;
	/**
	 * This element describes all of the classpath resources such as properties
	 * files associated with a project. These resources are often included in
	 * the final package. The default value is <code>src/main/resources</code>.
	 */
	public ResourceDTO[]		resources;
	/**
	 * This element describes all of the classpath resources such as properties
	 * files associated with a project's unit tests. The default value is
	 * <code>src/test/resources</code>.
	 */
	public ResourceDTO[]		testResources;

	/**
	 * The directory where all files generated by the build are placed. The
	 * default value is <code>target</code>.
	 */
	public String				directory;
	/**
	 * The filename (excluding the extension, and with no path information) that
	 * the produced artifact will be called. The default value is
	 * <code>${artifactId}-${version}</code>.
	 */
	public String				finalName;

	/**
	 * The list of filter properties files that are used when filtering is
	 * enabled.<
	 */
	public String[]				filters;

	/**
	 * Default plugin information to be made available for reference by projects
	 * derived from this one. This plugin configuration will not be resolved or
	 * bound to the lifecycle unless referenced. Any local configuration for a
	 * given plugin will override the plugin's entire definition here.
	 */
	public PluginManagementDTO	pluginManagement;

	/**
	 * The list of plugins to use
	 */
	public PluginDTO			plugins;

}
