/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.lm.FixedBaseline;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class VerifyFingerPrintAction
extends LMAction<FixedBaseline> {
    private static final String TITLE = "Verify Fingerprint";

    public VerifyFingerPrintAction(IWorkbenchPage page, StructuredViewer viewer, FixedBaseline fixedBaseline) {
        super(page, TITLE + INTERACTIVE, "Verify the fingerprint of baseline '" + fixedBaseline.getName() + "'", OM.getImageDescriptor("icons/FingerPrint.gif"), "Verify the fingerprint of baseline '" + fixedBaseline.getName() + "'.", "icons/wizban/FingerPrint.png", fixedBaseline);
    }

    @Override
    protected boolean isDialogNeeded() {
        return false;
    }

    @Override
    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent) {
    }

    @Override
    protected void doRun(FixedBaseline fixedBaseline, IProgressMonitor monitor) throws Exception {
        VerifyFingerPrintAction.verifyFingerPrint(fixedBaseline, this.getShell());
    }

    public static void verifyFingerPrint(FixedBaseline fixedBaseline, Shell shell) {
        ISystemDescriptor systemDescriptor = ISystemManager.INSTANCE.getDescriptor((EObject)fixedBaseline.getSystem());
        boolean valid = systemDescriptor.verifyFingerPrint(fixedBaseline);
        shell.getDisplay().syncExec(() -> {
            if (valid) {
                MessageDialog.openInformation((Shell)shell, (String)TITLE, (String)"The fingerprint is valid.");
            } else {
                MessageDialog.openWarning((Shell)shell, (String)TITLE, (String)"The  fingerprint is invalid.");
            }
        });
    }
}

