/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.ui.InspectPopupDialog;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.EvaluateAction;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ForceReturnAction
extends EvaluateAction {
    private IJavaStackFrame fTargetFrame = null;

    @Override
    protected void displayResult(final IEvaluationResult result) {
        this.evaluationCleanup();
        final Display display = JDIDebugUIPlugin.getStandardDisplay();
        if (result.hasErrors()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (display.isDisposed()) {
                        return;
                    }
                    ForceReturnAction.this.reportErrors(result);
                }
            });
            return;
        }
        try {
            IJavaStackFrame frame = this.fTargetFrame;
            IJavaValue value = result.getValue();
            frame.forceReturn(value);
            if (!"V".equals(value.getSignature())) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (display.isDisposed()) {
                            return;
                        }
                        IWorkbenchPart part = ForceReturnAction.this.getTargetPart();
                        InspectPopupDialog dialog = new InspectPopupDialog(ForceReturnAction.this.getShell(), ForceReturnAction.getPopupAnchor(ForceReturnAction.getStyledText(part)), null, (IExpression)new JavaInspectExpression(result));
                        dialog.open();
                    }
                });
            }
        }
        catch (DebugException e) {
            final IStatus status = e.getStatus();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (display.isDisposed()) {
                        return;
                    }
                    JDIDebugUIPlugin.statusDialog(status);
                }
            });
        }
    }

    @Override
    protected void run() {
        IJavaStackFrame stackFrame = this.getStackFrameContext();
        ForceReturnRunnable runnable = new ForceReturnRunnable(stackFrame);
        if (stackFrame != null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            try {
                workbench.getProgressService().busyCursorWhile((IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException e) {
                Status status = new Status(2, JDIDebugUIPlugin.getUniqueIdentifier(), "Force return failed", (Throwable)e);
                JDIDebugUIPlugin.log((IStatus)status);
                return;
            }
            catch (InterruptedException e) {
                return;
            }
            if (runnable.forceReturnDone) {
                return;
            }
        }
        this.fTargetFrame = stackFrame;
        super.run();
    }

    private static class ForceReturnRunnable
    implements IRunnableWithProgress {
        private final IJavaStackFrame stackFrame;
        private boolean forceReturnDone;

        private ForceReturnRunnable(IJavaStackFrame stackFrame) {
            this.stackFrame = stackFrame;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                String returnType;
                if (this.stackFrame != null && this.stackFrame.isSuspended() && !monitor.isCanceled() && "V".equals(returnType = Signature.getReturnType((String)this.stackFrame.getSignature()))) {
                    this.stackFrame.forceReturn(((IJavaDebugTarget)this.stackFrame.getDebugTarget()).voidValue());
                    this.forceReturnDone = true;
                }
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.statusDialog(e.getStatus());
                this.forceReturnDone = true;
            }
        }
    }
}

