/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.commons.ui.FillWidthLayout;
import org.eclipse.mylyn.commons.workbench.editors.CommonTextSupport;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.tasks.ui.commands.ViewSourceHandler;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractHyperlinkTextPresentationManager;
import org.eclipse.mylyn.internal.tasks.ui.editors.BrowserPreviewViewer;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.HighlightingHyperlinkTextPresentationManager;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewerConfiguration;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskHyperlinkTextPresentationManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRenderingEngine;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.themes.IThemeManager;

public class RichTextEditor {
    private static final String KEY_TEXT_VERSION = "org.eclipse.mylyn.tasks.ui.textVersion";
    private BrowserPreviewViewer browserViewer;
    private IContextActivation contextActivation;
    private final IContextService contextService;
    private Control control;
    private SourceViewer defaultViewer;
    private Composite editorComposite;
    private StackLayout editorLayout;
    private SourceViewer editorViewer;
    private final AbstractTaskEditorExtension extension;
    private RepositoryTextViewerConfiguration.Mode mode;
    private SourceViewer previewViewer;
    boolean readOnly;
    private AbstractRenderingEngine renderingEngine;
    private final TaskRepository repository;
    private boolean spellCheckingEnabled;
    private final int style;
    private FormToolkit toolkit;
    private final IAction viewSourceAction;
    private String text;
    private int textVersion;
    private final ListenerList stateChangedListeners = new ListenerList(1);
    private final ITask task;

    @Deprecated
    public RichTextEditor(TaskRepository repository, int style) {
        this(repository, style, null, null, null);
    }

    @Deprecated
    public RichTextEditor(TaskRepository repository, int style, IContextService contextService, AbstractTaskEditorExtension extension) {
        this(repository, style, contextService, extension, null);
    }

    public RichTextEditor(TaskRepository repository, int style, IContextService contextService, AbstractTaskEditorExtension extension, ITask task) {
        this.repository = repository;
        this.style = style;
        this.contextService = contextService;
        this.extension = extension;
        this.text = "";
        this.viewSourceAction = new ViewSourceAction();
        this.setMode(RepositoryTextViewerConfiguration.Mode.DEFAULT);
        this.task = task;
    }

    private SourceViewer configure(SourceViewer viewer, Document document, boolean readOnly) {
        RichTextEditor.installHyperlinkPresenter((ISourceViewer)viewer, this.repository, this.task, this.getMode());
        this.updateDocument(viewer, document, readOnly);
        if (readOnly) {
            if (this.extension != null) {
                viewer.getControl().setData("viewSourceAction", (Object)this.viewSourceAction);
                viewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent e) {
                        ViewSourceHandler.setChecked(RichTextEditor.this.getViewer() == RichTextEditor.this.defaultViewer);
                    }
                });
            }
        } else {
            this.installListeners(viewer);
            viewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        }
        CommonTextSupport.setTextViewer((Widget)viewer.getTextWidget(), (TextViewer)viewer);
        viewer.setEditable(!readOnly);
        viewer.getTextWidget().setFont(this.getFont());
        if (this.toolkit != null) {
            this.toolkit.adapt(viewer.getControl(), false, false);
        }
        EditorUtil.addScrollListener((Scrollable)viewer.getTextWidget());
        return viewer;
    }

    private void updateDocument(SourceViewer viewer, Document document, boolean readOnly) {
        if (Integer.valueOf(this.textVersion).equals(viewer.getData(KEY_TEXT_VERSION))) {
            return;
        }
        if (readOnly) {
            viewer.setDocument((IDocument)document);
        } else {
            AnnotationModel annotationModel = new AnnotationModel();
            viewer.showAnnotations(false);
            viewer.showAnnotationsOverview(false);
            DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
            SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)viewer, null, (IAnnotationAccess)annotationAccess, EditorsUI.getSharedTextColors());
            for (AnnotationPreference element : new MarkerAnnotationPreferences().getAnnotationPreferences()) {
                support.setAnnotationPreference(element);
            }
            support.install(EditorsUI.getPreferenceStore());
            viewer.getTextWidget().addDisposeListener(e1 -> support.uninstall());
            viewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
        }
        viewer.setData(KEY_TEXT_VERSION, (Object)this.textVersion);
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.toolkit = toolkit;
        int style = this.style;
        if (!this.isReadOnly() && (style & 0x10) == 0) {
            style |= 0x200;
        }
        if (this.extension != null || this.renderingEngine != null) {
            this.editorComposite = new Composite(parent, 0);
            this.editorLayout = new StackLayout(){

                protected Point computeSize(Composite composite, int hint, int hint2, boolean flushCache) {
                    return this.topControl.computeSize(hint, hint2, flushCache);
                }
            };
            this.editorComposite.setLayout((Layout)this.editorLayout);
            this.setControl((Control)this.editorComposite);
            if (this.extension != null) {
                if (this.isReadOnly()) {
                    this.editorViewer = this.extension.createViewer(this.repository, this.editorComposite, style, this.createHyperlinkDetectorContext());
                } else {
                    this.editorViewer = this.extension.createEditor(this.repository, this.editorComposite, style, this.createHyperlinkDetectorContext());
                    this.editorViewer.getTextWidget().addFocusListener(new FocusListener(){

                        public void focusGained(FocusEvent e) {
                            RichTextEditor.this.setContext();
                        }

                        public void focusLost(FocusEvent e) {
                            RichTextEditor.this.unsetContext();
                        }
                    });
                    this.editorViewer.getTextWidget().addDisposeListener(e -> this.unsetContext());
                }
                this.configure(this.editorViewer, new Document(this.getText()), this.isReadOnly());
                this.show(this.editorViewer.getControl());
            } else {
                this.defaultViewer = this.createDefaultEditor(this.editorComposite, style);
                this.configure(this.defaultViewer, new Document(this.getText()), this.isReadOnly());
                this.show(this.defaultViewer.getControl());
            }
            if (!this.isReadOnly() && (style & 0x10) == 0) {
                this.editorComposite.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            }
            this.viewSourceAction.setEnabled(true);
        } else {
            this.defaultViewer = this.createDefaultEditor(parent, style);
            this.configure(this.defaultViewer, new Document(this.getText()), this.isReadOnly());
            this.setControl(this.defaultViewer.getControl());
            this.viewSourceAction.setEnabled(false);
        }
    }

    private IAdaptable createHyperlinkDetectorContext() {
        return new IAdaptable(){

            public <T> T getAdapter(Class<T> adapter) {
                if (adapter == TaskRepository.class) {
                    return adapter.cast(RichTextEditor.this.repository);
                }
                if (adapter == ITask.class) {
                    return adapter.cast(RichTextEditor.this.task);
                }
                return null;
            }
        };
    }

    private SourceViewer createDefaultEditor(Composite parent, int styles) {
        SourceViewer defaultEditor = new SourceViewer(parent, null, styles | 0x40);
        RepositoryTextViewerConfiguration viewerConfig = new RepositoryTextViewerConfiguration(this.repository, this.task, this.isSpellCheckingEnabled() && !this.isReadOnly());
        viewerConfig.setMode(this.getMode());
        defaultEditor.configure((SourceViewerConfiguration)viewerConfig);
        return defaultEditor;
    }

    private BrowserPreviewViewer getBrowserViewer() {
        if (this.editorComposite == null || this.renderingEngine == null) {
            return null;
        }
        if (this.browserViewer == null) {
            this.browserViewer = new BrowserPreviewViewer(this.getRepository(), this.renderingEngine);
            this.browserViewer.createControl(this.editorComposite, this.toolkit);
        }
        return this.browserViewer;
    }

    public Control getControl() {
        return this.control;
    }

    public SourceViewer getDefaultViewer() {
        if (this.defaultViewer == null) {
            this.defaultViewer = this.createDefaultEditor(this.editorComposite, this.style);
            this.configure(this.defaultViewer, new Document(this.getText()), this.isReadOnly());
            this.defaultViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
            this.defaultViewer.getControl().setData("maximizeAction", this.editorViewer.getControl().getData("maximizeAction"));
            this.installMenu(this.defaultViewer.getControl(), this.editorViewer.getControl().getMenu());
        }
        return this.defaultViewer;
    }

    public SourceViewer getEditorViewer() {
        return this.editorViewer;
    }

    private Font getFont() {
        if (this.mode == RepositoryTextViewerConfiguration.Mode.DEFAULT) {
            IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
            Font font = themeManager.getCurrentTheme().getFontRegistry().get("org.eclipse.mylyn.tasks.ui.fonts.task.editor.comment");
            return font;
        }
        return EditorUtil.TEXT_FONT;
    }

    public RepositoryTextViewerConfiguration.Mode getMode() {
        return this.mode;
    }

    private SourceViewer getPreviewViewer() {
        if (this.extension == null) {
            return null;
        }
        if (this.previewViewer == null) {
            int previewViewerStyle = this.style;
            if (this.getEditorViewer() != null) {
                previewViewerStyle |= 0x200;
            }
            this.previewViewer = this.extension.createViewer(this.repository, this.editorComposite, previewViewerStyle, this.createHyperlinkDetectorContext());
            this.configure(this.previewViewer, new Document(this.getText()), true);
            this.previewViewer.getControl().setData("maximizeAction", this.editorViewer.getControl().getData("maximizeAction"));
            this.installMenu(this.previewViewer.getControl(), this.editorViewer.getControl().getMenu());
            this.previewViewer.getTextWidget().setBackground(this.editorComposite.getBackground());
        }
        return this.previewViewer;
    }

    public AbstractRenderingEngine getRenderingEngine() {
        return this.renderingEngine;
    }

    public TaskRepository getRepository() {
        return this.repository;
    }

    public String getText() {
        return this.text;
    }

    public SourceViewer getViewer() {
        if (this.editorLayout == null) {
            return this.defaultViewer;
        }
        if (this.defaultViewer != null && this.editorLayout.topControl == this.defaultViewer.getControl()) {
            return this.defaultViewer;
        }
        if (this.previewViewer != null && this.editorLayout.topControl == this.previewViewer.getControl()) {
            return this.previewViewer;
        }
        return this.editorViewer;
    }

    public IAction getViewSourceAction() {
        return this.viewSourceAction;
    }

    public boolean hasBrowser() {
        return this.renderingEngine != null;
    }

    public boolean hasPreview() {
        return this.extension != null && !this.isReadOnly();
    }

    public static RepositoryTextViewerConfiguration installHyperlinkPresenter(ISourceViewer viewer, TaskRepository repository, ITask task, RepositoryTextViewerConfiguration.Mode mode) {
        RepositoryTextViewerConfiguration configuration = new RepositoryTextViewerConfiguration(repository, task, false);
        configuration.setMode(mode);
        if (mode == RepositoryTextViewerConfiguration.Mode.DEFAULT) {
            AbstractHyperlinkTextPresentationManager manager = new HighlightingHyperlinkTextPresentationManager();
            manager.setHyperlinkDetectors(configuration.getDefaultHyperlinkDetectors(viewer, null));
            manager.install((ITextViewer)viewer);
            manager = new TaskHyperlinkTextPresentationManager();
            manager.setHyperlinkDetectors(configuration.getDefaultHyperlinkDetectors(viewer, RepositoryTextViewerConfiguration.Mode.TASK));
            manager.install((ITextViewer)viewer);
        } else if (mode == RepositoryTextViewerConfiguration.Mode.TASK_RELATION) {
            TaskHyperlinkTextPresentationManager manager = new TaskHyperlinkTextPresentationManager();
            manager.setHyperlinkDetectors(configuration.getDefaultHyperlinkDetectors(viewer, RepositoryTextViewerConfiguration.Mode.TASK_RELATION));
            manager.install((ITextViewer)viewer);
        }
        return configuration;
    }

    private void installListeners(SourceViewer viewer) {
        viewer.addTextListener(event -> {
            String value = viewer.getTextWidget().getText();
            if (!this.text.equals(value)) {
                this.text = value;
                ++this.textVersion;
                viewer.setData(KEY_TEXT_VERSION, (Object)this.textVersion);
                this.valueChanged(value);
                CommonFormUtil.ensureVisible((Control)viewer.getTextWidget());
            }
        });
        if ((this.style & 2) != 0 && this.mode != RepositoryTextViewerConfiguration.Mode.DEFAULT) {
            viewer.getTextWidget().addListener(31, event -> {
                switch (event.detail) {
                    case 8: 
                    case 16: {
                        event.doit = true;
                    }
                }
            });
        }
    }

    private void installMenu(Control control, Menu menu) {
        if (menu != null) {
            control.setMenu(menu);
            control.addDisposeListener(e -> control.setMenu(null));
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isSpellCheckingEnabled() {
        return this.spellCheckingEnabled;
    }

    private void setContext() {
        if (this.contextService == null) {
            return;
        }
        if (this.contextActivation != null) {
            this.contextService.deactivateContext(this.contextActivation);
            this.contextActivation = null;
        }
        if (this.contextService != null && this.extension.getEditorContextId() != null) {
            this.contextActivation = this.contextService.activateContext(this.extension.getEditorContextId());
        }
    }

    private void setControl(Control control) {
        this.control = control;
    }

    public void setMode(RepositoryTextViewerConfiguration.Mode mode) {
        Assert.isNotNull((Object)((Object)mode));
        this.mode = mode;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setRenderingEngine(AbstractRenderingEngine renderingEngine) {
        this.renderingEngine = renderingEngine;
    }

    public void setSpellCheckingEnabled(boolean spellCheckingEnabled) {
        this.spellCheckingEnabled = spellCheckingEnabled;
    }

    public void setText(String value) {
        this.text = value;
        ++this.textVersion;
        SourceViewer viewer = this.getViewer();
        if (viewer != null) {
            viewer.getDocument().set(value);
        }
    }

    private void show(Control control) {
        if (this.editorComposite == null) {
            return;
        }
        this.editorLayout.topControl = control;
        if (this.editorComposite.getParent().getLayout() instanceof FillWidthLayout) {
            ((FillWidthLayout)this.editorComposite.getParent().getLayout()).flush();
        }
        this.editorComposite.layout();
        control.setFocus();
        this.fireStateChangedEvent();
    }

    protected void fireStateChangedEvent() {
        Object[] listeners;
        if (this.stateChangedListeners.isEmpty()) {
            return;
        }
        StateChangedEvent event = new StateChangedEvent();
        if (this.defaultViewer != null && this.defaultViewer.getControl() == this.editorLayout.topControl) {
            event.state = State.DEFAULT;
        } else if (this.editorViewer != null && this.editorViewer.getControl() == this.editorLayout.topControl) {
            event.state = State.EDITOR;
        } else if (this.previewViewer != null && this.previewViewer.getControl() == this.editorLayout.topControl) {
            event.state = State.PREVIEW;
        } else if (this.browserViewer != null && this.browserViewer.getControl() == this.editorLayout.topControl) {
            event.state = State.BROWSER;
        }
        Object[] objectArray = listeners = this.stateChangedListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((StateChangedListener)listener).stateChanged(event);
            ++n2;
        }
    }

    private void show(SourceViewer viewer) {
        this.updateDocument(viewer, new Document(this.getText()), !viewer.isEditable());
        this.show(viewer.getControl());
    }

    public void showBrowser() {
        BrowserPreviewViewer viewer = this.getBrowserViewer();
        viewer.update(this.getText());
        if (viewer != null) {
            this.show((Control)viewer.getControl());
        }
    }

    public void showDefault() {
        this.show(this.getDefaultViewer());
    }

    public void showEditor() {
        if (this.getEditorViewer() != null) {
            this.show(this.getEditorViewer());
        } else {
            this.show(this.getDefaultViewer());
        }
    }

    private void showPreview(boolean sticky) {
        if (!this.isReadOnly() && this.getPreviewViewer() != null) {
            this.show(this.getPreviewViewer());
        }
    }

    public void showPreview() {
        this.showPreview(true);
    }

    private void unsetContext() {
        if (this.contextService == null) {
            return;
        }
        if (this.contextActivation != null) {
            this.contextService.deactivateContext(this.contextActivation);
            this.contextActivation = null;
        }
    }

    protected void valueChanged(String value) {
    }

    public void enableAutoTogglePreview() {
        if (!this.isReadOnly() && this.getPreviewViewer() != null) {
            MouseAdapter listener = new MouseAdapter(){
                private boolean toggled;

                public void mouseUp(MouseEvent e) {
                    if (!this.toggled && e.count == 1) {
                        Display.getDefault().timerExec(Display.getDefault().getDoubleClickTime(), () -> {
                            if (RichTextEditor.this.previewViewer.getTextWidget() == null || RichTextEditor.this.previewViewer.getTextWidget().isDisposed()) {
                                return;
                            }
                            if (RichTextEditor.this.previewViewer.getTextWidget().getSelectionCount() == 0) {
                                int offset = RichTextEditor.this.previewViewer.getTextWidget().getCaretOffset();
                                RichTextEditor.this.showEditor();
                                RichTextEditor.this.editorViewer.getTextWidget().setCaretOffset(offset);
                                this.toggled = true;
                            }
                        });
                    }
                }
            };
            this.previewViewer.getTextWidget().addMouseListener((MouseListener)listener);
        }
    }

    public void setBackground(Color color) {
        if (this.editorComposite != null && !this.editorComposite.isDisposed()) {
            this.editorComposite.setBackground(color);
            Control[] controlArray = this.editorComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setBackground(color);
                ++n2;
            }
        }
    }

    public void addStateChangedListener(StateChangedListener listener) {
        this.stateChangedListeners.add((Object)listener);
    }

    public void removeStateChangedListener(StateChangedListener listener) {
        this.stateChangedListeners.remove((Object)listener);
    }

    public static enum State {
        DEFAULT,
        BROWSER,
        EDITOR,
        PREVIEW;

    }

    public static class StateChangedEvent {
        public State state;
    }

    public static interface StateChangedListener {
        public void stateChanged(StateChangedEvent var1);
    }

    public class ViewSourceAction
    extends Action {
        public ViewSourceAction() {
            super(Messages.RichTextAttributeEditor_Viewer_Source, 2);
            this.setChecked(false);
            this.setEnabled(false);
        }

        public void run() {
            if (this.isChecked()) {
                RichTextEditor.this.showDefault();
            } else {
                RichTextEditor.this.showEditor();
            }
            if (RichTextEditor.this.editorLayout != null) {
                EditorUtil.reflow(RichTextEditor.this.editorLayout.topControl);
            }
            ViewSourceHandler.setChecked(this.isChecked());
        }
    }
}

