/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.pack.PackExt;

public class MidxDescList {
    private final List<DfsPackDescription> descs;

    public static MidxDescList create(DfsPackDescription[] descs) {
        return new MidxDescList(Arrays.asList(descs));
    }

    public static MidxDescList create(List<DfsPackDescription> descs) {
        return new MidxDescList(descs);
    }

    private MidxDescList(List<DfsPackDescription> descs) {
        this.descs = descs;
    }

    public Set<DfsPackDescription> findAllCoveringMidxs(DfsPackDescription pack) {
        return this.findAllCoveringMidxs(List.of(pack));
    }

    public Set<DfsPackDescription> findAllCoveringMidxs(Collection<DfsPackDescription> queryPacks) {
        if (queryPacks.isEmpty()) {
            return Collections.emptySet();
        }
        List<DfsPackDescription> knownMidxs = this.descs.stream().filter(dsc -> dsc.hasFileExt(PackExt.MULTI_PACK_INDEX)).toList();
        if (knownMidxs.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<DfsPackDescription> impactedMidxs = new HashSet<DfsPackDescription>();
        for (DfsPackDescription midx : knownMidxs) {
            ArrayList<DfsPackDescription> visitedMidxs = new ArrayList<DfsPackDescription>();
            DfsPackDescription current = midx;
            while (current != null) {
                visitedMidxs.add(current);
                if (queryPacks.contains(current) || MidxDescList.containsAny(current.getCoveredPacks(), queryPacks)) {
                    impactedMidxs.addAll(visitedMidxs);
                    visitedMidxs.clear();
                }
                current = current.getMultiPackIndexBase();
            }
            visitedMidxs.clear();
        }
        return impactedMidxs;
    }

    private static boolean containsAny(List<DfsPackDescription> inMidx, Collection<DfsPackDescription> queryPacks) {
        HashSet<DfsPackDescription> inMidxSet = new HashSet<DfsPackDescription>(inMidx);
        return queryPacks.stream().anyMatch(inMidxSet::contains);
    }
}

