/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTransferListenerAdapter {
    private static final Logger log = LoggerFactory.getLogger(AbstractTransferListenerAdapter.class);
    protected final IProgressMonitor monitor;
    protected Map<String, Long> progressMap = new ConcurrentHashMap<String, Long>();
    private static final String[] units = new String[]{Messages.AbstractTransferListenerAdapter_byte, Messages.AbstractTransferListenerAdapter_kb, Messages.AbstractTransferListenerAdapter_mb};

    protected AbstractTransferListenerAdapter(IProgressMonitor monitor) {
        this.monitor = IProgressMonitor.nullSafe((IProgressMonitor)monitor);
    }

    protected void formatBytes(long n, StringBuilder sb) {
        int i = 0;
        while (n >= 1024L && ++i < units.length) {
            n >>= 10;
        }
        sb.append(n);
        sb.append(units[i]);
    }

    protected void transferInitiated(String artifactUrl) {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException(Messages.AbstractTransferListenerAdapter_cancelled);
        }
        if (artifactUrl != null) {
            this.monitor.subTask(artifactUrl);
        }
    }

    protected void transferStarted(String artifactUrl) {
        log.info(NLS.bind((String)"Downloading {0}", (Object)artifactUrl));
        this.monitor.subTask(NLS.bind((String)Messages.AbstractTransferListenerAdapter_4, (Object)artifactUrl));
    }

    protected void transferProgress(String artifactUrl, long total, int length) throws OperationCanceledException {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException(Messages.AbstractTransferListenerAdapter_cancelled);
        }
        Long downloadProgress = this.progressMap.get(artifactUrl);
        long complete = downloadProgress == null ? 0L : downloadProgress;
        this.progressMap.put(artifactUrl, complete += (long)length);
        StringBuilder sb = new StringBuilder();
        this.formatBytes(complete, sb);
        if (total != -1L) {
            sb.append('/');
            this.formatBytes(total, sb);
            if (total > 0L) {
                sb.append(" (");
                sb.append(100L * complete / total);
                sb.append("%)");
            }
        }
        sb.append(' ');
        this.monitor.subTask(sb.toString() + artifactUrl);
    }

    protected void transferCompleted(String artifactUrl) {
        log.info(NLS.bind((String)"Downloaded {0}", (Object)artifactUrl));
        this.monitor.subTask("");
        this.progressMap.remove(artifactUrl);
    }

    protected void transferError(String artifactUrl, Exception exception) {
        log.error(NLS.bind((String)"Unable to download {0} : {1}", (Object)artifactUrl, (Object)exception));
        this.monitor.subTask(NLS.bind((String)Messages.AbstractTransferListenerAdapter_subtask, (Object)artifactUrl));
        this.progressMap.remove(artifactUrl);
    }
}

