/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.validation.eclipse;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.json.impl.schema.JSONSchemaNode;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonArray;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonObject;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonValue;
import org.eclipse.json.schema.IJSONSchemaDocument;
import org.eclipse.json.schema.IJSONSchemaProperty;
import org.eclipse.json.schema.JSONSchemaType;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.eclipse.wst.json.core.document.IJSONArray;
import org.eclipse.wst.json.core.document.IJSONDocument;
import org.eclipse.wst.json.core.document.IJSONModel;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONObject;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.json.core.document.IJSONValue;
import org.eclipse.wst.json.core.internal.schema.SchemaProcessorRegistryReader;
import org.eclipse.wst.json.core.internal.validation.JSONNestedValidatorContext;
import org.eclipse.wst.json.core.internal.validation.JSONValidationConfiguration;
import org.eclipse.wst.json.core.internal.validation.JSONValidationInfo;
import org.eclipse.wst.json.core.internal.validation.JSONValidationReport;
import org.eclipse.wst.json.core.internal.validation.core.AbstractNestedValidator;
import org.eclipse.wst.json.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.json.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.json.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.json.core.internal.validation.eclipse.JSONMessageInfoHelper;
import org.eclipse.wst.json.core.internal.validation.eclipse.JSONValidator;
import org.eclipse.wst.json.core.util.JSONUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class Validator
extends AbstractNestedValidator {
    private static final String CLOSE_BRACKET = "]";
    private static final String OPEN_BRACKET = "[";
    private static final String COMMA = ",";
    private static final String JSON_VALIDATOR_CONTEXT = "org.eclipse.wst.json.core.validatorContext";
    protected int indicateNoGrammar = 0;
    private IScopeContext[] fPreferenceScopes = null;

    @Override
    protected void setupValidation(NestedValidatorContext context) {
        super.setupValidation(context);
        this.fPreferenceScopes = this.createPreferenceScopes(context);
        this.indicateNoGrammar = Platform.getPreferencesService().getInt(JSONCorePlugin.getDefault().getBundle().getSymbolicName(), "indicateNoGrammar", 0, this.fPreferenceScopes);
    }

    protected IScopeContext[] createPreferenceScopes(NestedValidatorContext context) {
        ProjectScope projectScope;
        IProject project;
        if (context != null && (project = context.getProject()) != null && project.isAccessible() && (projectScope = new ProjectScope(project)).getNode(JSONCorePlugin.getDefault().getBundle().getSymbolicName()).getBoolean("use-project-settings", false)) {
            return new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
        }
        return new IScopeContext[]{new InstanceScope(), new DefaultScope()};
    }

    @Override
    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context) {
        return this.validate(uri, inputstream, context, null);
    }

    @Override
    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context, ValidationResult result) {
        JSONValidator validator = JSONValidator.getInstance();
        JSONValidationConfiguration configuration = new JSONValidationConfiguration();
        JSONValidationReport valreport = validator.validate(uri, inputstream, configuration, result, context);
        String prefs = JSONCorePlugin.getDefault().getBundle().getSymbolicName();
        IEclipsePreferences modelPreferences = InstanceScope.INSTANCE.getNode(prefs);
        boolean validateSchema = modelPreferences.getBoolean("schemaValidation", false);
        if (validateSchema) {
            IJSONModel model = null;
            try {
                IStructuredModel temp = this.getModel(uri);
                if (!(temp instanceof IJSONModel)) {
                    JSONValidationReport jSONValidationReport = valreport;
                    return jSONValidationReport;
                }
                model = (IJSONModel)temp;
                IJSONSchemaDocument schemaDocument = SchemaProcessorRegistryReader.getInstance().getSchemaDocument(model);
                if (schemaDocument != null) {
                    JSONValidationInfo valinfo = null;
                    valinfo = valreport instanceof JSONValidationInfo ? (JSONValidationInfo)valreport : new JSONValidationInfo(uri);
                    this.validate(model, (IJSONSchemaProperty)schemaDocument, valinfo);
                    JSONValidationReport jSONValidationReport = valreport;
                    return jSONValidationReport;
                }
            }
            catch (IOException e) {
                Validator.logWarning(e);
                JSONValidationReport jSONValidationReport = valreport;
                return jSONValidationReport;
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        return valreport;
    }

    private void validate(IJSONModel model, IJSONSchemaProperty schemaProperty, JSONValidationInfo valinfo) {
        IJSONDocument document = model.getDocument();
        IJSONNode node = document.getFirstChild();
        while (node != null) {
            this.validate(node, schemaProperty, valinfo);
            node = node.getNextSibling();
        }
    }

    private void validate(IJSONNode node, IJSONSchemaProperty schemaProperty, JSONValidationInfo valinfo) {
        if (node == null || schemaProperty == null) {
            return;
        }
        JsonObject schema = schemaProperty.getJsonObject();
        this.validate(node, schema, valinfo);
        IJSONNode child = node.getFirstChild();
        while (child != null) {
            IJSONValue value;
            IJSONSchemaProperty property = schemaProperty.getSchemaDocument().getProperty(child.getPath());
            this.validate(child, property, valinfo);
            if (child instanceof IJSONPair && (value = ((IJSONPair)child).getValue()) instanceof IJSONObject) {
                IJSONSchemaProperty prop = schemaProperty.getSchemaDocument().getProperty(value.getPath());
                this.validate((IJSONNode)value, prop, valinfo);
            }
            child = child.getNextSibling();
        }
    }

    private void validate(IJSONNode node, JsonObject schema, JSONValidationInfo valinfo) {
        for (JsonObject.Member member : schema) {
            this.validate(node, schema, member, valinfo);
        }
    }

    private void validate(IJSONNode node, JsonObject schema, JsonObject.Member member, JSONValidationInfo valinfo) {
        JsonArray jsonArray;
        if ("allOf".equals(member.getName()) && member.getValue() instanceof JsonArray) {
            jsonArray = (JsonArray)member.getValue();
            for (JsonValue value : jsonArray) {
                if (!(value instanceof JsonObject)) continue;
                this.validate(node, (JsonObject)value, valinfo);
            }
        }
        if ("anyOf".equals(member.getName()) && member.getValue() instanceof JsonArray) {
            jsonArray = (JsonArray)member.getValue();
            for (JsonValue value : jsonArray) {
                if (!(value instanceof JsonObject)) continue;
                JSONValidationInfo info = new JSONValidationInfo("");
                this.validate(node, (JsonObject)value, info);
                if (info.getValidationMessages() != null && info.getValidationMessages().length != 0) continue;
                return;
            }
            int offset = node.getStartOffset();
            int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
            valinfo.addMessage("Matches a schema that is not allowed", line, 0, offset == 0 ? 1 : offset);
        }
        if ("oneOf".equals(member.getName()) && member.getValue() instanceof JsonArray) {
            jsonArray = (JsonArray)member.getValue();
            Iterator iter = jsonArray.iterator();
            int count = 0;
            while (iter.hasNext()) {
                JsonValue value = (JsonValue)iter.next();
                if (!(value instanceof JsonObject)) continue;
                JSONValidationInfo info = new JSONValidationInfo("");
                this.validate(node, (JsonObject)value, info);
                if (info.getValidationMessages() != null && info.getValidationMessages().length != 0) continue;
                ++count;
            }
            if (count != 1) {
                int offset = node.getStartOffset();
                int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
                valinfo.addMessage("Matches a schema that is not allowed", line, 0, offset == 0 ? 1 : offset);
            }
        }
        if ("not".equals(member.getName()) && member.getValue() instanceof JsonObject) {
            JsonObject json = (JsonObject)member.getValue();
            JSONValidationInfo info = new JSONValidationInfo("");
            this.validate(node, json, info);
            if (info.getValidationMessages() == null || info.getValidationMessages().length == 0) {
                int offset = node.getStartOffset();
                int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
                valinfo.addMessage("Matches a schema that is not allowed", line, 0, offset == 0 ? 1 : offset);
            }
        }
        if ("type".equals(member.getName())) {
            this.validateType(node, member, valinfo);
        }
        if ("enum".equals(member.getName())) {
            this.validateEnum(node, schema, valinfo);
        }
        if (node.getNodeType() == 0) {
            if ("required".equals(member.getName())) {
                this.validateRequired(node, schema, valinfo);
            }
            if ("maxProperties".equals(member.getName())) {
                this.validateMaxProperties(node, schema, valinfo);
            }
            if ("minProperties".equals(member.getName())) {
                this.validateMinProperties(node, schema, valinfo);
            }
            if ("additionalProperties".equals(member.getName())) {
                this.validateAdditionalProperties(node, schema, member.getValue(), valinfo);
            }
        }
        if (node.getNodeType() == 2) {
            IJSONValue value = ((IJSONPair)node).getValue();
            JSONSchemaType[] types = JSONSchemaNode.getType((JsonValue)schema.get("type"));
            if (value != null) {
                if (value.getNodeType() == 3 && this.isType(types, JSONSchemaType.String)) {
                    this.validateString(node, schema, member, valinfo, value);
                }
                if (value.getNodeType() == 4 && (this.isType(types, JSONSchemaType.Integer) || this.isType(types, JSONSchemaType.Number))) {
                    this.validateNumber(node, schema, member, valinfo, value);
                }
                if (value.getNodeType() == 1 && this.isType(types, JSONSchemaType.Array)) {
                    this.validateArray(node, schema, member, valinfo, value);
                }
            }
        }
    }

    private void validateAdditionalProperties(IJSONNode node, JsonObject schema, JsonValue value, JSONValidationInfo valinfo) {
        if (value != null && value.isBoolean() && !value.asBoolean()) {
            Set<String> s = this.getProperties(node);
            Set<String> p = this.getProperties(schema.get("properties"));
            Set<String> pp = this.getProperties(schema.get("patternProperties"));
            for (String string : p) {
                if (!s.contains(string)) continue;
                s.remove(string);
            }
            for (String patternStr : pp) {
                Pattern pattern = Pattern.compile(patternStr);
                Iterator<String> iter = s.iterator();
                while (iter.hasNext()) {
                    Matcher matcher;
                    String ss = iter.next();
                    if (ss == null || !(matcher = pattern.matcher(ss)).find()) continue;
                    iter.remove();
                }
            }
            for (String string : s) {
                if ("$schema".equals(string)) continue;
                IJSONNode n = node.getFirstChild();
                while (n != null) {
                    IJSONPair pair;
                    if (n instanceof IJSONPair && string.equals((pair = (IJSONPair)n).getName())) break;
                    n = n.getNextSibling();
                }
                if (n == null) {
                    node = n;
                }
                int offset = n.getStartOffset();
                int line = n.getModel().getStructuredDocument().getLineOfOffset(offset);
                valinfo.addMessage("Property " + string + " is not allowed", line, 0, offset == 0 ? 1 : offset);
            }
        }
    }

    private Set<String> getProperties(JsonValue value) {
        HashSet<String> result = new HashSet<String>();
        if (value instanceof JsonObject) {
            Iterator members = ((JsonObject)value).iterator();
            while (members.hasNext()) {
                result.add(((JsonObject.Member)members.next()).getName());
            }
        }
        return result;
    }

    private void validateArray(IJSONNode node, JsonObject schema, JsonObject.Member member, JSONValidationInfo valinfo, IJSONValue value) {
        if ("items".equals(member.getName())) {
            this.validateItems(node, schema, value, member.getValue(), valinfo);
        }
        if ("maxItems".equals(member.getName())) {
            this.validateMaxItems(node, schema, value, member.getValue(), valinfo);
        }
        if ("minItems".equals(member.getName())) {
            this.validateMinItems(node, schema, value, member.getValue(), valinfo);
        }
        if ("uniqueItems".equals(member.getName())) {
            this.validateUniqueItems(node, schema, value, member.getValue(), valinfo);
        }
    }

    private void validateMaxItems(IJSONNode node, JsonObject schema, IJSONValue value, JsonValue memberValue, JSONValidationInfo valinfo) {
        int size;
        int instanceSize;
        if (memberValue != null && memberValue.isNumber() && memberValue.asInt() > 0 && value instanceof IJSONArray && (instanceSize = this.getSize((IJSONArray)value)) > (size = memberValue.asInt())) {
            int offset = node.getStartOffset();
            int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
            valinfo.addMessage("Array has too many items. Expected " + size + " or fewer", line, 0, offset == 0 ? 1 : offset);
        }
    }

    private void validateMinItems(IJSONNode node, JsonObject schema, IJSONValue value, JsonValue memberValue, JSONValidationInfo valinfo) {
        int size;
        int instanceSize;
        if (memberValue != null && memberValue.isNumber() && memberValue.asInt() > 0 && value instanceof IJSONArray && (instanceSize = this.getSize((IJSONArray)value)) < (size = memberValue.asInt())) {
            int offset = node.getStartOffset();
            int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
            valinfo.addMessage("Array has too few items. Expected " + size + " or more", line, 0, offset == 0 ? 1 : offset);
        }
    }

    private void validateUniqueItems(IJSONNode node, JsonObject schema, IJSONValue value, JsonValue memberValue, JSONValidationInfo valinfo) {
        if (memberValue != null && memberValue.isBoolean() && memberValue.asBoolean() && value instanceof IJSONArray) {
            HashSet<String> instanceValues = new HashSet<String>();
            IJSONNode child = value.getFirstChild();
            int instanceSize = 0;
            while (child != null) {
                ++instanceSize;
                instanceValues.add(JSONUtil.getString(child));
                child = child.getNextSibling();
            }
            if (instanceSize != instanceValues.size()) {
                int offset = node.getStartOffset();
                int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
                valinfo.addMessage("Array has duplicate items", line, 0, offset == 0 ? 1 : offset);
            }
        }
    }

    private void validateItems(IJSONNode node, JsonObject schema, IJSONValue value, JsonValue memberValue, JSONValidationInfo valinfo) {
        int size;
        int instanceSize;
        JsonValue additionalItems = schema.get("additionalItems");
        if (additionalItems != null && additionalItems.isBoolean() && !additionalItems.asBoolean() && memberValue != null && memberValue.isArray() && value instanceof IJSONArray && (instanceSize = this.getSize((IJSONArray)value)) > (size = memberValue.asArray().size())) {
            int offset = node.getStartOffset();
            int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
            valinfo.addMessage("Array has too many items. Expected " + size + " or fewer", line, 0, offset == 0 ? 1 : offset);
        }
    }

    private int getSize(IJSONArray instance) {
        if (instance == null) {
            return 0;
        }
        int instanceSize = 0;
        IJSONNode child = instance.getFirstChild();
        while (child != null) {
            ++instanceSize;
            child = child.getNextSibling();
        }
        return instanceSize;
    }

    private void validateNumber(IJSONNode node, JsonObject schema, JsonObject.Member member, JSONValidationInfo valinfo, IJSONValue value) {
        if ("multipleOf".equals(member.getName())) {
            this.validateMultipleOf(node, schema, value, valinfo);
        }
        if ("maximum".equals(member.getName())) {
            this.validateMaximum(node, schema, value, valinfo);
        }
        if ("minimum".equals(member.getName())) {
            this.validateMinimum(node, schema, value, valinfo);
        }
    }

    private void validateMaximum(IJSONNode node, JsonObject schema, IJSONValue valueNode, JSONValidationInfo valinfo) {
        double maximum;
        try {
            maximum = schema.getDouble("maximum", Double.MIN_VALUE);
        }
        catch (Exception exception) {
            maximum = Double.MIN_VALUE;
        }
        if (maximum > Double.MIN_VALUE) {
            boolean exclusiveMaximum;
            try {
                exclusiveMaximum = schema.getBoolean("exclusiveMaximum", false);
            }
            catch (Exception exception) {
                exclusiveMaximum = false;
            }
            String valueStr = JSONUtil.getString(valueNode);
            try {
                boolean valid;
                double value = new Double(valueStr);
                boolean bl = exclusiveMaximum ? value < maximum : (valid = value <= maximum);
                if (!valid) {
                    int offset = node.getStartOffset();
                    int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
                    if (exclusiveMaximum) {
                        valinfo.addMessage("Value is above the exclusive maximum of " + maximum, line, 0, offset == 0 ? 1 : offset);
                    } else {
                        valinfo.addMessage("Value is above the maximum of " + maximum, line, 0, offset == 0 ? 1 : offset);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
    }

    private void validateMinimum(IJSONNode node, JsonObject schema, IJSONValue valueNode, JSONValidationInfo valinfo) {
        double minimum;
        try {
            minimum = schema.getDouble("minimum", Double.MAX_VALUE);
        }
        catch (Exception exception) {
            minimum = Double.MAX_VALUE;
        }
        if (minimum < Double.MAX_VALUE) {
            boolean exclusiveMinimum;
            try {
                exclusiveMinimum = schema.getBoolean("exclusiveMinimum", false);
            }
            catch (Exception exception) {
                exclusiveMinimum = false;
            }
            String valueStr = JSONUtil.getString(valueNode);
            try {
                boolean valid;
                double value = new Double(valueStr);
                boolean bl = exclusiveMinimum ? value > minimum : (valid = value >= minimum);
                if (!valid) {
                    int offset = node.getStartOffset();
                    int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
                    if (exclusiveMinimum) {
                        valinfo.addMessage("Value is below the exclusive minimum of " + minimum, line, 0, offset == 0 ? 1 : offset);
                    } else {
                        valinfo.addMessage("Value is below the minimum of " + minimum, line, 0, offset == 0 ? 1 : offset);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
    }

    private void validateMultipleOf(IJSONNode node, JsonObject schema, IJSONValue valueNode, JSONValidationInfo valinfo) {
        int multipleOff;
        try {
            multipleOff = schema.getInt("multipleOf", -1);
        }
        catch (Exception exception) {
            multipleOff = -1;
        }
        if (multipleOff > 0) {
            double n;
            String value = JSONUtil.getString(valueNode);
            try {
                n = new Double(value);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            long div = Math.round(n / (double)multipleOff);
            if (Math.abs((double)(div * (long)multipleOff) - n) > 1.0E-12) {
                int offset = node.getStartOffset();
                int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
                valinfo.addMessage("Value is not divisible by " + multipleOff, line, 0, offset == 0 ? 1 : offset);
            }
        }
    }

    private boolean isType(JSONSchemaType[] types, JSONSchemaType type) {
        JSONSchemaType[] jSONSchemaTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            JSONSchemaType t = jSONSchemaTypeArray[n2];
            if (t == type) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void validateString(IJSONNode node, JsonObject schema, JsonObject.Member member, JSONValidationInfo valinfo, IJSONValue value) {
        if ("minLength".equals(member.getName())) {
            this.validateMinLength(node, schema, value, valinfo);
        }
        if ("maxLength".equals(member.getName())) {
            this.validateMaxLength(node, schema, value, valinfo);
        }
        if ("pattern".equals(member.getName())) {
            this.validatePattern(node, schema, value, valinfo);
        }
    }

    private void validateMaxLength(IJSONNode node, JsonObject schema, IJSONValue valueNode, JSONValidationInfo valinfo) {
        int maxLength;
        try {
            maxLength = schema.getInt("maxLength", -1);
        }
        catch (Exception exception) {
            maxLength = -1;
        }
        if (maxLength >= 0) {
            boolean valid;
            String value = JSONUtil.getString(valueNode);
            boolean bl = valid = value == null || value.length() <= maxLength;
            if (!valid) {
                int offset = node.getStartOffset();
                int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
                valinfo.addMessage("String is longer than the maximum length of " + maxLength, line, 0, offset == 0 ? 1 : offset);
            }
        }
    }

    private void validateMinLength(IJSONNode node, JsonObject schema, IJSONValue valueNode, JSONValidationInfo valinfo) {
        int minLength;
        try {
            minLength = schema.getInt("minLength", -1);
        }
        catch (Exception exception) {
            minLength = -1;
        }
        if (minLength >= 0) {
            boolean valid;
            String value = JSONUtil.getString(valueNode);
            boolean bl = valid = value == null || value.length() >= minLength;
            if (!valid) {
                int offset = node.getStartOffset();
                int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
                valinfo.addMessage("String is shorter than the minimum length of " + minLength, line, 0, offset == 0 ? 1 : offset);
            }
        }
    }

    private void validatePattern(IJSONNode node, JsonObject schema, IJSONValue valueNode, JSONValidationInfo valinfo) {
        Pattern pattern;
        Matcher matcher;
        String value;
        String patternStr;
        try {
            patternStr = schema.getString("pattern", null);
        }
        catch (Exception exception) {
            patternStr = null;
        }
        if (patternStr != null && (value = JSONUtil.getString(valueNode)) != null && !(matcher = (pattern = Pattern.compile(patternStr)).matcher(value)).matches()) {
            int offset = node.getStartOffset();
            int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
            valinfo.addMessage("String does not match the pattern of " + patternStr, line, 0, offset == 0 ? 1 : offset);
        }
    }

    private void validateType(IJSONNode node, JsonObject.Member member, JSONValidationInfo valinfo) {
        if ("type".equals(member.getName())) {
            HashSet<String> types = new HashSet<String>();
            if (member.getValue().isString()) {
                types.add(member.getValue().asString());
            } else if (member.getValue().isArray()) {
                JsonArray array = (JsonArray)member.getValue();
                for (JsonValue item : array) {
                    types.add(item.asString());
                }
            }
            boolean valid = false;
            for (String type : types) {
                if (node.getNodeType() == 0 && JSONSchemaType.Object.getName().equals(type)) {
                    valid = true;
                    break;
                }
                if (node.getNodeType() != 2) continue;
                IJSONValue value = ((IJSONPair)node).getValue();
                if (value == null && JSONSchemaType.Null.getName().equals(type)) {
                    valid = true;
                    break;
                }
                if (value == null) {
                    valid = false;
                    break;
                }
                if (value.getNodeType() == 0 && JSONSchemaType.Object.getName().equals(type)) {
                    valid = true;
                    break;
                }
                if (value.getNodeType() == 3 && JSONSchemaType.String.getName().equals(type)) {
                    valid = true;
                    break;
                }
                if (value.getNodeType() == 1 && JSONSchemaType.Array.getName().equals(type)) {
                    valid = true;
                    break;
                }
                if (value.getNodeType() == 5 && JSONSchemaType.Boolean.getName().equals(type)) {
                    valid = true;
                    break;
                }
                if (value.getNodeType() == 6 && JSONSchemaType.Null.getName().equals(type)) {
                    valid = true;
                    break;
                }
                if (value.getNodeType() == 4 && JSONSchemaType.Number.getName().equals(type)) {
                    valid = true;
                    break;
                }
                if (value.getNodeType() != 4 || !JSONSchemaType.Integer.getName().equals(type)) continue;
                valid = true;
                break;
            }
            if (!valid) {
                int offset = node.getStartOffset();
                int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
                StringBuffer buffer = new StringBuffer();
                Iterator iter = types.iterator();
                buffer.append(OPEN_BRACKET);
                while (iter.hasNext()) {
                    buffer.append((String)iter.next());
                    if (!iter.hasNext()) continue;
                    buffer.append(COMMA);
                }
                buffer.append(CLOSE_BRACKET);
                valinfo.addMessage("Incorrect type. Expected " + buffer.toString(), line, 0, offset == 0 ? 1 : offset);
            }
        }
    }

    private void validateEnum(IJSONNode node, JsonObject schema, JSONValidationInfo valinfo) {
        JsonValue value = schema.get("enum");
        if (value instanceof JsonArray) {
            IJSONPair pair;
            String v;
            JsonArray array = value.asArray();
            Iterator iter = array.iterator();
            HashSet<String> values = new HashSet<String>();
            while (iter.hasNext()) {
                String v2 = ((JsonValue)iter.next()).toString();
                values.add(JSONUtil.removeQuote(v2));
            }
            if (node instanceof IJSONPair && !values.contains(v = JSONUtil.getString((pair = (IJSONPair)node).getValue()))) {
                int offset = node.getStartOffset();
                int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
                valinfo.addMessage("Value is not an accepted value. Valid values " + String.valueOf(values) + "'", line, 0, offset == 0 ? 1 : offset);
            }
        }
    }

    private void validateRequired(IJSONNode node, JsonObject schema, JSONValidationInfo valinfo) {
        JsonValue required = schema.get("required");
        if (required instanceof JsonArray) {
            JsonArray array = required.asArray();
            Iterator iter = array.iterator();
            HashSet<String> values = new HashSet<String>();
            while (iter.hasNext()) {
                JsonValue v = (JsonValue)iter.next();
                if (!v.isString()) continue;
                values.add(v.asString());
            }
            Set<String> properties = this.getProperties(node);
            for (String property : properties) {
                if (property == null || !values.contains(property)) continue;
                values.remove(property);
            }
            for (String value : values) {
                int offset = node.getStartOffset();
                int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
                valinfo.addMessage("Missing property '" + value + "'", line, 0, offset == 0 ? 1 : offset);
            }
        }
    }

    private void validateMinProperties(IJSONNode node, JsonObject schema, JSONValidationInfo valinfo) {
        Set<String> properties;
        int value;
        try {
            value = schema.getInt("minProperties", -1);
        }
        catch (Exception exception) {
            value = -1;
        }
        if (value >= 0 && (properties = this.getProperties(node)).size() < value) {
            int offset = node.getStartOffset();
            int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
            valinfo.addMessage("Object has fewer properties than the required number of" + value, line, 0, offset == 0 ? 1 : offset);
        }
    }

    private void validateMaxProperties(IJSONNode node, JsonObject schema, JSONValidationInfo valinfo) {
        Set<String> properties;
        int value;
        try {
            value = schema.getInt("maxProperties", -1);
        }
        catch (Exception exception) {
            value = -1;
        }
        if (value >= 0 && (properties = this.getProperties(node)).size() > value) {
            int offset = node.getStartOffset();
            int line = node.getModel().getStructuredDocument().getLineOfOffset(offset);
            valinfo.addMessage("Object has more properties than limit of" + value, line, 0, offset == 0 ? 1 : offset);
        }
    }

    private Set<String> getProperties(IJSONNode node) {
        HashSet<String> properties = new HashSet<String>();
        IJSONNode child = node.getFirstChild();
        while (child != null) {
            IJSONPair pair;
            if (child instanceof IJSONPair && (pair = (IJSONPair)child).getName() != null) {
                properties.add(pair.getName());
            }
            child = child.getNextSibling();
        }
        return properties;
    }

    protected IStructuredModel getModel(String uriString) {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            Validator.logWarning(e);
            return null;
        }
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
        if (files == null || files.length <= 0 || !files[0].exists()) {
            return null;
        }
        IFile file = files[0];
        IModelManager manager = StructuredModelManager.getModelManager();
        if (manager == null) {
            return null;
        }
        IStructuredModel model = null;
        try {
            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Validator.logWarning((Exception)((Object)e));
        }
        try {
            try {
                model = manager.getModelForRead(file);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                model = manager.getModelForRead(file, new String(), null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
        }
        catch (CoreException e) {
            Validator.logWarning((Exception)((Object)e));
        }
        return model;
    }

    private static void logWarning(Exception e) {
        Status status = new Status(2, "org.eclipse.wst.json.core", e.getMessage(), (Throwable)e);
        JSONCorePlugin.getDefault().getLog().log((IStatus)status);
    }

    @Override
    protected void addInfoToMessage(ValidationMessage validationMessage, IMessage message) {
        String key = validationMessage.getKey();
        if (key != null) {
            JSONMessageInfoHelper messageInfoHelper = new JSONMessageInfoHelper();
            messageInfoHelper.createMessageInfo(key, validationMessage.getMessageArguments());
            message.setAttribute("columnNumber", (Object)new Integer(validationMessage.getColumnNumber()));
        }
    }

    @Override
    protected NestedValidatorContext getNestedContext(ValidationState state, boolean create) {
        JSONNestedValidatorContext context = null;
        Object o = state.get(JSON_VALIDATOR_CONTEXT);
        if (o instanceof JSONNestedValidatorContext) {
            context = (JSONNestedValidatorContext)o;
        } else if (create) {
            context = new JSONNestedValidatorContext();
        }
        return context;
    }

    public void validationStarting(IProject project, ValidationState state, IProgressMonitor monitor) {
        if (project != null) {
            NestedValidatorContext context = this.getNestedContext(state, false);
            if (context == null) {
                context = this.getNestedContext(state, true);
                if (context != null) {
                    context.setProject(project);
                }
                this.setupValidation(context);
                state.put(JSON_VALIDATOR_CONTEXT, (Object)context);
            }
            super.validationStarting(project, state, monitor);
        }
    }

    public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
        if (project != null) {
            super.validationFinishing(project, state, monitor);
            NestedValidatorContext context = this.getNestedContext(state, false);
            if (context != null) {
                this.teardownValidation(context);
                state.put(JSON_VALIDATOR_CONTEXT, null);
            }
        }
    }
}

