/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.xnavigate;

import java.net.URL;
import java.util.logging.Level;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.plugin.internal.UiPluginConstants;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class XNavigateUrlItem
extends XNavigateItemAction {
    private final String url;
    private final boolean external;

    public XNavigateUrlItem(XNavigateItem parent, String name, String url, boolean external) {
        this(parent, name, url, external, PluginUiImage.URL);
    }

    public XNavigateUrlItem(XNavigateItem parent, String name, String url, boolean external, KeyedImage oseeImage) {
        super(parent, name, oseeImage);
        this.url = url;
        this.external = external;
    }

    @Override
    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        if (this.external) {
            Program.launch((String)this.url);
        } else {
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            try {
                IWebBrowser browser = browserSupport.createBrowser("osee.ats.navigator.browser");
                browser.openURL(new URL(this.url));
            }
            catch (Exception ex) {
                OseeLog.log(UiPluginConstants.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    }
}

