/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserRoutine;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementCompound;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSchema;
import org.hsqldb.StatementSchemaDefinition;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.TableUtil;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.Token;
import org.hsqldb.TriggerDef;
import org.hsqldb.TriggerDefSQL;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;
import org.hsqldb.store.BaseHashMap;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;
import org.hsqldb.types.UserTypeModifier;

public class ParserDDL
extends ParserRoutine {
    static final int[] schemaCommands = new int[]{55, 121};
    static final short[] startStatementTokens = new short[]{55, 121, 4, 88};
    static final short[] startStatementTokensSchema = new short[]{55, 121};

    ParserDDL(Session session, Scanner scanner) {
        super(session, scanner);
    }

    @Override
    void reset(String string) {
        super.reset(string);
    }

    StatementSchema compileCreate() {
        int n = 4;
        boolean bl = false;
        boolean bl2 = false;
        this.read();
        switch (this.token.tokenType) {
            case 120: {
                this.read();
                this.readThis(523);
                this.readIfThis(607);
                this.readThis(278);
                bl = true;
                n = 3;
                break;
            }
            case 630: {
                this.read();
                this.readThis(278);
                bl = true;
                n = 3;
                break;
            }
            case 523: {
                this.read();
                this.readThis(278);
                bl = true;
                n = 3;
                break;
            }
            case 607: {
                this.read();
                this.readThis(278);
                bl = true;
                break;
            }
            case 570: {
                this.read();
                this.readThis(278);
                bl = true;
                n = 5;
                break;
            }
            case 631: {
                this.read();
                this.readThis(278);
                bl = true;
                n = 7;
                break;
            }
            case 278: {
                this.read();
                bl = true;
                n = this.database.schemaManager.getDefaultTableType();
                break;
            }
            case 197: {
                if (!this.database.sqlSyntaxOra) break;
                this.read();
                this.readThis(718);
                switch (this.token.tokenType) {
                    case 117: 
                    case 215: 
                    case 291: 
                    case 535: 
                    case 545: {
                        break;
                    }
                    default: {
                        throw this.unexpectedToken("OR");
                    }
                }
                bl2 = true;
            }
        }
        if (bl) {
            return this.compileCreateTable(n);
        }
        switch (this.token.tokenType) {
            case 558: {
                return this.compileCreateAlias();
            }
            case 505: {
                return this.compileCreateSequence();
            }
            case 497: {
                return this.compileCreateSchema();
            }
            case 291: {
                return this.compileCreateTrigger(bl2);
            }
            case 305: {
                return this.compileCreateUser();
            }
            case 490: {
                return this.compileCreateRole();
            }
            case 545: {
                return this.compileCreateView(false, bl2);
            }
            case 393: {
                return this.compileCreateDomain();
            }
            case 535: {
                return this.compileCreateType(bl2);
            }
            case 35: {
                return this.compileCreateCharacterSet();
            }
            case 358: {
                return this.compileCreateCollation();
            }
            case 299: {
                this.read();
                this.checkIsThis(597);
                return this.compileCreateIndex(true);
            }
            case 597: {
                return this.compileCreateIndex(false);
            }
            case 117: 
            case 215: 
            case 559: {
                return this.compileCreateProcedureOrFunction(bl2);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlter() {
        this.read();
        switch (this.token.tokenType) {
            case 597: {
                this.read();
                HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(20, true);
                hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                if (this.token.tokenType == 622) {
                    this.read();
                    this.readThis(285);
                    return this.compileRenameObject(hsqlName, 20);
                }
                this.readThis(10);
                Index index = (Index)this.database.schemaManager.getSchemaObject(hsqlName);
                if (index == null) {
                    throw Error.error(5501);
                }
                Table table = (Table)this.database.schemaManager.getSchemaObject(index.getName().parent);
                int[] nArray = this.readColumnList(table, true);
                String string = this.getLastPart();
                Object[] objectArray = new Object[]{table, nArray, index.getName()};
                HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
                return new StatementSchema(string, 1069, objectArray, null, hsqlNameArray);
            }
            case 497: {
                this.read();
                HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
                this.readThis(622);
                this.readThis(285);
                return this.compileRenameObject(hsqlName, 2);
            }
            case 348: {
                this.read();
                this.checkIsSimpleName();
                String string = this.token.tokenString;
                this.checkValidCatalogName(string);
                this.read();
                this.readThis(622);
                this.readThis(285);
                return this.compileRenameObject(this.database.getCatalogName(), 1);
            }
            case 505: {
                return this.compileAlterSequence();
            }
            case 278: {
                return this.compileAlterTable();
            }
            case 305: {
                return this.compileAlterUser();
            }
            case 393: {
                return this.compileAlterDomain();
            }
            case 545: {
                return this.compileCreateView(true, false);
            }
            case 508: {
                return this.compileAlterSession();
            }
            case 259: {
                return this.compileAlterSpecificRoutine();
            }
            case 491: {
                return this.compileAlterRoutine();
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterRoutine() {
        this.readThis(491);
        RoutineSchema routineSchema = (RoutineSchema)this.readSchemaObjectName(18);
        this.readThis(622);
        this.readThis(285);
        return this.compileRenameObject(routineSchema.getName(), routineSchema.getName().type);
    }

    Statement compileDrop() {
        HsqlNameManager.HsqlName[] hsqlNameArray;
        SchemaObject schemaObject;
        int n;
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        this.read();
        int n3 = this.token.tokenType;
        switch (n3) {
            case 597: {
                this.read();
                n2 = 1077;
                n = 20;
                bl3 = true;
                break;
            }
            case 339: {
                this.read();
                n2 = 24;
                n = 6;
                bl = true;
                break;
            }
            case 259: {
                this.read();
                switch (this.token.tokenType) {
                    case 117: 
                    case 215: 
                    case 491: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                n2 = 30;
                n = 24;
                bl = true;
                bl3 = true;
                break;
            }
            case 215: {
                this.read();
                n2 = 30;
                n = 17;
                bl = true;
                bl3 = true;
                break;
            }
            case 117: {
                this.read();
                n2 = 30;
                n = 16;
                bl = true;
                bl3 = true;
                break;
            }
            case 497: {
                this.read();
                n2 = 31;
                n = 2;
                bl = true;
                bl3 = true;
                break;
            }
            case 505: {
                this.read();
                n2 = 135;
                n = 7;
                bl = true;
                bl3 = true;
                break;
            }
            case 291: {
                this.read();
                n2 = 34;
                n = 8;
                bl = false;
                bl3 = true;
                break;
            }
            case 305: {
                this.read();
                n2 = 1079;
                n = 11;
                bl = true;
                break;
            }
            case 490: {
                this.read();
                n2 = 29;
                n = 11;
                bl = true;
                break;
            }
            case 393: {
                this.read();
                n2 = 27;
                n = 13;
                bl = true;
                bl3 = true;
                break;
            }
            case 535: {
                this.read();
                n2 = 35;
                n = 12;
                bl = true;
                bl3 = true;
                break;
            }
            case 35: {
                this.read();
                this.readThis(254);
                n2 = 25;
                n = 14;
                bl = false;
                bl3 = true;
                break;
            }
            case 358: {
                this.read();
                n2 = 26;
                n = 15;
                bl = false;
                bl3 = true;
                break;
            }
            case 545: {
                this.read();
                n2 = 36;
                n = 4;
                bl = true;
                bl3 = true;
                break;
            }
            case 278: {
                this.read();
                n2 = 32;
                n = 3;
                bl = true;
                bl3 = true;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        if (bl3 && this.token.tokenType == 412) {
            int n4 = this.getPosition();
            this.read();
            if (this.token.tokenType == 101) {
                this.read();
                bl4 = true;
            } else {
                this.rewind(n4);
            }
        }
        this.checkIsIdentifier();
        HsqlNameManager.HsqlName hsqlName = null;
        switch (n3) {
            case 305: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                schemaObject = this.database.getUserManager().get(this.token.tokenString);
                this.read();
                break;
            }
            case 490: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                schemaObject = this.database.getGranteeManager().getRole(this.token.tokenString);
                this.read();
                break;
            }
            case 497: {
                hsqlName = this.readNewSchemaName();
                schemaObject = this.database.schemaManager.findSchema(hsqlName.name);
                break;
            }
            case 278: {
                boolean bl5;
                boolean bl6 = bl5 = this.token.namePrePrefix == null && ("MODULE".equals(this.token.namePrefix) || "SESSION".equals(this.token.namePrefix));
                if (bl5) {
                    hsqlName = this.readNewSchemaObjectName(n, false);
                    Object[] objectArray = new Object[]{hsqlName, bl4};
                    return new StatementSession(32, objectArray);
                }
            }
            default: {
                hsqlName = this.readNewSchemaObjectName(n, false);
                hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                schemaObject = this.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, hsqlName.type);
            }
        }
        if (!bl4 && bl3 && this.token.tokenType == 412) {
            this.read();
            this.readThis(101);
            bl4 = true;
        }
        if (bl) {
            if (this.token.tokenType == 347) {
                bl2 = true;
                this.read();
            } else if (this.token.tokenType == 485) {
                this.read();
            }
        }
        if (schemaObject == null) {
            hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        } else {
            hsqlName = schemaObject.getName();
            hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(hsqlName);
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, new Integer(n), bl2, bl4};
        StatementSchema statementSchema = new StatementSchema(string, n2, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    Statement compileAlterTable() {
        this.read();
        String string = this.token.tokenString;
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(hsqlName);
        Table table = this.database.schemaManager.getUserTable(this.session, string, hsqlName.name);
        this.read();
        switch (this.token.tokenType) {
            case 622: {
                this.read();
                this.readThis(285);
                return this.compileRenameObject(table.getName(), 3);
            }
            case 334: {
                this.read();
                HsqlNameManager.HsqlName hsqlName2 = null;
                if (this.token.tokenType == 48) {
                    this.read();
                    hsqlName2 = this.readNewDependentSchemaObjectName(table.getName(), 5);
                }
                switch (this.token.tokenType) {
                    case 113: {
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableAddForeignKeyConstraint(table, hsqlName2);
                    }
                    case 299: {
                        this.read();
                        return this.compileAlterTableAddUniqueConstraint(table, hsqlName2);
                    }
                    case 37: {
                        this.read();
                        return this.compileAlterTableAddCheckConstraint(table, hsqlName2);
                    }
                    case 214: {
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableAddPrimaryKey(table, hsqlName2);
                    }
                    case 43: {
                        if (hsqlName2 != null) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.checkIsSimpleName();
                        return this.compileAlterTableAddColumn(table);
                    }
                }
                if (hsqlName2 != null) {
                    throw this.unexpectedToken();
                }
                this.checkIsSimpleName();
                return this.compileAlterTableAddColumn(table);
            }
            case 88: {
                this.read();
                switch (this.token.tokenType) {
                    case 214: {
                        boolean bl = false;
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableDropPrimaryKey(table);
                    }
                    case 48: {
                        this.read();
                        return this.compileAlterTableDropConstraint(table);
                    }
                    case 43: {
                        this.read();
                    }
                }
                this.checkIsSimpleName();
                String string2 = this.token.tokenString;
                boolean bl = false;
                this.read();
                if (this.token.tokenType == 485) {
                    this.read();
                } else if (this.token.tokenType == 347) {
                    this.read();
                    bl = true;
                }
                return this.compileAlterTableDropColumn(table, string2, bl);
            }
            case 4: {
                this.read();
                if (this.token.tokenType == 43) {
                    this.read();
                }
                int n = table.getColumnIndex(this.token.tokenString);
                ColumnSchema columnSchema = table.getColumn(n);
                this.read();
                return this.compileAlterColumn(table, columnSchema, n);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileAlterTableDropConstraint(Table table) {
        boolean bl = false;
        SchemaObject schemaObject = this.readSchemaObjectName(table.getSchemaName(), 5);
        if (this.token.tokenType == 485) {
            this.read();
        } else if (this.token.tokenType == 347) {
            this.read();
            bl = true;
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{schemaObject.getName(), ValuePool.getInt(5), bl, false};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        HsqlNameManager.HsqlName hsqlName = ((Constraint)schemaObject).getMainTableName();
        if (hsqlName != null && hsqlName != table.getName()) {
            hsqlNameArray = (HsqlNameManager.HsqlName[])ArrayUtil.toAdjustedArray(hsqlNameArray, hsqlName, hsqlNameArray.length, 1);
        }
        StatementSchema statementSchema = new StatementSchema(string, 1078, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    private Statement compileAlterTableDropPrimaryKey(Table table) {
        boolean bl = false;
        if (this.token.tokenType == 485) {
            this.read();
        } else if (this.token.tokenType == 347) {
            this.read();
            bl = true;
        }
        if (!table.hasPrimaryKey()) {
            throw Error.error(5501);
        }
        String string = this.getLastPart();
        Constraint constraint = table.getPrimaryConstraint();
        Object[] objectArray = new Object[]{constraint.getName(), ValuePool.getInt(5), bl, false};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        StatementSchema statementSchema = new StatementSchema(string, 1078, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    StatementSession compileDeclareLocalTableOrNull() {
        int n = super.getPosition();
        try {
            this.readThis(77);
            this.readThis(157);
            this.readThis(523);
            this.readThis(278);
        }
        catch (HsqlException hsqlException) {
            this.lastError = hsqlException;
            this.rewind(n);
            return null;
        }
        if (this.token.namePrePrefix != null || this.token.namePrefix != null && !"MODULE".equals(this.token.namePrefix) && !"SESSION".equals(this.token.namePrefix)) {
            throw this.unexpectedToken();
        }
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(3, false);
        hsqlName.schema = SqlInvariants.MODULE_HSQLNAME;
        Table table = new Table(this.database, hsqlName, 3);
        StatementSchema statementSchema = this.compileCreateTableBody(table, false);
        HsqlArrayList hsqlArrayList = (HsqlArrayList)statementSchema.arguments[1];
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Constraint constraint = (Constraint)hsqlArrayList.get(i);
            if (constraint.getConstraintType() != 0) continue;
            throw this.unexpectedToken("FOREIGN");
        }
        StatementSession statementSession = new StatementSession(1068, statementSchema.arguments);
        return statementSession;
    }

    StatementSchema compileCreateTable(int n) {
        Table table;
        boolean bl = false;
        if (this.token.tokenType == 412) {
            int n2 = this.getPosition();
            this.read();
            if (this.token.tokenType == 183) {
                this.read();
                this.readThis(101);
                bl = true;
            } else {
                this.rewind(n2);
            }
        }
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(3, false);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        switch (n) {
            case 6: 
            case 7: {
                table = new TextTable(this.database, hsqlName, n);
                break;
            }
            default: {
                table = new Table(this.database, hsqlName, n);
            }
        }
        return this.compileCreateTableBody(table, bl);
    }

    StatementSchema compileCreateTableBody(Table table, boolean bl) {
        Object[] objectArray;
        Object[] objectArray2;
        int n;
        Object object;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        if (this.token.tokenType == 10) {
            return this.readTableAsSubqueryDefinition(table);
        }
        int n2 = this.getPosition();
        this.readThis(786);
        Constraint constraint = new Constraint(null, null, 5);
        hsqlArrayList.add(constraint);
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        block6: while (!bl4) {
            switch (this.token.tokenType) {
                case 154: {
                    object = this.readLikeTable(table);
                    for (n = 0; n < ((ColumnSchema[])object).length; ++n) {
                        table.addColumn((ColumnSchema)object[n]);
                    }
                    bl2 = false;
                    bl3 = false;
                    continue block6;
                }
                case 37: 
                case 48: 
                case 113: 
                case 214: 
                case 299: {
                    if (!bl3) {
                        throw this.unexpectedToken();
                    }
                    this.readConstraint(table, hsqlArrayList);
                    bl2 = false;
                    bl3 = false;
                    continue block6;
                }
                case 774: {
                    if (bl3) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    bl3 = true;
                    continue block6;
                }
                case 772: {
                    this.read();
                    bl4 = true;
                    continue block6;
                }
            }
            if (!bl3) {
                throw this.unexpectedToken();
            }
            this.checkIsSchemaObjectName();
            object = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
            this.read();
            ColumnSchema columnSchema = this.readColumnDefinitionOrNull(table, (HsqlNameManager.HsqlName)object, hsqlArrayList);
            if (columnSchema == null) {
                if (bl2) {
                    this.rewind(n2);
                    return this.readTableAsSubqueryDefinition(table);
                }
                throw Error.error(5000);
            }
            table.addColumn(columnSchema);
            bl2 = false;
            bl3 = false;
        }
        if (this.token.tokenType == 194) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(44);
            if (this.token.tokenType != 79 && this.token.tokenType == 476) {
                table.persistenceScope = 23;
            }
            this.read();
            this.readThis(245);
        }
        object = new OrderedHashSet();
        ((HashSet)object).add(this.database.getCatalogName());
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            Table table2;
            objectArray2 = (Object[])hsqlArrayList.get(n);
            objectArray = objectArray2.getMainTableName();
            if (objectArray == null || (table2 = this.database.schemaManager.findUserTable(null, objectArray.name, objectArray.schema.name)) == null || table2.isTemp()) continue;
            ((HashSet)object).add(table.getName());
        }
        String string = this.getLastPart();
        objectArray2 = new Object[]{table, hsqlArrayList, null, bl};
        objectArray = new HsqlNameManager.HsqlName[((BaseHashMap)object).size()];
        ((OrderedHashSet)object).toArray(objectArray);
        return new StatementSchema(string, 77, objectArray2, null, (HsqlNameManager.HsqlName[])objectArray);
    }

    private ColumnSchema[] readLikeTable(Table table) {
        this.read();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Table table2 = this.readTableName();
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        while (true) {
            boolean bl4;
            boolean bl5 = bl4 = this.token.tokenType == 416;
            if (!bl4 && this.token.tokenType != 399) break;
            this.read();
            switch (this.token.tokenType) {
                case 407: {
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    bl = bl4;
                    break;
                }
                case 128: {
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    bl2 = bl4;
                    break;
                }
                case 381: {
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    bl3 = bl4;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            this.read();
        }
        ColumnSchema[] columnSchemaArray = new ColumnSchema[table2.getColumnCount()];
        for (int i = 0; i < columnSchemaArray.length; ++i) {
            ColumnSchema columnSchema = table2.getColumn(i).duplicate();
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnSchemaHsqlName(table.getName(), columnSchema.getName());
            columnSchema.setName(hsqlName);
            columnSchema.setNullable(true);
            columnSchema.setPrimaryKey(false);
            if (bl2) {
                if (columnSchema.isIdentity()) {
                    columnSchema.setIdentity(columnSchema.getIdentitySequence().duplicate());
                }
            } else {
                columnSchema.setIdentity(null);
            }
            if (!bl3) {
                columnSchema.setDefaultExpression(null);
            }
            if (!bl) {
                columnSchema.setGeneratingExpression(null);
            }
            columnSchemaArray[i] = columnSchema;
        }
        return columnSchemaArray;
    }

    StatementSchema readTableAsSubqueryDefinition(Table table) {
        HsqlNameManager.HsqlName[] hsqlNameArray = null;
        boolean bl = true;
        HsqlNameManager.HsqlName[] hsqlNameArray2 = null;
        StatementQuery statementQuery = null;
        if (this.token.tokenType == 786) {
            hsqlNameArray2 = this.readColumnNames(table.getName());
        }
        this.readThis(10);
        this.readThis(786);
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session);
        this.readThis(772);
        this.readThis(319);
        if (this.token.tokenType == 180) {
            this.read();
            bl = false;
        } else if (table.getTableType() == 7) {
            throw this.unexpectedTokenRequire("NO");
        }
        this.readThis(378);
        if (this.token.tokenType == 194) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(44);
            if (this.token.tokenType != 79 && this.token.tokenType == 476) {
                table.persistenceScope = 23;
            }
            this.read();
            this.readThis(245);
        }
        if (hsqlNameArray2 == null) {
            hsqlNameArray2 = queryExpression.getResultColumnNames();
        } else if (hsqlNameArray2.length != queryExpression.getColumnCount()) {
            throw Error.error(5593);
        }
        TableUtil.setColumnsInSchemaTable(table, hsqlNameArray2, queryExpression.getColumnTypes());
        table.createPrimaryKey();
        if (table.isTemp() && table.hasLobColumn()) {
            throw Error.error(5534);
        }
        if (bl) {
            statementQuery = new StatementQuery(this.session, queryExpression, this.compileContext);
            hsqlNameArray = statementQuery.getTableNamesForRead();
        }
        Object[] objectArray = new Object[]{table, new HsqlArrayList(), statementQuery, Boolean.FALSE};
        String string = this.getLastPart();
        HsqlNameManager.HsqlName[] hsqlNameArray3 = this.database.schemaManager.catalogNameArray;
        StatementSchema statementSchema = new StatementSchema(string, 77, objectArray, hsqlNameArray, hsqlNameArray3);
        return statementSchema;
    }

    static Table addTableConstraintDefinitions(Session session, Table table, HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2, boolean bl) {
        Constraint constraint = (Constraint)hsqlArrayList.get(0);
        String string = constraint.getName() == null ? null : constraint.getName().name;
        HsqlNameManager.HsqlName hsqlName = session.database.nameManager.newAutoName("IDX", string, table.getSchemaName(), table.getName(), 20);
        constraint.setColumnsIndexes(table);
        table.createPrimaryKey(hsqlName, constraint.core.mainCols, true);
        if (constraint.core.mainCols != null) {
            Constraint constraint2 = new Constraint(constraint.getName(), table, table.getPrimaryIndex(), 4);
            table.addConstraint(constraint2);
            if (bl) {
                session.database.schemaManager.addSchemaObject(constraint2);
            }
        }
        block7: for (int i = 1; i < hsqlArrayList.size(); ++i) {
            constraint = (Constraint)hsqlArrayList.get(i);
            switch (constraint.constType) {
                case 2: {
                    constraint.setColumnsIndexes(table);
                    if (table.getUniqueConstraintForColumns(constraint.core.mainCols) != null) {
                        throw Error.error(5522);
                    }
                    hsqlName = session.database.nameManager.newAutoName("IDX", constraint.getName().name, table.getSchemaName(), table.getName(), 20);
                    SchemaObject schemaObject = table.createAndAddIndexStructure(hsqlName, constraint.core.mainCols, null, null, true, true, false);
                    Constraint constraint3 = new Constraint(constraint.getName(), table, (Index)schemaObject, 2);
                    table.addConstraint(constraint3);
                    if (!bl) continue block7;
                    session.database.schemaManager.addSchemaObject(constraint3);
                    continue block7;
                }
                case 0: {
                    ParserDDL.addForeignKey(session, table, constraint, hsqlArrayList2);
                    continue block7;
                }
                case 3: {
                    SchemaObject schemaObject;
                    try {
                        constraint.prepareCheckConstraint(session, table, false);
                    }
                    catch (HsqlException hsqlException) {
                        if (session.isProcessingScript()) continue block7;
                        throw hsqlException;
                    }
                    table.addConstraint(constraint);
                    if (constraint.isNotNull()) {
                        schemaObject = table.getColumn(constraint.notNullColumnIndex);
                        schemaObject.setNullable(false);
                        table.setColumnTypeVars(constraint.notNullColumnIndex);
                    }
                    if (!bl) continue block7;
                    session.database.schemaManager.addSchemaObject(constraint);
                }
            }
        }
        return table;
    }

    static void addForeignKey(Session session, Table table, Constraint constraint, HsqlArrayList hsqlArrayList) {
        Object object;
        HsqlNameManager.HsqlName hsqlName = constraint.getMainTableName();
        if (hsqlName == table.getName()) {
            constraint.core.mainTable = table;
        } else {
            object = session.database.schemaManager.findUserTable(session, hsqlName.name, hsqlName.schema.name);
            if (object == null) {
                if (hsqlArrayList == null) {
                    throw Error.error(5501, hsqlName.name);
                }
                hsqlArrayList.add(constraint);
                return;
            }
            constraint.core.mainTable = object;
        }
        constraint.setColumnsIndexes(table);
        object = new TableWorks(session, table);
        ((TableWorks)object).checkCreateForeignKey(constraint);
        Constraint constraint2 = constraint.core.mainTable.getUniqueConstraintForColumns(constraint.core.mainCols);
        if (constraint2 == null) {
            throw Error.error(5523);
        }
        Index index = constraint2.getMainIndex();
        boolean bl = constraint.core.mainTable.getSchemaName() != table.getSchemaName();
        int n = session.database.schemaManager.getTableIndex(table);
        if (n != -1 && n < session.database.schemaManager.getTableIndex(constraint.core.mainTable)) {
            bl = true;
        }
        HsqlNameManager.HsqlName hsqlName2 = session.database.nameManager.newAutoName("IDX", table.getSchemaName(), table.getName(), 20);
        Index index2 = table.createAndAddIndexStructure(hsqlName2, constraint.core.refCols, null, null, false, true, bl);
        HsqlNameManager.HsqlName hsqlName3 = session.database.nameManager.newAutoName("REF", constraint.getName().name, table.getSchemaName(), table.getName(), 20);
        constraint.core.uniqueName = constraint2.getName();
        constraint.core.mainName = hsqlName3;
        constraint.core.mainIndex = index;
        constraint.core.refTable = table;
        constraint.core.refName = constraint.getName();
        constraint.core.refIndex = index2;
        constraint.isForward = bl;
        table.addConstraint(constraint);
        constraint.core.mainTable.addConstraint(new Constraint(hsqlName3, constraint));
        session.database.schemaManager.addSchemaObject(constraint);
    }

    private Constraint readFKReferences(Table table, HsqlNameManager.HsqlName hsqlName, OrderedHashSet orderedHashSet) {
        HsqlNameManager.HsqlName hsqlName2;
        OrderedHashSet orderedHashSet2 = null;
        this.readThis(222);
        HsqlNameManager.HsqlName hsqlName3 = this.token.namePrefix == null ? table.getSchemaName() : this.database.schemaManager.getSchemaHsqlName(this.token.namePrefix);
        if (table.getSchemaName() == hsqlName3 && table.getName().name.equals(this.token.tokenString)) {
            hsqlName2 = table.getName();
            this.read();
        } else {
            hsqlName2 = this.readFKTableName(hsqlName3);
        }
        if (this.token.tokenType == 786) {
            orderedHashSet2 = this.readColumnNames(false);
        }
        int n = 59;
        if (this.token.tokenType == 162) {
            this.read();
            switch (this.token.tokenType) {
                case 511: {
                    this.read();
                    break;
                }
                case 470: {
                    throw super.unsupportedFeature();
                }
                case 116: {
                    this.read();
                    n = 61;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
        }
        int n2 = 3;
        int n3 = 3;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        block13: while (this.token.tokenType == 194) {
            this.read();
            if (!orderedIntHashSet.add(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            if (this.token.tokenType == 79) {
                this.read();
                if (this.token.tokenType == 254) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 78: {
                            this.read();
                            n2 = 4;
                            continue block13;
                        }
                        case 186: {
                            this.read();
                            n2 = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 347) {
                    this.read();
                    n2 = 0;
                    continue;
                }
                if (this.token.tokenType == 485) {
                    this.read();
                    continue;
                }
                this.readThis(180);
                this.readThis(332);
                continue;
            }
            if (this.token.tokenType == 303) {
                this.read();
                if (this.token.tokenType == 254) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 78: {
                            this.read();
                            n3 = 4;
                            continue block13;
                        }
                        case 186: {
                            this.read();
                            n3 = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 347) {
                    this.read();
                    n3 = 0;
                    continue;
                }
                if (this.token.tokenType == 485) {
                    this.read();
                    continue;
                }
                this.readThis(180);
                this.readThis(332);
                continue;
            }
            throw this.unexpectedToken();
        }
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("FK", table.getSchemaName(), table.getName(), 5);
        }
        return new Constraint(hsqlName, table.getName(), orderedHashSet, hsqlName2, orderedHashSet2, 0, n2, n3, n);
    }

    private HsqlNameManager.HsqlName readFKTableName(HsqlNameManager.HsqlName hsqlName) {
        this.checkIsSchemaObjectName();
        Table table = this.database.schemaManager.findUserTable(this.session, this.token.tokenString, hsqlName.name);
        HsqlNameManager.HsqlName hsqlName2 = table == null ? this.database.nameManager.newHsqlName(hsqlName, this.token.tokenString, this.isDelimitedIdentifier(), 3) : table.getName();
        this.read();
        return hsqlName2;
    }

    StatementSchema compileCreateView(boolean bl, boolean bl2) {
        QueryExpression queryExpression;
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(4, true);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.checkSchemaUpdateAuthorisation(hsqlName.schema);
        HsqlNameManager.HsqlName[] hsqlNameArray = null;
        if (this.token.tokenType == 786) {
            try {
                hsqlNameArray = this.readColumnNames(hsqlName);
            }
            catch (HsqlException hsqlException) {
                if (this.session.isProcessingScript() && this.database.getProperties().isVersion18()) {
                    while (this.token.tokenType != 10) {
                        this.read();
                    }
                }
                throw hsqlException;
            }
        }
        this.readThis(10);
        this.startRecording();
        int n = this.getPosition();
        try {
            queryExpression = this.XreadQueryExpression();
        }
        catch (HsqlException hsqlException) {
            queryExpression = this.XreadJoinedTableAsView();
        }
        Token[] tokenArray = this.getRecordedStatement();
        int n2 = 0;
        if (this.token.tokenType == 319) {
            this.read();
            n2 = 2;
            if (this.readIfThis(157)) {
                n2 = 1;
            } else {
                this.readIfThis(28);
            }
            this.readThis(37);
            this.readThis(455);
        }
        View view = new View(this.database, hsqlName, hsqlNameArray, n2);
        queryExpression.setView(view);
        queryExpression.resolve(this.session);
        view.setStatement(Token.getSQL(tokenArray));
        StatementQuery statementQuery = new StatementQuery(this.session, queryExpression, this.compileContext);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{view};
        int n3 = bl ? 1070 : 84;
        HsqlNameManager.HsqlName[] hsqlNameArray2 = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, n3, objectArray, statementQuery.readTableNames, hsqlNameArray2);
    }

    StatementSchema compileCreateSequence() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(7, false);
        NumberSequence numberSequence = new NumberSequence(hsqlName, Type.SQL_INTEGER);
        this.readSequenceOptions(numberSequence, true, false, false);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{numberSequence};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 133, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateDomain() {
        Object[] objectArray;
        int n;
        UserTypeModifier userTypeModifier = null;
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(13, false);
        this.readIfThis(10);
        Type type = this.readTypeDefinition(false, false).duplicate();
        Expression expression = null;
        if (this.readIfThis(78)) {
            expression = this.readDefaultClause(type);
        }
        userTypeModifier = new UserTypeModifier(hsqlName, 13, type);
        userTypeModifier.setDefaultClause(expression);
        type.userTypeModifier = userTypeModifier;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        this.compileContext.currentDomain = type;
        do {
            n = 0;
            switch (this.token.tokenType) {
                case 37: 
                case 48: {
                    this.readConstraint(type, hsqlArrayList);
                    break;
                }
                default: {
                    n = 1;
                }
            }
        } while (n == 0);
        this.compileContext.currentDomain = null;
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            objectArray = (Object[])hsqlArrayList.get(n);
            objectArray.prepareCheckConstraint(this.session, null, false);
            userTypeModifier.addConstraint((Constraint)objectArray);
        }
        String string = this.getLastPart();
        objectArray = new Object[]{type};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 23, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateType(boolean bl) {
        UserTypeModifier userTypeModifier;
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(12, false);
        this.readThis(10);
        Type type = this.readTypeDefinition(false, false).duplicate();
        this.readIfThis(400);
        type.userTypeModifier = userTypeModifier = new UserTypeModifier(hsqlName, 12, type);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{type};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 83, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateCharacterSet() {
        this.read();
        this.readThis(254);
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(14, false);
        this.readIfThis(10);
        this.readThis(119);
        String string = this.session.getSchemaName(this.token.namePrefix);
        Charset charset = (Charset)this.database.schemaManager.getSchemaObject(this.token.tokenString, string, 14);
        this.read();
        if (this.token.tokenType == 358) {
            this.read();
            this.readThis(115);
            this.readThis(78);
        }
        Charset charset2 = new Charset(hsqlName);
        charset2.base = charset.getName();
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{charset2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string2, 8, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateCollation() {
        Collation collation;
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(15, false);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.readThis(112);
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(14, false);
        hsqlName2.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.readThis(115);
        HsqlNameManager.HsqlName hsqlName3 = this.readNewSchemaObjectName(15, false);
        hsqlName3.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        Boolean bl = null;
        if (this.readIfThis(180)) {
            this.readThis(463);
            bl = Boolean.FALSE;
        } else if (this.readIfThis(463)) {
            this.readThis(514);
            bl = Boolean.TRUE;
        }
        Charset charset = (Charset)this.database.schemaManager.getSchemaObject(hsqlName2);
        if (charset == null) {
            throw Error.error(5501, hsqlName2.getSchemaQualifiedStatementName());
        }
        try {
            collation = Collation.getCollation(hsqlName3.name);
        }
        catch (HsqlException hsqlException) {
            collation = (Collation)this.database.schemaManager.getSchemaObject(hsqlName3);
        }
        if (collation == null) {
            throw Error.error(5501, hsqlName3.getSchemaQualifiedStatementName());
        }
        Collation collation2 = new Collation(hsqlName, collation, charset, bl);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{collation2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 10, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateAlias() {
        Object[] objectArray;
        Object object;
        String string;
        HsqlNameManager.HsqlName hsqlName = null;
        Routine[] routineArray = null;
        String string2 = null;
        if (!this.session.isProcessingScript()) {
            throw super.unsupportedFeature();
        }
        this.read();
        try {
            string = this.token.tokenString;
            this.read();
            this.readThis(112);
            string2 = this.token.tokenString;
            this.read();
        }
        catch (HsqlException hsqlException) {
            string = null;
        }
        if (string != null) {
            object = this.database.schemaManager.getDefaultSchemaHsqlName();
            hsqlName = this.database.nameManager.newHsqlName((HsqlNameManager.HsqlName)object, string, 16);
            objectArray = Routine.getMethods(string2);
            routineArray = Routine.newRoutines(this.session, (Method[])objectArray);
        }
        object = this.getLastPart();
        objectArray = new Object[]{hsqlName, routineArray};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema((String)object, 1072, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateTrigger(boolean bl) {
        HsqlNameManager.HsqlName[] hsqlNameArray;
        Object[] objectArray;
        Object object;
        int n;
        int n2;
        Boolean bl2 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = 0;
        HsqlNameManager.HsqlName hsqlName = null;
        OrderedHashSet orderedHashSet = null;
        int[] nArray = null;
        this.read();
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(8, true);
        switch (this.token.tokenType) {
            case 422: {
                n2 = TriggerDef.getTiming(422);
                this.read();
                this.readThis(191);
                break;
            }
            case 336: 
            case 343: {
                n2 = TriggerDef.getTiming(this.token.tokenType);
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        switch (this.token.tokenType) {
            case 79: 
            case 135: {
                n = TriggerDef.getOperationType(this.token.tokenType);
                this.read();
                break;
            }
            case 303: {
                n = TriggerDef.getOperationType(this.token.tokenType);
                this.read();
                if (this.token.tokenType != 191 || n2 == 6) break;
                this.read();
                orderedHashSet = new OrderedHashSet();
                this.readColumnNameList(orderedHashSet, null, false);
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(194);
        Table table = this.readTableName();
        if (this.token.tokenType == 343) {
            this.read();
            this.checkIsSimpleName();
            hsqlName = this.readNewSchemaObjectName(8, true);
        }
        hsqlName2.setSchemaIfNull(table.getSchemaName());
        this.checkSchemaUpdateAuthorisation(hsqlName2.schema);
        if (n2 == 6 ? !table.isView() || ((View)table).getCheckOption() == 2 : table.isView()) {
            throw Error.error(5538, hsqlName2.schema.name);
        }
        if (hsqlName2.schema != table.getSchemaName()) {
            throw Error.error(5505, hsqlName2.schema.name);
        }
        hsqlName2.parent = table.getName();
        this.database.schemaManager.checkSchemaObjectNotExists(hsqlName2);
        if (orderedHashSet != null) {
            nArray = table.getColumnIndexes(orderedHashSet);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != -1) continue;
                throw Error.error(5544, (String)orderedHashSet.get(i));
            }
        }
        Expression expression = null;
        String string = null;
        String string2 = null;
        HsqlNameManager.SimpleName simpleName = null;
        HsqlNameManager.SimpleName simpleName2 = null;
        Table[] tableArray = new Table[4];
        RangeVariable[] rangeVariableArray = new RangeVariable[4];
        String string3 = null;
        RangeGroup[] rangeGroupArray = new RangeGroup[]{new RangeGroup.RangeGroupSimple(rangeVariableArray)};
        if (this.token.tokenType == 223) {
            this.read();
            if (this.token.tokenType != 193 && this.token.tokenType != 179) {
                throw this.unexpectedToken();
            }
            while (true) {
                String string4;
                if (this.token.tokenType == 193) {
                    if (n == 50) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 278) {
                        if (Boolean.TRUE.equals(bl2) || string != null || n2 == 4) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.readIfThis(10);
                        this.checkIsSimpleName();
                        this.read();
                        string4 = string = this.token.tokenString;
                        if (string4.equals(string2) || string4.equals(simpleName) || string4.equals(simpleName2)) {
                            throw this.unexpectedToken();
                        }
                        bl2 = Boolean.FALSE;
                        object = this.database.nameManager.newHsqlName(table.getSchemaName(), string4, this.isDelimitedIdentifier(), 10);
                        objectArray = new Table(table, (HsqlNameManager.HsqlName)object);
                        hsqlNameArray = new RangeVariable((Table)objectArray, null, null, null, this.compileContext);
                        tableArray[2] = objectArray;
                        rangeVariableArray[2] = hsqlNameArray;
                        continue;
                    }
                    if (Boolean.FALSE.equals(bl2) || simpleName != null) {
                        throw this.unexpectedToken();
                    }
                    this.readIfThis(243);
                    this.readIfThis(10);
                    this.checkIsSimpleName();
                    simpleName = HsqlNameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                    this.read();
                    string4 = simpleName.name;
                    if (string4.equals(string2) || string4.equals(string) || string4.equals(simpleName2)) {
                        throw this.unexpectedToken();
                    }
                    bl2 = Boolean.TRUE;
                    object = new RangeVariable(table.columnList, simpleName, false, 2);
                    ((RangeVariable)object).rangePosition = 0;
                    tableArray[0] = null;
                    rangeVariableArray[0] = object;
                    continue;
                }
                if (this.token.tokenType != 179) break;
                if (n == 19) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (this.token.tokenType == 278) {
                    if (Boolean.TRUE.equals(bl2) || string2 != null || n2 == 4) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readIfThis(10);
                    this.checkIsSimpleName();
                    string2 = this.token.tokenString;
                    this.read();
                    bl2 = Boolean.FALSE;
                    string4 = string2;
                    if (string4.equals(string) || string4.equals(simpleName) || string4.equals(simpleName2)) {
                        throw this.unexpectedToken();
                    }
                    object = this.database.nameManager.newHsqlName(table.getSchemaName(), string4, this.isDelimitedIdentifier(), 10);
                    objectArray = new Table(table, (HsqlNameManager.HsqlName)object);
                    hsqlNameArray = new RangeVariable((Table)objectArray, null, null, null, this.compileContext);
                    tableArray[3] = objectArray;
                    rangeVariableArray[3] = hsqlNameArray;
                    continue;
                }
                if (Boolean.FALSE.equals(bl2) || simpleName2 != null) {
                    throw this.unexpectedToken();
                }
                this.readIfThis(243);
                this.readIfThis(10);
                this.checkIsSimpleName();
                simpleName2 = HsqlNameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                this.read();
                string4 = simpleName2.name;
                if (string4.equals(string) || string4.equals(string2) || string4.equals(simpleName)) {
                    throw this.unexpectedToken();
                }
                bl2 = Boolean.TRUE;
                object = new RangeVariable(table.columnList, simpleName2, false, 2);
                ((RangeVariable)object).rangePosition = 1;
                tableArray[1] = null;
                rangeVariableArray[1] = object;
            }
        }
        if (Boolean.TRUE.equals(bl2) && this.token.tokenType != 112) {
            throw this.unexpectedTokenRequire("FOR");
        }
        if (this.token.tokenType == 112) {
            this.read();
            this.readThis(90);
            if (this.token.tokenType == 243) {
                if (Boolean.FALSE.equals(bl2)) {
                    throw this.unexpectedToken();
                }
                bl2 = Boolean.TRUE;
            } else if (this.token.tokenType == 517) {
                if (Boolean.TRUE.equals(bl2) || n2 == 4) {
                    throw this.unexpectedToken();
                }
                bl2 = Boolean.FALSE;
            } else {
                throw this.unexpectedToken();
            }
            this.read();
        }
        if (rangeVariableArray[2] != null) {
            // empty if block
        }
        if (rangeVariableArray[3] != null) {
            // empty if block
        }
        if ("QUEUE".equals(this.token.tokenString)) {
            this.read();
            n3 = this.readInteger();
            bl4 = true;
        }
        if ("NOWAIT".equals(this.token.tokenString)) {
            this.read();
            bl3 = true;
        }
        if (this.token.tokenType == 314 && n2 != 6) {
            this.read();
            this.readThis(786);
            int n4 = this.getPosition();
            this.isCheckOrTriggerCondition = true;
            expression = this.XreadBooleanValueExpression();
            string3 = this.getLastPart(n4);
            this.isCheckOrTriggerCondition = false;
            this.readThis(772);
            object = expression.resolveColumnReferences(this.session, new RangeGroup.RangeGroupSimple(rangeVariableArray), rangeGroupArray, null);
            ExpressionColumn.checkColumnsResolved((HsqlList)object);
            expression.resolveTypes(this.session, null);
            if (expression.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (bl2 == null) {
            bl2 = Boolean.FALSE;
        }
        if (this.token.tokenType == 25) {
            int n5 = this.getPosition();
            try {
                this.read();
                this.checkIsSimpleName();
                this.checkIsDelimitedIdentifier();
                String string5 = this.token.tokenString;
                this.read();
                if (this.token.tokenType == 786) {
                    throw this.unexpectedToken();
                }
                TriggerDef triggerDef = new TriggerDef(hsqlName2, n2, n, bl2, table, tableArray, rangeVariableArray, expression, string3, nArray, string5, bl3, n3);
                object = this.getLastPart();
                objectArray = new Object[]{triggerDef, hsqlName};
                hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
                return new StatementSchema((String)object, 80, objectArray, null, hsqlNameArray);
            }
            catch (HsqlException hsqlException) {
                this.rewind(n5);
            }
        }
        if (bl4) {
            throw this.unexpectedToken("QUEUE");
        }
        if (bl3) {
            throw this.unexpectedToken("NOWAIT");
        }
        Routine routine = this.compileTriggerRoutine(table, rangeVariableArray, n2, n);
        TriggerDefSQL triggerDefSQL = new TriggerDefSQL(hsqlName2, n2, n, bl2, table, tableArray, rangeVariableArray, expression, string3, nArray, routine);
        object = this.getLastPart();
        objectArray = new Object[]{triggerDefSQL, hsqlName};
        return new StatementSchema((String)object, 80, objectArray, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
    }

    Routine compileTriggerRoutine(Table table, RangeVariable[] rangeVariableArray, int n, int n2) {
        int n3 = n == 4 ? 3 : 4;
        Routine routine = new Routine(table, rangeVariableArray, n3, n, n2);
        this.startRecording();
        StatementCompound statementCompound = new StatementCompound(12, null);
        statementCompound.rangeVariables = rangeVariableArray;
        Statement statement = this.compileSQLProcedureStatementOrNull(routine, null);
        if (statement == null) {
            throw this.unexpectedToken();
        }
        Token[] tokenArray = this.getRecordedStatement();
        String string = Token.getSQL(tokenArray);
        statement.setSQL(string);
        routine.setProcedure(statement);
        routine.resolve(this.session);
        return routine;
    }

    ColumnSchema readColumnDefinitionOrNull(Table table, HsqlNameManager.HsqlName hsqlName, HsqlArrayList hsqlArrayList) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Expression expression = null;
        boolean bl5 = true;
        Expression expression2 = null;
        Type type = null;
        NumberSequence numberSequence = null;
        switch (this.token.tokenType) {
            case 407: {
                this.read();
                this.readThis(337);
                bl = true;
                bl4 = true;
                throw this.unexpectedToken("GENERATED");
            }
            case 128: {
                this.read();
                bl2 = true;
                bl3 = true;
                type = Type.SQL_INTEGER;
                numberSequence = new NumberSequence(null, 0L, 1L, type);
                break;
            }
            case 774: {
                return null;
            }
            case 772: {
                return null;
            }
            default: {
                if (this.token.isUndelimitedIdentifier) {
                    if ("SERIAL".equals(this.token.tokenString)) {
                        if (this.database.sqlSyntaxMys) {
                            this.read();
                            bl2 = true;
                            bl3 = true;
                            type = Type.SQL_BIGINT;
                            numberSequence = new NumberSequence(null, 1L, 1L, type);
                            break;
                        }
                        if (this.database.sqlSyntaxPgs) {
                            this.read();
                            bl2 = true;
                            type = Type.SQL_INTEGER;
                            numberSequence = new NumberSequence(null, 1L, 1L, type);
                            break;
                        }
                    } else if ("BIGSERIAL".equals(this.token.tokenString) && this.database.sqlSyntaxPgs) {
                        this.read();
                        bl2 = true;
                        bl3 = true;
                        type = Type.SQL_BIGINT;
                        numberSequence = new NumberSequence(null, 1L, 1L, type);
                        break;
                    }
                }
                type = this.readTypeDefinition(true, true);
            }
        }
        if (!bl && !bl2) {
            if (this.database.sqlSyntaxMys) {
                switch (this.token.tokenType) {
                    case 186: {
                        this.read();
                        break;
                    }
                    case 183: {
                        this.read();
                        this.readThis(186);
                        bl5 = false;
                        break;
                    }
                }
            }
            switch (this.token.tokenType) {
                case 319: {
                    if (this.database.sqlSyntaxDb2) {
                        this.read();
                    } else {
                        throw this.unexpectedToken();
                    }
                }
                case 78: {
                    this.read();
                    expression2 = this.readDefaultClause(type);
                    if (expression2.opType != 12 || !this.database.sqlSyntaxPgs) break;
                    numberSequence = ((ExpressionColumn)expression2).sequence;
                    expression2 = null;
                    bl2 = true;
                    break;
                }
                case 407: {
                    this.read();
                    if (this.token.tokenType == 24) {
                        this.read();
                        this.readThis(78);
                    } else {
                        this.readThis(337);
                        bl4 = true;
                    }
                    this.readThis(10);
                    if (this.token.tokenType == 128) {
                        this.read();
                        numberSequence = new NumberSequence(null, type);
                        numberSequence.setAlways(bl4);
                        if (this.token.tokenType == 786) {
                            this.read();
                            this.readSequenceOptions(numberSequence, false, false, true);
                            this.readThis(772);
                        }
                        bl2 = true;
                        break;
                    }
                    if (this.token.tokenType == 786) {
                        if (!bl4) {
                            throw super.unexpectedTokenRequire("IDENTITY");
                        }
                        bl = true;
                        break;
                    }
                    if (this.token.tokenType != 505) break;
                    if (bl4) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.namePrefix != null && !this.token.namePrefix.equals(table.getSchemaName().name)) {
                        throw super.unexpectedToken(this.token.namePrefix);
                    }
                    numberSequence = this.database.schemaManager.getSequence(this.token.tokenString, table.getSchemaName().name, true);
                    bl2 = true;
                    this.read();
                    break;
                }
                case 128: {
                    this.read();
                    bl2 = true;
                    bl3 = true;
                    numberSequence = new NumberSequence(null, 0L, 1L, type);
                }
            }
        }
        if (bl) {
            this.readThis(786);
            expression = this.XreadValueExpression();
            this.readThis(772);
        }
        if (!bl && !bl2 && this.database.sqlSyntaxMys && this.token.isUndelimitedIdentifier && "AUTO_INCREMENT".equals(this.token.tokenString)) {
            this.read();
            bl2 = true;
            numberSequence = new NumberSequence(null, 0L, 1L, type);
        }
        ColumnSchema columnSchema = new ColumnSchema(hsqlName, type, bl5, false, expression2);
        columnSchema.setGeneratingExpression(expression);
        this.readColumnConstraints(table, columnSchema, hsqlArrayList);
        if (this.token.tokenType == 128 && !bl2) {
            this.read();
            bl2 = true;
            bl3 = true;
            numberSequence = new NumberSequence(null, 0L, 1L, type);
        }
        if (bl2) {
            columnSchema.setIdentity(numberSequence);
        }
        if (bl3 && !columnSchema.isPrimaryKey()) {
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            orderedHashSet.add(columnSchema.getName().name);
            HsqlNameManager.HsqlName hsqlName2 = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
            Constraint constraint = new Constraint(hsqlName2, orderedHashSet, 4);
            hsqlArrayList.set(0, constraint);
            columnSchema.setPrimaryKey(true);
        }
        if (this.database.sqlSyntaxPgs && this.token.tokenType == 78 && columnSchema.getDefaultExpression() == null && columnSchema.getIdentitySequence() == null) {
            this.read();
            expression2 = this.readDefaultClause(type);
            if (expression2.opType == 12) {
                numberSequence = ((ExpressionColumn)expression2).sequence;
                expression2 = null;
            }
            columnSchema.setDefaultExpression(expression2);
            columnSchema.setIdentity(numberSequence);
        }
        return columnSchema;
    }

    private void readSequenceOptions(NumberSequence numberSequence, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        block10: do {
            bl4 = false;
            if (orderedIntHashSet.contains(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            switch (this.token.tokenType) {
                case 10: {
                    if (bl) {
                        orderedIntHashSet.add(this.token.tokenType);
                        this.read();
                        Type type = this.readTypeDefinition(false, true);
                        numberSequence.setDefaults(numberSequence.getName(), type);
                        break;
                    }
                    throw this.unexpectedToken();
                }
                case 267: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    this.readThis(319);
                    long l = this.readBigint();
                    numberSequence.setStartValueNoCheck(l);
                    if (!bl3) continue block10;
                    this.readIfThis(774);
                    break;
                }
                case 484: {
                    if (!bl2) {
                        bl4 = true;
                        break;
                    }
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    if (this.readIfThis(319)) {
                        long l = this.readBigint();
                        numberSequence.setCurrentValueNoCheck(l);
                        break;
                    }
                    numberSequence.setStartValueDefault();
                    break;
                }
                case 417: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    this.readThis(24);
                    long l = this.readBigint();
                    numberSequence.setIncrement(l);
                    break;
                }
                case 180: {
                    this.read();
                    if (orderedIntHashSet.contains(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    if (this.token.tokenType == 438) {
                        numberSequence.setDefaultMaxValue();
                    } else if (this.token.tokenType == 442) {
                        numberSequence.setDefaultMinValue();
                    } else if (this.token.tokenType == 71) {
                        numberSequence.setCycle(false);
                    } else {
                        throw this.unexpectedToken();
                    }
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    break;
                }
                case 438: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    long l = this.readBigint();
                    numberSequence.setMaxValueNoCheck(l);
                    break;
                }
                case 442: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    long l = this.readBigint();
                    numberSequence.setMinValueNoCheck(l);
                    break;
                }
                case 71: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    numberSequence.setCycle(true);
                    break;
                }
                default: {
                    if (this.database.sqlSyntaxOra && this.isSimpleName()) {
                        if (this.token.tokenString.equals("NOCACHE") || this.token.tokenString.equals("NOCYCLE") || this.token.tokenString.equals("NOMAXVALUE") || this.token.tokenString.equals("NOMINVALUE") || this.token.tokenString.equals("NOORDER") || this.token.tokenString.equals("ORDER")) {
                            this.read();
                            break;
                        }
                        if (this.token.tokenString.equals("CACHE")) {
                            this.read();
                            this.readBigint();
                            break;
                        }
                    }
                    bl4 = true;
                }
            }
        } while (!bl4);
        numberSequence.checkValues();
    }

    private void readConstraint(SchemaObject schemaObject, HsqlArrayList hsqlArrayList) {
        HsqlNameManager.HsqlName hsqlName = null;
        if (this.token.tokenType == 48) {
            this.read();
            hsqlName = this.readNewDependentSchemaObjectName(schemaObject.getName(), 5);
        }
        switch (this.token.tokenType) {
            case 214: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(427);
                Constraint constraint = (Constraint)hsqlArrayList.get(0);
                if (constraint.constType == 4) {
                    throw Error.error(5532);
                }
                if (hsqlName == null) {
                    hsqlName = this.database.nameManager.newAutoName("PK", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                OrderedHashSet orderedHashSet = this.readColumnNames(false);
                Constraint constraint2 = new Constraint(hsqlName, orderedHashSet, 4);
                hsqlArrayList.set(0, constraint2);
                break;
            }
            case 299: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                OrderedHashSet orderedHashSet = this.readColumnNames(false);
                if (hsqlName == null) {
                    hsqlName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint constraint = new Constraint(hsqlName, orderedHashSet, 2);
                hsqlArrayList.add(constraint);
                break;
            }
            case 113: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(427);
                OrderedHashSet orderedHashSet = this.readColumnNames(false);
                Constraint constraint = this.readFKReferences((Table)schemaObject, hsqlName, orderedHashSet);
                hsqlArrayList.add(constraint);
                break;
            }
            case 37: {
                this.read();
                if (hsqlName == null) {
                    hsqlName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint constraint = new Constraint(hsqlName, null, 3);
                this.readCheckConstraintCondition(constraint);
                hsqlArrayList.add(constraint);
                break;
            }
            default: {
                if (hsqlName == null) break;
                throw super.unexpectedToken();
            }
        }
    }

    void readColumnConstraints(Table table, ColumnSchema columnSchema, HsqlArrayList hsqlArrayList) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        do {
            HsqlNameManager.HsqlName hsqlName = null;
            if (this.token.tokenType == 48) {
                this.read();
                hsqlName = this.readNewDependentSchemaObjectName(table.getName(), 5);
            }
            switch (this.token.tokenType) {
                case 214: {
                    if (bl3 || bl4) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(427);
                    Object object = (Constraint)hsqlArrayList.get(0);
                    if (((Constraint)object).constType == 4) {
                        throw Error.error(5532);
                    }
                    Object object2 = new OrderedHashSet();
                    ((HashSet)object2).add(columnSchema.getName().name);
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint constraint = new Constraint(hsqlName, (OrderedHashSet)object2, 4);
                    hsqlArrayList.set(0, constraint);
                    columnSchema.setPrimaryKey(true);
                    bl4 = true;
                    break;
                }
                case 299: {
                    this.read();
                    Object object = new OrderedHashSet();
                    ((HashSet)object).add(columnSchema.getName().name);
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Object object2 = new Constraint(hsqlName, (OrderedHashSet)object, 2);
                    hsqlArrayList.add(object2);
                    break;
                }
                case 113: {
                    this.read();
                    this.readThis(427);
                }
                case 222: {
                    Object object = new OrderedHashSet();
                    ((HashSet)object).add(columnSchema.getName().name);
                    Object object2 = this.readFKReferences(table, hsqlName, (OrderedHashSet)object);
                    hsqlArrayList.add(object2);
                    break;
                }
                case 37: {
                    this.read();
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Object object = new Constraint(hsqlName, null, 3);
                    this.readCheckConstraintCondition((Constraint)object);
                    Object object2 = ((Constraint)object).getCheckColumnExpressions();
                    for (int i = 0; i < ((BaseHashMap)object2).size(); ++i) {
                        ExpressionColumn expressionColumn = (ExpressionColumn)((OrderedHashSet)object2).get(i);
                        if (columnSchema.getName().name.equals(expressionColumn.getColumnName())) {
                            if (expressionColumn.getSchemaName() == null || expressionColumn.getSchemaName() == table.getSchemaName().name) continue;
                            throw Error.error(5505);
                        }
                        throw Error.error(5501);
                    }
                    hsqlArrayList.add(object);
                    break;
                }
                case 183: {
                    if (bl2 || bl3) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(186);
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Object object = new Constraint(hsqlName, null, 3);
                    ((Constraint)object).check = new ExpressionLogical(columnSchema);
                    hsqlArrayList.add(object);
                    bl2 = true;
                    break;
                }
                case 186: {
                    if (bl2 || bl3 || bl4) {
                        throw this.unexpectedToken();
                    }
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    bl3 = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
        } while (!bl);
    }

    void readCheckConstraintCondition(Constraint constraint) {
        this.readThis(786);
        this.startRecording();
        this.isCheckOrTriggerCondition = true;
        Expression expression = this.XreadBooleanValueExpression();
        this.isCheckOrTriggerCondition = false;
        Token[] tokenArray = this.getRecordedStatement();
        this.readThis(772);
        constraint.check = expression;
    }

    StatementSchema compileCreateIndex(boolean bl) {
        String[] stringArray = null;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(20, true);
        while (this.token.tokenType != 194) {
            this.checkIsIdentifier();
            hsqlArrayList.add(this.token.tokenString);
            this.read();
        }
        stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        this.readThis(194);
        Table table = this.readTableName();
        HsqlNameManager.HsqlName hsqlName2 = table.getSchemaName();
        hsqlName.setSchemaIfNull(hsqlName2);
        hsqlName.parent = table.getName();
        if (hsqlName.schema != hsqlName2) {
            throw Error.error(5505);
        }
        hsqlName.schema = table.getSchemaName();
        int[] nArray = this.readColumnList(table, true);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{table, nArray, hsqlName, bl, stringArray};
        return new StatementSchema(string, 1073, objectArray, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
    }

    StatementSchema compileCreateSchema() {
        boolean bl;
        Grantee grantee;
        HsqlNameManager.HsqlName hsqlName = null;
        String string = null;
        HsqlNameManager.HsqlName hsqlName2 = null;
        this.read();
        if (this.token.tokenType != 15) {
            hsqlName = this.readNewSchemaName();
        }
        if (this.token.tokenType == 15) {
            this.read();
            this.checkIsSimpleName();
            string = this.token.tokenString;
            this.read();
            if (hsqlName == null) {
                grantee = this.database.getGranteeManager().get(string);
                if (grantee == null) {
                    throw Error.error(4001, string);
                }
                hsqlName = this.database.nameManager.newHsqlName(grantee.getName().name, this.isDelimitedIdentifier(), 2);
                SqlInvariants.checkSchemaNameNotSystem(this.token.tokenString);
            }
        }
        if ("PUBLIC".equals(string)) {
            throw Error.error(4002, string);
        }
        Grantee grantee2 = grantee = string == null ? this.session.getGrantee() : this.database.getGranteeManager().get(string);
        if (grantee == null) {
            throw Error.error(4001, string);
        }
        if (!this.session.getGrantee().isSchemaCreator()) {
            throw Error.error(2051, this.session.getGrantee().getName().getNameString());
        }
        if (grantee instanceof User && ((User)grantee).isExternalOnly) {
            throw Error.error(2000, this.session.getGrantee().getName().getNameString());
        }
        if (this.database.schemaManager.schemaExists(hsqlName.name)) {
            throw Error.error(5504, hsqlName.name);
        }
        if (hsqlName.name.equals("SYSTEM_LOBS")) {
            hsqlName = SqlInvariants.LOBS_SCHEMA_HSQLNAME;
            grantee = hsqlName.owner;
        }
        if (this.readIfThis(78)) {
            this.readThis(35);
            this.readThis(254);
            hsqlName2 = this.readNewSchemaObjectName(14, false);
        }
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, grantee};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        StatementSchema statementSchema = new StatementSchema(string2, 64, objectArray, null, hsqlNameArray);
        statementSchema.setSchemaHsqlName(hsqlName);
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        hsqlArrayList.add(statementSchema);
        this.getCompiledStatementBody(hsqlArrayList);
        StatementSchema[] statementSchemaArray = new StatementSchema[hsqlArrayList.size()];
        hsqlArrayList.toArray(statementSchemaArray);
        do {
            bl = false;
            for (int i = 0; i < statementSchemaArray.length - 1; ++i) {
                if (statementSchemaArray[i].order <= statementSchemaArray[i + 1].order) continue;
                StatementSchema statementSchema2 = statementSchemaArray[i + 1];
                statementSchemaArray[i + 1] = statementSchemaArray[i];
                statementSchemaArray[i] = statementSchema2;
                bl = true;
            }
        } while (bl);
        return new StatementSchemaDefinition(statementSchemaArray);
    }

    void getCompiledStatementBody(HsqlList hsqlList) {
        boolean bl = false;
        while (!bl) {
            StatementSchema statementSchema = null;
            int n = this.getPosition();
            block0 : switch (this.token.tokenType) {
                case 55: {
                    this.read();
                    switch (this.token.tokenType) {
                        case 299: 
                        case 305: 
                        case 497: {
                            throw this.unexpectedToken();
                        }
                        case 597: {
                            int n2 = 1073;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 505: {
                            statementSchema = this.compileCreateSequence();
                            statementSchema.sql = this.getLastPart(n);
                            break block0;
                        }
                        case 490: {
                            statementSchema = this.compileCreateRole();
                            statementSchema.sql = this.getLastPart(n);
                            break block0;
                        }
                        case 393: {
                            int n2 = 23;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 535: {
                            statementSchema = this.compileCreateType(false);
                            statementSchema.sql = this.getLastPart(n);
                            break block0;
                        }
                        case 35: {
                            statementSchema = this.compileCreateCharacterSet();
                            statementSchema.sql = this.getLastPart(n);
                            break block0;
                        }
                        case 339: {
                            throw this.unexpectedToken();
                        }
                        case 120: 
                        case 278: 
                        case 523: 
                        case 570: 
                        case 607: 
                        case 630: 
                        case 631: {
                            int n2 = 77;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 291: {
                            int n2 = 80;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 545: {
                            int n2 = 84;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 117: {
                            int n2 = 14;
                            String string = this.getStatementForRoutine(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 215: {
                            int n2 = 14;
                            String string = this.getStatementForRoutine(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                    }
                    throw this.unexpectedToken();
                }
                case 121: {
                    statementSchema = this.compileGrantOrRevoke();
                    statementSchema.sql = this.getLastPart(n);
                    break;
                }
                case 791: {
                    this.read();
                    bl = true;
                    break;
                }
                case 848: {
                    bl = true;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (statementSchema == null) continue;
            statementSchema.isSchemaDefinition = true;
            hsqlList.add(statementSchema);
        }
    }

    StatementSchema compileCreateRole() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewUserIdentifier();
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 61, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateUser() {
        Boolean bl = Boolean.FALSE;
        Boolean bl2 = Boolean.FALSE;
        Grantee grantee = this.session.getGrantee();
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewUserIdentifier();
        this.readThis(615);
        if (this.readIfThis(586)) {
            bl2 = Boolean.TRUE;
        }
        String string = this.readPassword();
        if (this.token.tokenType == 335) {
            this.read();
            bl = Boolean.TRUE;
        }
        this.checkDatabaseUpdateAuthorisation();
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, string, grantee, bl, bl2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string2, 1074, objectArray, null, hsqlNameArray);
    }

    HsqlNameManager.HsqlName readNewUserIdentifier() {
        this.checkIsSimpleName();
        String string = this.token.tokenString;
        boolean bl = this.isDelimitedIdentifier();
        if (string.equalsIgnoreCase("SA")) {
            string = "SA";
            bl = false;
        }
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(string, bl, 11);
        this.read();
        return hsqlName;
    }

    String readPassword() {
        String string = this.token.tokenString;
        if (this.isUndelimitedSimpleName() || this.isDelimitedSimpleName()) {
            this.read();
        } else {
            this.readQuotedString();
        }
        return string;
    }

    Statement compileRenameObject(HsqlNameManager.HsqlName hsqlName, int n) {
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(n, true);
        String string = this.getLastPart();
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                this.checkSchemaUpdateAuthorisation(this.session, hsqlName);
                break;
            }
            default: {
                hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                this.checkSchemaUpdateAuthorisation(this.session, hsqlName.schema);
            }
        }
        Object[] objectArray = new Object[]{hsqlName, hsqlName2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(string, 1192, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddUniqueConstraint(Table table, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        int[] nArray = this.readColumnList(table, false);
        HsqlNameManager.HsqlName hsqlName2 = this.database.nameManager.newAutoName("IDX", hsqlName.name, table.getSchemaName(), table.getName(), 20);
        Index index = table.createIndexStructure(hsqlName2, nArray, null, null, true, true, false);
        Constraint constraint = new Constraint(hsqlName, table, index, 2);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1082, table, constraint};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddForeignKeyConstraint(Table table, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("FK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet orderedHashSet = this.readColumnNames(false);
        Constraint constraint = this.readFKReferences(table, hsqlName, orderedHashSet);
        HsqlNameManager.HsqlName hsqlName2 = constraint.getMainTableName();
        constraint.core.mainTable = this.database.schemaManager.getTable(this.session, hsqlName2.name, hsqlName2.schema.name);
        constraint.setColumnsIndexes(table);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1082, table, constraint};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        if (hsqlName2 != null && hsqlName2 != table.getName()) {
            hsqlNameArray = (HsqlNameManager.HsqlName[])ArrayUtil.toAdjustedArray(hsqlNameArray, hsqlName2, hsqlNameArray.length, 1);
        }
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddCheckConstraint(Table table, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        Constraint constraint = new Constraint(hsqlName, null, 3);
        this.readCheckConstraintCondition(constraint);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1082, table, constraint};
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddColumn(Table table) {
        int n = table.getColumnCount();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Constraint constraint = new Constraint(null, null, 5);
        hsqlArrayList.add(constraint);
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        ColumnSchema columnSchema = this.readColumnDefinitionOrNull(table, hsqlName, hsqlArrayList);
        if (columnSchema == null) {
            throw Error.error(5000);
        }
        if (this.token.tokenType == 343) {
            this.read();
            n = table.getColumnIndex(this.token.tokenString);
            this.read();
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1081, table, columnSchema, new Integer(n), hsqlArrayList};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddPrimaryKey(Table table, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            hsqlName = this.session.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet orderedHashSet = this.readColumnNames(false);
        Constraint constraint = new Constraint(hsqlName, orderedHashSet, 4);
        constraint.setColumnsIndexes(table);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1082, table, constraint};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableDropColumn(Table table, String string, boolean bl) {
        int n = table.getColumnIndex(string);
        if (table.getColumnCount() == 1) {
            throw Error.error(5591);
        }
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{table.getColumn(n).getName(), ValuePool.getInt(9), bl, false};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string2, 1076, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterColumn(Table table, ColumnSchema columnSchema, int n) {
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        int n2 = this.getPosition();
        switch (this.token.tokenType) {
            case 622: {
                this.read();
                this.readThis(285);
                return this.compileAlterColumnRename(table, columnSchema);
            }
            case 88: {
                this.read();
                if (this.token.tokenType == 78) {
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1088, table, columnSchema, n};
                    return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
                }
                if (this.token.tokenType == 407) {
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1089, table, columnSchema, n};
                    return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
                }
                throw this.unexpectedToken();
            }
            case 254: {
                this.read();
                switch (this.token.tokenType) {
                    case 378: {
                        this.read();
                        this.readThis(535);
                        return this.compileAlterColumnDataType(table, columnSchema);
                    }
                    case 78: {
                        this.read();
                        Type type = columnSchema.getDataType();
                        Expression expression = this.readDefaultClause(type);
                        String string = this.getLastPart();
                        Object[] objectArray = new Object[]{1087, table, columnSchema, n, expression};
                        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
                    }
                    case 183: {
                        this.read();
                        this.readThis(186);
                        return this.compileAlterColumnSetNullability(table, columnSchema, false);
                    }
                    case 186: {
                        this.read();
                        return this.compileAlterColumnSetNullability(table, columnSchema, true);
                    }
                    case 407: {
                        return this.compileAlterColumnAddSequence(table, columnSchema, n);
                    }
                }
                this.rewind(n2);
                this.read();
            }
            case 407: {
                return this.compileAlterColumnAddSequence(table, columnSchema, n);
            }
        }
        if (this.token.tokenType == 254 || this.token.tokenType == 484) {
            if (!columnSchema.isIdentity()) {
                throw Error.error(5535);
            }
            return this.compileAlterColumnSequenceOptions(table, columnSchema, n);
        }
        return this.compileAlterColumnDataTypeIdentity(table, columnSchema);
    }

    private Statement compileAlterColumnDataTypeIdentity(Table table, ColumnSchema columnSchema) {
        if (columnSchema.isGenerated()) {
            throw Error.error(5561);
        }
        NumberSequence numberSequence = columnSchema.getIdentitySequence();
        Type type = columnSchema.getDataType();
        if (this.token.tokenType == 128) {
            this.read();
            if (!type.isIntegralType()) {
                throw Error.error(5561);
            }
            if (numberSequence == null) {
                numberSequence = new NumberSequence(null, type);
            }
        } else {
            type = this.readTypeDefinition(false, true);
            switch (this.token.tokenType) {
                case 128: {
                    if (!type.isIntegralType()) {
                        throw Error.error(5561);
                    }
                    this.read();
                    if (numberSequence != null) break;
                    numberSequence = new NumberSequence(null, type);
                    break;
                }
                case 407: {
                    numberSequence = this.readSequence(columnSchema);
                    break;
                }
                default: {
                    numberSequence = null;
                }
            }
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1090, table, columnSchema, type, numberSequence};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    private Statement compileAlterColumnDataType(Table table, ColumnSchema columnSchema) {
        if (columnSchema.isGenerated()) {
            throw Error.error(5561);
        }
        Type type = this.readTypeDefinition(false, true);
        if (columnSchema.isIdentity() && !type.isIntegralType()) {
            throw Error.error(5561);
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1084, table, columnSchema, type};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    private Statement compileAlterColumnSetNullability(Table table, ColumnSchema columnSchema, boolean bl) {
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1086, table, columnSchema, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterSequence() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        NumberSequence numberSequence = this.database.schemaManager.getSequence(this.token.tokenString, hsqlName.name, true);
        this.read();
        if (this.token.tokenType == 622) {
            this.read();
            this.readThis(285);
            return this.compileRenameObject(numberSequence.getName(), 7);
        }
        this.checkSchemaUpdateAuthorisation(this.session, numberSequence.getName().schema);
        NumberSequence numberSequence2 = numberSequence.duplicate();
        this.readSequenceOptions(numberSequence2, false, true, false);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{numberSequence, numberSequence2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(string, 134, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileAlterColumnAddSequence(Table table, ColumnSchema columnSchema, int n) {
        if (!columnSchema.getDataType().isIntegralType()) {
            throw Error.error(5525);
        }
        if (columnSchema.isIdentity()) {
            throw Error.error(5525);
        }
        NumberSequence numberSequence = this.readSequence(columnSchema);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1085, table, columnSchema, n, numberSequence};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    NumberSequence readSequence(ColumnSchema columnSchema) {
        this.readThis(407);
        NumberSequence numberSequence = new NumberSequence(null, columnSchema.getDataType());
        boolean bl = false;
        if (this.token.tokenType == 24) {
            this.read();
            this.readThis(78);
        } else {
            this.readThis(337);
            bl = true;
        }
        this.readThis(10);
        this.readThis(128);
        numberSequence.setAlways(bl);
        if (this.token.tokenType == 786) {
            this.read();
            this.readSequenceOptions(numberSequence, false, false, false);
            this.readThis(772);
        }
        numberSequence.checkValues();
        return numberSequence;
    }

    StatementSchema compileAlterColumnSequenceOptions(Table table, ColumnSchema columnSchema, int n) {
        boolean bl;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        NumberSequence numberSequence = columnSchema.getIdentitySequence().duplicate();
        do {
            bl = false;
            block0 : switch (this.token.tokenType) {
                case 484: {
                    long l;
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.readIfThis(319)) {
                        l = this.readBigint();
                        numberSequence.setCurrentValueNoCheck(l);
                        break;
                    }
                    numberSequence.reset();
                    break;
                }
                case 254: {
                    long l;
                    this.read();
                    switch (this.token.tokenType) {
                        case 417: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            this.readThis(24);
                            l = this.readBigint();
                            numberSequence.setIncrement(l);
                            break block0;
                        }
                        case 180: {
                            this.read();
                            if (this.token.tokenType == 438) {
                                numberSequence.setDefaultMaxValue();
                            } else if (this.token.tokenType == 442) {
                                numberSequence.setDefaultMinValue();
                            } else if (this.token.tokenType == 71) {
                                numberSequence.setCycle(false);
                            } else {
                                throw this.unexpectedToken();
                            }
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            break block0;
                        }
                        case 438: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            l = this.readBigint();
                            numberSequence.setMaxValueNoCheck(l);
                            break block0;
                        }
                        case 442: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            l = this.readBigint();
                            numberSequence.setMinValueNoCheck(l);
                            break block0;
                        }
                        case 71: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            numberSequence.setCycle(true);
                            break block0;
                        }
                    }
                    throw super.unexpectedToken();
                }
                default: {
                    bl = true;
                }
            }
        } while (!bl);
        numberSequence.checkValues();
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1085, table, columnSchema, n, numberSequence};
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    private Statement compileAlterColumnRename(Table table, ColumnSchema columnSchema) {
        this.checkIsSimpleName();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(9, true);
        if (table.findColumn(hsqlName.name) > -1) {
            throw Error.error(5504, hsqlName.name);
        }
        this.database.schemaManager.checkColumnIsReferenced(table.getName(), columnSchema.getName());
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{columnSchema.getName(), hsqlName};
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(string, 1192, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterSchemaRename() {
        HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
        this.checkSchemaUpdateAuthorisation(hsqlName);
        this.readThis(622);
        this.readThis(285);
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaName();
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, hsqlName2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(string, 1192, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterUser() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewUserIdentifier();
        User user = this.database.getUserManager().get(hsqlName.name);
        if (hsqlName.name.equals("PUBLIC")) {
            throw Error.error(5503);
        }
        this.readThis(254);
        switch (this.token.tokenType) {
            case 157: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{user, bl};
                return new StatementCommand(1060, objectArray);
            }
            case 615: {
                this.read();
                boolean bl = false;
                if (this.readIfThis(586)) {
                    bl = Boolean.TRUE;
                }
                String string = this.readPassword();
                Object[] objectArray = new Object[]{user, string, bl};
                StatementCommand statementCommand = new StatementCommand(1062, objectArray);
                String string2 = user.getSetPasswordDigestSQL();
                statementCommand.setSQL(string2);
                return statementCommand;
            }
            case 598: {
                this.read();
                this.readThis(497);
                HsqlNameManager.HsqlName hsqlName2 = this.token.tokenType == 78 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] objectArray = new Object[]{user, hsqlName2};
                return new StatementCommand(1061, objectArray);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterDomain() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(hsqlName);
        Type type = this.database.schemaManager.getDomain(this.token.tokenString, hsqlName.name, true);
        this.read();
        switch (this.token.tokenType) {
            case 622: {
                this.read();
                this.readThis(285);
                return this.compileRenameObject(type.getName(), 13);
            }
            case 88: {
                this.read();
                if (this.token.tokenType == 78) {
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1080, type};
                    HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(type.getName());
                    return new StatementSchema(string, 3, objectArray, null, hsqlNameArray);
                }
                if (this.token.tokenType == 48) {
                    this.read();
                    this.checkIsSchemaObjectName();
                    HsqlNameManager.HsqlName hsqlName2 = this.database.schemaManager.getSchemaObjectName(type.getSchemaName(), this.token.tokenString, 5, true);
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1078, type, hsqlName2};
                    HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(type.getName());
                    return new StatementSchema(string, 3, objectArray, null, hsqlNameArray);
                }
                throw this.unexpectedToken();
            }
            case 254: {
                this.read();
                this.readThis(78);
                Expression expression = this.readDefaultClause(type);
                String string = this.getLastPart();
                Object[] objectArray = new Object[]{1083, type, expression};
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(type.getName());
                return new StatementSchema(string, 3, objectArray, null, hsqlNameArray);
            }
            case 334: {
                this.read();
                if (this.token.tokenType != 48 && this.token.tokenType != 37) break;
                HsqlArrayList hsqlArrayList = new HsqlArrayList();
                this.compileContext.currentDomain = type;
                this.readConstraint(type, hsqlArrayList);
                this.compileContext.currentDomain = null;
                Constraint constraint = (Constraint)hsqlArrayList.get(0);
                String string = this.getLastPart();
                Object[] objectArray = new Object[]{1082, type, constraint};
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(type.getName());
                return new StatementSchema(string, 3, objectArray, null, hsqlNameArray);
            }
        }
        throw this.unexpectedToken();
    }

    private boolean isGrantToken() {
        switch (this.token.tokenType) {
            case 2: 
            case 79: 
            case 100: 
            case 135: 
            case 222: 
            case 251: 
            case 303: 
            case 540: {
                return true;
            }
        }
        return false;
    }

    StatementSchema compileGrantOrRevoke() {
        boolean bl = this.token.tokenType == 121;
        this.read();
        if (this.isGrantToken() || !bl && (this.token.tokenType == 121 || this.token.tokenType == 411)) {
            return this.compileRightGrantOrRevoke(bl);
        }
        return this.compileRoleGrantOrRevoke(bl);
    }

    private StatementSchema compileRightGrantOrRevoke(boolean bl) {
        Object[] objectArray;
        int n;
        int n2;
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        Grantee grantee = null;
        Right right = null;
        HsqlNameManager.HsqlName hsqlName = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (!bl) {
            if (this.token.tokenType == 121) {
                this.read();
                this.readThis(455);
                this.readThis(112);
                bl6 = true;
            } else if (this.token.tokenType == 411) {
                throw this.unsupportedFeature();
            }
        }
        if (this.token.tokenType == 2) {
            this.read();
            if (this.token.tokenType == 478) {
                this.read();
            }
            right = Right.fullRights;
            bl5 = true;
        } else {
            right = new Right();
            n2 = 1;
            block21: while (n2 != 0) {
                this.checkIsNotQuoted();
                int n3 = GranteeManager.getCheckSingleRight(this.token.tokenString);
                n = this.token.tokenType;
                objectArray = null;
                this.read();
                switch (n) {
                    case 135: 
                    case 222: 
                    case 251: 
                    case 303: {
                        if (this.token.tokenType == 786) {
                            objectArray = this.readColumnNames(false);
                        }
                    }
                    case 291: {
                        if (right == null) {
                            right = new Right();
                        }
                        right.set(n3, (OrderedHashSet)objectArray);
                        bl2 = true;
                        break;
                    }
                    case 79: {
                        if (right == null) {
                            right = new Right();
                        }
                        right.set(n3, null);
                        bl2 = true;
                        break;
                    }
                    case 540: {
                        if (bl2) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        bl3 = true;
                        n2 = 0;
                        continue block21;
                    }
                    case 100: {
                        if (bl2) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        bl4 = true;
                        n2 = 0;
                        continue block21;
                    }
                }
                if (this.token.tokenType != 774) break;
                this.read();
            }
        }
        this.readThis(194);
        n2 = 0;
        switch (this.token.tokenType) {
            case 574: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (!this.isSimpleName() || !this.isDelimitedIdentifier()) {
                    throw Error.error(5569);
                }
                n2 = 16;
                hsqlName = this.readNewSchemaObjectName(16, false);
                break;
            }
            case 259: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                switch (this.token.tokenType) {
                    case 117: 
                    case 215: 
                    case 491: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                n2 = 24;
                break;
            }
            case 117: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 16;
                break;
            }
            case 215: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 17;
                break;
            }
            case 491: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 18;
                break;
            }
            case 535: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 12;
                break;
            }
            case 393: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 13;
                break;
            }
            case 505: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 7;
                break;
            }
            case 35: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                this.readThis(254);
                n2 = 14;
                break;
            }
            default: {
                if (!bl2 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.readIfThis(278);
                n2 = 3;
            }
        }
        hsqlName = this.readNewSchemaObjectName(n2, false);
        if (bl) {
            this.readThis(285);
        } else {
            this.readThis(115);
        }
        while (true) {
            this.checkIsSimpleName();
            orderedHashSet.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 774) break;
            this.read();
        }
        if (bl) {
            if (this.token.tokenType == 319) {
                this.read();
                this.readThis(121);
                this.readThis(455);
                bl6 = true;
            }
            if (this.token.tokenType == 410) {
                this.read();
                this.readThis(24);
                if (this.token.tokenType == 69) {
                    this.read();
                } else {
                    this.readThis(64);
                    if (this.session.getRole() == null) {
                        throw Error.error(2200);
                    }
                    grantee = this.session.getRole();
                }
            }
        } else if (this.token.tokenType == 347) {
            bl7 = true;
            this.read();
        } else {
            this.readThis(485);
        }
        String string = this.getLastPart();
        n = bl ? 48 : 59;
        objectArray = new Object[]{orderedHashSet, hsqlName, right, grantee, bl7, bl6};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        StatementSchema statementSchema = new StatementSchema(string, n, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    private StatementSchema compileRoleGrantOrRevoke(boolean bl) {
        Grantee grantee = this.session.getGrantee();
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        OrderedHashSet orderedHashSet2 = new OrderedHashSet();
        boolean bl2 = false;
        if (!bl && this.token.tokenType == 335) {
            throw this.unsupportedFeature();
        }
        while (true) {
            this.checkIsSimpleName();
            orderedHashSet.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 774) break;
            this.read();
        }
        if (bl) {
            this.readThis(285);
        } else {
            this.readThis(115);
        }
        while (true) {
            this.checkIsSimpleName();
            orderedHashSet2.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 774) break;
            this.read();
        }
        if (bl && this.token.tokenType == 319) {
            throw this.unsupportedFeature();
        }
        if (this.token.tokenType == 410) {
            this.read();
            this.readThis(24);
            if (this.token.tokenType == 69) {
                this.read();
            } else {
                this.readThis(64);
                if (this.session.getRole() == null) {
                    throw Error.error(2200);
                }
                grantee = this.session.getRole();
            }
        }
        if (!bl) {
            if (this.token.tokenType == 347) {
                bl2 = true;
                this.read();
            } else {
                this.readThis(485);
            }
        }
        String string = this.getLastPart();
        int n = bl ? 49 : 129;
        Object[] objectArray = new Object[]{orderedHashSet2, orderedHashSet, grantee, bl2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        StatementSchema statementSchema = new StatementSchema(string, n, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    void checkSchemaUpdateAuthorisation(HsqlNameManager.HsqlName hsqlName) {
        if (this.session.isProcessingLog) {
            return;
        }
        SqlInvariants.checkSchemaNameNotSystem(hsqlName.name);
        if (this.isSchemaDefinition) {
            if (hsqlName != this.session.getCurrentSchemaHsqlName()) {
                throw Error.error(5505);
            }
        } else {
            this.session.getGrantee().checkSchemaUpdateOrGrantRights(hsqlName.name);
        }
        this.session.checkDDLWrite();
    }

    void checkDatabaseUpdateAuthorisation() {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
    }

    StatementSchema compileComment() {
        HsqlNameManager.HsqlName hsqlName;
        this.readThis(576);
        this.readThis(194);
        switch (this.token.tokenType) {
            case 278: 
            case 491: {
                int n = this.token.tokenType == 491 ? 18 : 3;
                this.read();
                this.checkIsSchemaObjectName();
                hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.token.isDelimitedIdentifier, n);
                hsqlName.schema = this.token.namePrefix == null ? this.session.getCurrentSchemaHsqlName() : this.database.nameManager.newHsqlName(this.token.namePrefix, this.token.isDelimitedPrefix, 2);
                this.read();
                break;
            }
            case 43: {
                this.read();
                this.checkIsSchemaObjectName();
                hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.token.isDelimitedIdentifier, 9);
                if (this.token.namePrefix == null) {
                    throw Error.error(5501);
                }
                hsqlName.parent = this.database.nameManager.newHsqlName(this.token.namePrefix, this.token.isDelimitedPrefix, 3);
                hsqlName.parent.schema = this.token.namePrePrefix == null ? this.session.getCurrentSchemaHsqlName() : this.database.nameManager.newHsqlName(this.token.namePrePrefix, this.token.isDelimitedPrePrefix, 3);
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(142);
        String string = this.readQuotedString();
        Object[] objectArray = new Object[]{hsqlName, string};
        return new StatementSchema(null, 1071, objectArray);
    }

    Statement compileAlterSession() {
        this.read();
        this.session.checkAdmin();
        if (this.token.tokenType == 623) {
            this.read();
            int n = this.token.tokenType;
            switch (this.token.tokenType) {
                case 2: {
                    this.read();
                    break;
                }
                case 236: {
                    this.read();
                    this.readThis(510);
                    break;
                }
                case 278: {
                    this.read();
                    this.readThis(378);
                    break;
                }
                default: {
                    throw this.unexpectedTokenRequire("ALL,RESULT,TABLE");
                }
            }
            Object[] objectArray = new Object[]{this.session.getId(), n};
            return new StatementCommand(1005, objectArray);
        }
        long l = this.readBigint();
        Session session = this.database.sessionManager.getSession(l);
        if (session == null) {
            throw Error.error(4500);
        }
        int n = this.token.tokenType;
        switch (this.token.tokenType) {
            case 39: {
                this.read();
                break;
            }
            case 233: {
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] objectArray = new Object[]{l, n};
        return new StatementCommand(1005, objectArray);
    }

    boolean processTrueOrFalse() {
        if (this.token.namePrefix != null) {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 294) {
            this.read();
            return true;
        }
        if (this.token.tokenType == 106) {
            this.read();
            return false;
        }
        throw this.unexpectedToken();
    }

    Boolean processTrueOrFalseObject() {
        return this.processTrueOrFalse();
    }

    void checkSchemaUpdateAuthorisation(Session session, HsqlNameManager.HsqlName hsqlName) {
        if (session.isProcessingLog) {
            return;
        }
        if (SqlInvariants.isSystemSchemaName(hsqlName.name)) {
            throw Error.error(5503);
        }
        if (session.parser.isSchemaDefinition) {
            if (hsqlName == session.getCurrentSchemaHsqlName()) {
                return;
            }
            Error.error(5505, hsqlName.name);
        }
        session.getGrantee().checkSchemaUpdateOrGrantRights(hsqlName.name);
        session.checkDDLWrite();
    }
}

